/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import java.awt.image.BufferedImage;
import org.sunflow.core.Display;
import org.sunflow.image.Color;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;
import org.sunflow.system.ui.ConsoleInterface;

public class BakingDisplay
implements Display,
UserInterface {
    private BufferedImage image;
    private int[] pixels;
    private ConsoleInterface console;
    private Appearance app;
    private int min;
    private int max;
    private float invP;
    private int lastP;
    private int frameCount = 10;

    public BakingDisplay(Appearance app) {
        this.app = app;
        this.console = new ConsoleInterface();
    }

    public void print(UI.Module m, UI.PrintLevel level, String s) {
        this.console.print(m, level, s);
    }

    public void taskStart(String s, int min, int max) {
        this.min = min;
        this.max = max;
        this.invP = (float)this.frameCount / (float)(max - min);
        this.console.taskStart(s, min, max);
    }

    public void taskStop() {
        this.console.taskStop();
    }

    public void taskUpdate(int current) {
        int p;
        int n = p = this.min == this.max ? 0 : (int)((float)(current - this.min) * this.invP);
        if (this.image != null && p != this.lastP) {
            this.lastP = p;
            this.updateTexture();
        }
        this.console.taskUpdate(current);
    }

    private void updateTexture() {
        this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.pixels, 0, this.image.getWidth());
        ImageData img = new ImageData(this.image);
        Texture2D tex = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "lightMap", this.app, false);
        tex.setApplyMode(8448);
        tex.setImage(img);
        Matrix texMat = MatrixBuilder.euclidean().scale(1.0, -1.0, 1.0).getMatrix();
        tex.setTextureMatrix(texMat);
    }

    public synchronized void imageBegin(int w, int h, int bucketSize) {
        if (this.image == null || w != this.image.getWidth() || h != this.image.getHeight()) {
            this.pixels = new int[w * h];
            this.image = new BufferedImage(w, h, 2);
        }
    }

    public void imagePrepare(int x, int y, int w, int h, int id) {
    }

    public void imageUpdate(int x, int y, int w, int h, Color[] data) {
        int iw = this.image.getWidth();
        int off = x + iw * y;
        iw -= w;
        int j = 0;
        int index = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                this.pixels[off] = 0xFF000000 | data[index].toRGB();
                ++i;
                ++index;
                ++off;
            }
            ++j;
            off += iw;
        }
    }

    public void imageFill(int x, int y, int w, int h, Color c) {
        int iw = this.image.getWidth();
        int off = x + iw * y;
        iw -= w;
        int rgb = 0xFF000000 | c.toRGB();
        int j = 0;
        int index = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                this.pixels[off] = rgb;
                ++i;
                ++index;
                ++off;
            }
            ++j;
            off += iw;
        }
    }

    public synchronized void imageEnd() {
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }
}

