/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.backends.texture.Texture;
import de.jreality.math.Rn;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.shader.PolygonShader;

public class TwoSidePolygonShader
extends PolygonShader {
    private PolygonShader front;
    private PolygonShader back;

    public TwoSidePolygonShader(de.jreality.shader.TwoSidePolygonShader ps, RenderingHintsShader rhs) {
        this.front = PolygonShader.createFrom(ps.getFront(), rhs);
        this.back = PolygonShader.createFrom(ps.getBack(), rhs);
    }

    public TwoSidePolygonShader(PolygonShader f, PolygonShader b) {
        this.front = f;
        this.back = b;
    }

    public final void shadePolygon(Polygon p, Environment environment, boolean vertexColors) {
        boolean faceforward;
        double[] vd = p.getPoint(0);
        double px = vd[4];
        double py = vd[5];
        double pz = vd[6];
        double[] d1 = new double[3];
        vd = p.getPoint(1);
        d1[0] = vd[4] - px;
        d1[1] = vd[5] - py;
        d1[2] = vd[6] - pz;
        double[] d2 = new double[3];
        vd = p.getPoint(p.getLength() - 1);
        d2[0] = vd[4] - px;
        d2[1] = vd[5] - py;
        d2[2] = vd[6] - pz;
        boolean bl = faceforward = px * (d1 = Rn.crossProduct(null, d1, d2))[0] + py * d1[1] + pz * d1[2] >= 0.0;
        if (faceforward) {
            this.front.shadePolygon(p, environment, vertexColors);
        } else {
            this.back.shadePolygon(p, environment, vertexColors);
        }
    }

    public final boolean interpolateColor() {
        return false;
    }

    public boolean interpolateAlpha() {
        return false;
    }

    public boolean isOutline() {
        return false;
    }

    public void setOutline(boolean outline) {
    }

    public Texture getTexture() {
        return null;
    }

    public boolean hasTexture() {
        return false;
    }

    public boolean needsSorting() {
        return false;
    }

    public double getBlue() {
        return this.front.getBlue();
    }

    public double getGreen() {
        return this.front.getGreen();
    }

    public double getRed() {
        return this.front.getRed();
    }

    public void setColor(double r, double g, double b) {
        this.front.setColor(r, g, b);
    }
}

