/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.backends.texture.SimpleTexture;
import de.jreality.backends.texture.Texture;
import de.jreality.shader.ImageData;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class EtchTexture
implements Texture {
    static SimpleTexture etch1;
    static SimpleTexture etch2;
    static SimpleTexture etch3;
    double scaleU = 0.02;
    double scaleV = 0.02;
    public final int transparency = 255;

    public void getColor(double u, double v, double nx, double ny, double nz, int x, int y, double[] color) {
        double value = (color[0] + color[1] + color[2]) / 3.0;
        color[2] = 255.0;
        color[1] = 255.0;
        color[0] = 255.0;
        color[3] = 255.0;
        u = 4.0 * (double)x / 314.0;
        v = 4.0 * (double)y / 314.0;
        if (value > 250.0) {
            return;
        }
        if (value > 160.0) {
            etch1.getColor(u, v, nx, ny, nz, x, y, color);
            return;
        }
        if (value > 80.0) {
            etch2.getColor(u, v, nx, ny, nz, x, y, color);
            return;
        }
        if (value > 5.0) {
            etch3.getColor(u, v, nx, ny, nz, x, y, color);
            return;
        }
        color[2] = 0.0;
        color[1] = 0.0;
        color[0] = 0.0;
        color[3] = 255.0;
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean needsNormals() {
        return false;
    }

    public void getMipMapedColor(double u, double dxu, double dyu, double v, double dxv, double dyv, double nx, double ny, double nz, int x, int y, double[] color) {
        this.getColor(u, v, nx, ny, nz, x, y, color);
    }

    static {
        BufferedImage img;
        try {
            img = ImageIO.read(EtchTexture.class.getResource("hatch4.png"));
            etch1 = new SimpleTexture(new ImageData(img), false, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            img = ImageIO.read(EtchTexture.class.getResource("hatch5.png"));
            etch2 = new SimpleTexture(new ImageData(img), false, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            img = ImageIO.read(EtchTexture.class.getResource("hatch6.png"));
            etch3 = new SimpleTexture(new ImageData(img), false, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

