/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.softviewer.DirectionalLightSoft;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.SpotLightSoft;
import de.jreality.softviewer.shader.VertexShader;
import java.awt.Color;

public class DefaultVertexShader
extends VertexShader {
    private double phongSize = 8.0;
    private double phong = 0.7;
    private double red = 0.4;
    private double green = 0.4;
    private double blue = 0.6;
    private double transparency = 0.0;

    public DefaultVertexShader() {
    }

    public DefaultVertexShader(Color c, double phong, double phongSize, double transparency) {
        float[] rgb = c.getComponents(null);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        this.transparency = transparency;
        this.phong = phong;
        this.phongSize = phongSize;
    }

    public final void shadeVertex(double[] vd, Environment environment, boolean vertexColors) {
        double a;
        vertexColors |= this.vertexColors;
        double nx = vd[14];
        double ny = vd[15];
        double nz = vd[16];
        double px = vd[0];
        double py = vd[1];
        double pz = vd[2];
        double pw = vd[3];
        double cdr = 0.0;
        double cdg = 0.0;
        double cdb = 0.0;
        double csr = 0.0;
        double csg = 0.0;
        double csb = 0.0;
        double normalflip = (px * nx + py * ny + pz * nz) * pw <= 0.0 ? 1.0 : -1.0;
        int dirLightCount = environment.getNumDirectionalLights();
        DirectionalLightSoft[] directionalLights = environment.getDirectionalLights();
        for (int i = 0; i < dirLightCount; ++i) {
            DirectionalLightSoft light = directionalLights[i];
            double[] dl = light.getDirection();
            double lx = dl[0];
            double ly = dl[1];
            double lz = dl[2];
            double lr = light.getRed();
            double lg = light.getGreen();
            double lb = light.getBlue();
            double intensity = light.getIntensity();
            double ntl = nx * lx + ny * ly + nz * lz;
            double fac = normalflip * ntl;
            if (fac < 0.0) continue;
            cdr += lr * (fac *= intensity);
            cdg += lg * fac;
            cdb += lb * fac;
            double t = 2.0 * ntl * nz - lz;
            if (!(t > 0.0)) continue;
            t = intensity * Math.pow(t, this.phongSize);
            csr += lr * t;
            csg += lg * t;
            csb += lb * t;
        }
        int spotLightCount = environment.getNumSpotLights();
        SpotLightSoft[] spotlights = environment.getSpotLights();
        for (int i = 0; i < spotLightCount; ++i) {
            double ntl;
            double fac;
            double cosCone;
            double dst;
            double cosAngle;
            SpotLightSoft light = spotlights[i];
            double[] dl = light.getDirection();
            double dx = dl[0];
            double dy = dl[1];
            double dz = dl[2];
            double[] src = light.getSource();
            double lx = src[0] - px;
            double ly = src[1] - py;
            double lz = src[2] - pz;
            if ((cosAngle = (lx /= (dst = Math.sqrt(lx * lx + ly * ly + lz * lz))) * dx + (ly /= dst) * dy + (lz /= dst) * dz) < (cosCone = light.getCosConeAngle())) continue;
            double lr = light.getRed();
            double lg = light.getGreen();
            double lb = light.getBlue();
            double intensity = 1.0 * light.getIntensity() / (light.getA0() + (light.getA1() + light.getA2() * dst) * dst);
            double softFrac = light.getSoftEdgeFraction();
            if (cosAngle - cosCone < softFrac) {
                intensity *= (cosAngle - cosCone) / softFrac;
            }
            if ((fac = normalflip * (ntl = nx * lx + ny * ly + nz * lz)) < 0.0) continue;
            cdr += lr * (fac *= intensity);
            cdg += lg * fac;
            cdb += lb * fac;
            double t = 2.0 * ntl * nz - lz;
            if (!(t > 0.0)) continue;
            t = intensity * Math.pow(t, this.phongSize);
            csr += lr * t;
            csg += lg * t;
            csb += lb * t;
        }
        if (vertexColors) {
            cdr *= vd[8];
            cdg *= vd[9];
            cdb *= vd[10];
            a = vd[11];
        } else {
            cdr *= this.red;
            cdg *= this.green;
            cdb *= this.blue;
            a = this.transparency;
        }
        cdr += this.phong * csr;
        cdg += this.phong * csg;
        cdb += this.phong * csb;
        double ff = environment.getFogfactor();
        if (ff != 0.0) {
            double d = Math.exp(-Math.sqrt(px * px + py * py + pz * pz) * ff);
            double dm = 1.0 - d;
            double[] fc = environment.getFogColor();
            cdr = cdr * d + dm * fc[0];
            cdg = cdg * d + dm * fc[1];
            cdb = cdb * d + dm * fc[2];
        }
        vd[8] = cdr;
        vd[9] = cdg;
        vd[10] = cdb;
        vd[11] = a;
    }

    public final double getTransparency() {
        return this.transparency;
    }

    public final void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public void setColor(double r, double g, double b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getGreen() {
        return this.green;
    }

    public double getRed() {
        return this.red;
    }
}

