/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer.shader;

import de.jreality.backends.texture.EnvironmentTexture;
import de.jreality.backends.texture.SimpleTexture;
import de.jreality.backends.texture.Texture;
import de.jreality.scene.Geometry;
import de.jreality.shader.CubeMap;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.Texture2D;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.VecMat;
import de.jreality.softviewer.shader.ConstantVertexShader;
import de.jreality.softviewer.shader.PolygonShader;
import de.jreality.softviewer.shader.VertexShader;

public class ConstantPolygonShader
extends PolygonShader {
    private boolean interpolateColor = false;
    protected VertexShader vertexShader;
    protected boolean outline = false;
    private final boolean needsNormals;
    private final DefaultPolygonShader ps;

    public ConstantPolygonShader() {
        this(new ConstantVertexShader(0.0, 0.0, 0.0));
    }

    private ConstantPolygonShader(VertexShader v) {
        this.vertexShader = v;
        this.ps = null;
        this.needsNormals = false;
    }

    public ConstantPolygonShader(DefaultPolygonShader ps) {
        CubeMap cm;
        this.vertexShader = new ConstantVertexShader(ps.getDiffuseColor(), ps.getTransparency());
        this.ps = ps;
        Texture2D tex = ps.getTexture2d();
        if (tex != null && tex.getImage() != null) {
            this.texture = new SimpleTexture(tex);
        }
        if ((cm = ps.getReflectionMap()) != null) {
            this.texture = new EnvironmentTexture(cm, this.texture);
            this.needsNormals = true;
        } else {
            this.needsNormals = false;
        }
    }

    public void shadePolygon(Polygon p, Environment environment, boolean vertexColors) {
        p.setTransparency(this.vertexShader.getTransparency());
        p.setTexture(this.texture);
        p.setInterpolateAlpha(this.interpolateAlpha());
        p.setInterpolateColor(this.interpolateColor());
        p.setSkybox(false);
        int n = p.getLength();
        double[] v = p.getCenter();
        this.vertexShader.shadeVertex(v, environment, vertexColors);
        if (this.needsNormals) {
            for (int i = 0; i < n; ++i) {
                double[] vertexData = p.getPoint(i);
                this.vertexShader.shadeVertex(vertexData, environment, vertexColors);
                double ff = (vertexData[0] * vertexData[14] + vertexData[1] * vertexData[15] + vertexData[2] * vertexData[16]) / (vertexData[14] * vertexData[14] + vertexData[15] * vertexData[15] + vertexData[16] * vertexData[16]);
                double[] m = environment.getCameraWorld();
                VecMat.transformUnNormalized(m, -2.0 * ff * vertexData[14] + vertexData[0], -2.0 * ff * vertexData[15] + vertexData[1], -2.0 * ff * vertexData[16] + vertexData[2], vertexData, 14);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double[] vertexData = p.getPoint(i);
                this.vertexShader.shadeVertex(vertexData, environment, vertexColors);
            }
        }
    }

    public final VertexShader getVertexShader() {
        return this.vertexShader;
    }

    public final boolean interpolateColor() {
        return this.hasTexture() || this.vertexShader.isVertexColors();
    }

    public boolean interpolateAlpha() {
        return this.vertexShader.interpolateAlpha();
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void startGeometry(Geometry geom) {
        if (this.vertexShader != null) {
            this.vertexShader.startGeometry(geom);
        }
    }

    public boolean needsSorting() {
        return this.vertexShader.getTransparency() != 0.0 || this.hasTexture() && this.texture.isTransparent() || this.interpolateAlpha();
    }

    public void setColor(double r, double g, double b) {
        this.vertexShader.setColor(r, g, b);
    }

    public double getBlue() {
        return this.vertexShader.getBlue();
    }

    public double getGreen() {
        return this.vertexShader.getGreen();
    }

    public double getRed() {
        return this.vertexShader.getRed();
    }
}

