/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.softviewer.ArrayStack;
import de.jreality.softviewer.CameraProjection;
import de.jreality.softviewer.ClippingPlaneSoft;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.PerspectiveProjection;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.PolygonUtility;
import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.TriangleComparator;
import de.jreality.softviewer.TriangleRasterizer;
import de.jreality.softviewer.VecMat;
import de.jreality.softviewer.shader.ConstantVertexShader;
import de.jreality.softviewer.shader.DefaultPolygonShader;
import de.jreality.softviewer.shader.LineShader;
import de.jreality.softviewer.shader.PointShader;
import de.jreality.softviewer.shader.PolygonShader;
import de.jreality.softviewer.shader.VertexShader;
import java.util.Arrays;

public class TrianglePipeline {
    private final boolean queueOpaque;
    private final boolean sortOpaque;
    private final boolean useTexCoords = true;
    private double[] matrix;
    private double[] inverseTransposeMatrix = new double[16];
    Polygon polygon = new Polygon(4);
    Polygon tmpPolygon = new Polygon(4);
    ArrayStack freeTriangles = new ArrayStack(1000);
    ArrayStack triangles = new ArrayStack(1000);
    protected TriangleComparator comp = new TriangleComparator();
    private CameraProjection perspective = new PerspectiveProjection();
    private Environment environment;
    private PolygonShader faceShader;
    private LineShader lineShader;
    private VertexShader constantVertexShader = new ConstantVertexShader(0.0, 0.0, 0.0);
    private PolygonShader constantLineShader = new DefaultPolygonShader(this.constantVertexShader);
    private PointShader pointShader;
    private PolygonShader shader;
    private double[] pointVertices = new double[48];
    private DoubleArrayArray pointVerticesDataList = new DoubleArrayArray.Inlined(this.pointVertices, 3);
    private static int[] pointIndices = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private IntArray pointIndicesDataList = new IntArray(pointIndices);
    private static int[][] pointOutlineIndices = new int[][]{{0, 8, 9, 1}, {1, 9, 10, 2}, {2, 10, 11, 3}, {3, 11, 12, 4}, {4, 12, 13, 5}, {5, 13, 14, 6}, {6, 14, 15, 7}, {7, 15, 8, 0}};
    private IntArrayArray pointOutlineIndicesDataList = new IntArrayArray.Array(pointOutlineIndices);
    private static double[][] pointColors = new double[16][4];
    private DoubleArrayArray pointColorsDataList = new DoubleArrayArray.Array(pointColors);
    private static double[][] lineFaceColors = new double[1][4];
    private DoubleArrayArray lineFaceColorsDataList = new DoubleArrayArray.Array(lineFaceColors);
    private static int[] pointNormals = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private IntArray pointNormalsDataList = new IntArray(pointNormals);
    private static int[][] pointOutlineNormals = new int[][]{{0, 1, 2, 0}, {0, 2, 3, 0}, {0, 3, 4, 0}, {0, 4, 5, 0}, {0, 5, 6, 0}, {0, 6, 7, 0}, {0, 7, 8, 0}, {0, 8, 1, 0}};
    private IntArrayArray pointOutlineNormalsDataList = new IntArrayArray.Array(pointOutlineNormals);
    private static double[] zNormal = new double[27];
    private DoubleArrayArray zNormalDataList = new DoubleArrayArray.Inlined(zNormal, 3);
    private static int[] lineIndices = new int[]{0, 1, 2, 3};
    private IntArray lineIndicesDataList = new IntArray(lineIndices);
    protected final TriangleRasterizer rasterizer;
    Triangle[] trisFromPoly = new Triangle[6];
    private double[] point0 = new double[4];
    private double[] normal0 = new double[3];
    private double[] point1 = new double[4];
    private double[] normal1 = new double[3];
    private DoubleArrayArray normal1DataList = new DoubleArrayArray.Inlined(this.normal1, 3);
    private double[] substMatrix = new double[16];
    private static final DoubleArrayArray procPointNormalData = new DoubleArrayArray.Array(new double[][]{{0.0, 0.0, 1.0}});
    private static final IntArray procPointNormals = new IntArray(new int[]{0, 0, 0, 0});
    private static final DoubleArray zNormalDoubleArray = new DoubleArray(new double[]{0.0, 0.0, 1.0});
    private static final double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private double[] line = new double[12];
    DoubleArrayArray lineDataList = new DoubleArrayArray.Inlined(this.line, 3);
    private double[] direction = new double[3];
    private static final IntArray procLineVertices = new IntArray(new int[]{0, 0, 1, 1});
    private static final IntArray procLineNormals = new IntArray(new int[]{0, 0, 0, 0});
    private static final DoubleArray faceNormalDataList = new DoubleArray(new double[]{0.0, 0.0, 1.0});
    private double[] normal2 = new double[6];
    private DoubleArrayArray normal2DataList = new DoubleArrayArray.Inlined(this.normal2, 3);
    private static int[] nIndices = new int[]{0, 1, 1, 0};
    private final IntArray nIndicesDataList = new IntArray(nIndices);
    private static final double cs = Math.cos(0.2);
    private static final double ss = Math.sin(0.2);
    private double[] zzNormal = new double[3];
    private boolean transparencyEnabled;

    public TrianglePipeline(TriangleRasterizer rasterizer) {
        this(rasterizer, false);
    }

    public TrianglePipeline(TriangleRasterizer rasterizer, boolean sortAll) {
        this.sortOpaque = sortAll;
        this.queueOpaque = sortAll;
        this.rasterizer = rasterizer;
        TrianglePipeline.zNormal[0] = 0.0;
        TrianglePipeline.zNormal[1] = 0.0;
        TrianglePipeline.zNormal[2] = 1.0;
        for (int i = 0; i < 8; ++i) {
            int pos = 3 * i;
            double d = Math.cos(2.0 * (double)i * Math.PI / 8.0);
            TrianglePipeline.zNormal[pos + 3] = d;
            this.pointVertices[pos] = d;
            double d2 = Math.sin(2.0 * (double)i * Math.PI / 8.0);
            TrianglePipeline.zNormal[pos + 4] = d2;
            this.pointVertices[pos + 1] = d2;
            TrianglePipeline.zNormal[pos + 5] = 0.01;
        }
    }

    public final void clearPipeline() {
        this.faceShader = null;
        this.lineShader = null;
        this.pointShader = null;
    }

    final void startGeometry(Geometry geom) {
        if (this.lineShader != null) {
            this.lineShader.startGeometry(geom);
        }
        if (this.faceShader != null) {
            this.faceShader.startGeometry(geom);
        }
        if (this.pointShader != null) {
            this.pointShader.startGeometry(geom);
        }
    }

    public final void processPolygon(DoubleArrayArray vd, IntArray vertices, DoubleArrayArray nd, IntArray normals, DataList texCoords, DataList vertexColors, DoubleArray faceNormal, DoubleArray faceColor) {
        if (this.faceShader == null) {
            return;
        }
        this.shader = this.faceShader;
        this.process(vd, vertices, nd, normals, texCoords, vertexColors, faceNormal, faceColor, true);
    }

    private final void process(DoubleArrayArray vd, IntArray vertices, DoubleArrayArray nd, IntArray normals, DataList texCoords, DataList vertexColors, DoubleArray faceNormal, DoubleArray faceColor, boolean transform) {
        this.polygon.setLength(0);
        this.tmpPolygon.setLength(0);
        this.fillVertexData(vd, vertices, nd, normals, texCoords, vertexColors, faceNormal, faceColor, transform);
        this.shader.shadePolygon(this.polygon, this.environment, vertexColors != null | faceColor != null);
        if (this.clipPlanes()) {
            return;
        }
        this.computePerspective();
        if (this.clipFrustum()) {
            return;
        }
        this.triangulateAndRaster();
    }

    private void triangulateAndRaster() {
        boolean isTransparent = this.transparencyEnabled && this.shader.needsSorting();
        int n = this.polygon.getLength() - 2;
        this.trisFromPoly = this.polygon.triangulate(this.trisFromPoly, this.freeTriangles);
        for (int i = 0; i < n; ++i) {
            Triangle tri = this.trisFromPoly[i];
            if (this.queueOpaque || isTransparent) {
                if (!this.sortOpaque && !isTransparent) continue;
                this.triangles.push(tri);
                continue;
            }
            this.rasterizer.renderTriangle(tri, false);
            this.freeTriangles.push(tri);
        }
    }

    private boolean clipPlanes() {
        int numClip = this.environment.getNumClippingPlanes();
        if (numClip > 0) {
            for (int k = 0; k < numClip; ++k) {
                ClippingPlaneSoft cp = this.environment.getClippingPlane(k);
                double d = VecMat.dot(cp.getNormal(), cp.getPoint());
                int res = PolygonUtility.clipToHalfspace(this.polygon, 0, cp.getNormal(), -1, d, this.tmpPolygon);
                if (res == -1) {
                    return true;
                }
                if (res != 1) continue;
                this.tmpPolygon.setShadingFrom(this.polygon);
                Polygon r = this.polygon;
                this.polygon = this.tmpPolygon;
                this.tmpPolygon = r;
            }
        }
        return false;
    }

    private void computePerspective() {
        for (int i = 0; i < this.polygon.getLength(); ++i) {
            this.perspective.perspective(this.polygon.getPoint(i));
        }
    }

    private final void fillVertexData(DoubleArrayArray vd, IntArray vertices, DoubleArrayArray nd, IntArray normals, DataList texCoords, DataList vertexColors, DoubleArray faceNormal, DoubleArray faceColor, boolean transform) {
        boolean buildFaceNormal;
        if (vertices.getLength() == 2) {
            this.processLine(vd.item(vertices.getValueAt(0)).toDoubleArray(), vd.item(vertices.getValueAt(1)).toDoubleArray(), null);
            return;
        }
        int vertexColorLength = vertexColors != null ? vertexColors.item(0).size() : 0;
        boolean r3 = vd.getLengthAt(0) == 3;
        double[] center = this.polygon.getCenter();
        if (faceNormal != null) {
            if (transform) {
                VecMat.transformNormal(this.inverseTransposeMatrix, faceNormal.getValueAt(0), faceNormal.getValueAt(1), faceNormal.getValueAt(2), center, 14);
            } else {
                center[14] = faceNormal.getValueAt(0);
                center[15] = faceNormal.getValueAt(1);
                center[16] = faceNormal.getValueAt(2);
            }
        }
        boolean bl = buildFaceNormal = faceNormal == null && !this.shader.interpolateColor();
        if (faceColor != null) {
            center[8] = faceColor.getValueAt(0);
            center[9] = faceColor.getValueAt(1);
            center[10] = faceColor.getValueAt(2);
            if (faceColor.size() == 4) {
                center[11] = faceColor.getValueAt(3);
            }
        }
        int n = vertices.getLength();
        for (int i = 0; i < n; ++i) {
            int vi = vertices.getValueAt(i);
            DoubleArray vertex = vd.item(vi).toDoubleArray();
            double[] vertexData = this.polygon.getPoint(i);
            DoubleArray normal = null;
            if (nd != null) {
                int ni = normals.getValueAt(i);
                normal = nd.item(ni).toDoubleArray();
            } else {
                normal = faceNormal;
            }
            if (transform) {
                if (r3) {
                    VecMat.transform(this.matrix, vertex.getValueAt(0), vertex.getValueAt(1), vertex.getValueAt(2), vertexData, 0);
                    vertexData[3] = 1.0;
                } else {
                    VecMat.transform(this.matrix, vertex.getValueAt(0), vertex.getValueAt(1), vertex.getValueAt(2), vertex.getValueAt(3), vertexData, 0);
                    if (vertexData[3] != 0.0) {
                        double d = vertexData[3];
                        vertexData[0] = vertexData[0] / d;
                        vertexData[1] = vertexData[1] / d;
                        vertexData[2] = vertexData[2] / d;
                        vertexData[3] = 1.0;
                    }
                }
                if (normal != null) {
                    VecMat.transformNormal(this.inverseTransposeMatrix, normal.getValueAt(0), normal.getValueAt(1), normal.getValueAt(2), vertexData, 14);
                }
            } else {
                vertexData[0] = vertex.getValueAt(0);
                vertexData[1] = vertex.getValueAt(1);
                vertexData[2] = vertex.getValueAt(2);
                vertexData[3] = 1.0;
                vertexData[14] = normal.getValueAt(0);
                vertexData[15] = normal.getValueAt(1);
                vertexData[16] = normal.getValueAt(2);
            }
            if (buildFaceNormal) {
                center[14] = 0.0;
                center[15] = 0.0;
                center[16] = 0.0;
                center[14] = center[14] + vertexData[14];
                center[14] = center[14] + vertexData[14];
                center[15] = center[15] + vertexData[15];
                center[16] = center[16] + vertexData[16];
            }
            if (vertexColors != null) {
                DoubleArray color = vertexColors.item(vi).toDoubleArray();
                vertexData[8] = color.getValueAt(0);
                vertexData[9] = color.getValueAt(1);
                vertexData[10] = color.getValueAt(2);
                vertexData[11] = vertexColorLength == 4 || vertexColorLength == -1 && color.getLength() > 3 ? color.getValueAt(3) : 1.0;
            } else if (faceColor != null) {
                vertexData[8] = faceColor.getValueAt(0);
                vertexData[9] = faceColor.getValueAt(1);
                vertexData[10] = faceColor.getValueAt(2);
                if (faceColor.size() == 4) {
                    vertexData[11] = faceColor.getValueAt(3);
                }
            }
            if (texCoords == null) continue;
            DoubleArray tc = texCoords.item(vi).toDoubleArray();
            vertexData[12] = tc.getValueAt(0);
            vertexData[13] = tc.getValueAt(1);
        }
        if (buildFaceNormal) {
            VecMat.normalize(center, 14);
        }
    }

    private final boolean clipFrustum() {
        int x0out = 0;
        int x1out = 0;
        int y0out = 0;
        int y1out = 0;
        int z0out = 0;
        int z1out = 0;
        int n = this.polygon.getLength();
        this.tmpPolygon.setLength(0);
        for (int i = 0; i < n; ++i) {
            double[] v = this.polygon.getPoint(i);
            double vsw = v[7];
            if (v[4] < this.perspective.getFrustumXmin() * vsw) {
                ++x0out;
            }
            if (v[4] > this.perspective.getFrustumXmax() * vsw) {
                ++x1out;
            }
            if (v[5] < this.perspective.getFrustumYmin() * vsw) {
                ++y0out;
            }
            if (v[5] > this.perspective.getFrustumYmax() * vsw) {
                ++y1out;
            }
            if (v[6] < this.perspective.getFrustumZmin() * vsw) {
                ++z0out;
            }
            if (!(v[6] > this.perspective.getFrustumZmax() * vsw)) continue;
            ++z1out;
        }
        if (x0out + x1out + y0out + y1out + z0out + z1out == 0) {
            return false;
        }
        if (x0out == n || x1out == n || y0out == n || y1out == n || z0out == n || z1out == n) {
            return true;
        }
        this.tmpPolygon.setShadingFrom(this.polygon);
        if (x0out != 0) {
            this.clipToHalfspace(4, -1, -this.perspective.getFrustumXmin());
        }
        if (x1out != 0) {
            this.clipToHalfspace(4, 1, this.perspective.getFrustumXmax());
        }
        if (y0out != 0) {
            this.clipToHalfspace(5, -1, -this.perspective.getFrustumYmin());
        }
        if (y1out != 0) {
            this.clipToHalfspace(5, 1, this.perspective.getFrustumYmax());
        }
        if (z0out != 0) {
            this.clipToHalfspace(6, -1, -this.perspective.getFrustumZmin());
        }
        if (z1out != 0) {
            this.clipToHalfspace(6, 1, this.perspective.getFrustumZmax());
        }
        return this.polygon.getLength() == 0;
    }

    private void clipToHalfspace(int index, int sign, double k) {
        this.tmpPolygon.setLength(0);
        int length = this.polygon.getLength();
        if (length == 0) {
            return;
        }
        double[] u = this.polygon.getPoint(length - 1);
        double[] v = this.polygon.getPoint(0);
        double tu = (double)sign * u[index] - k * u[7];
        double tv = 0.0;
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            if (tu <= 0.0 ^ (tv = (double)sign * (v = this.polygon.getPoint(i))[index] - k * v[7]) <= 0.0) {
                double t = tu / (tu - tv);
                double[] vertexData = this.tmpPolygon.getPoint(pos++);
                for (int j = 0; j < 17; ++j) {
                    vertexData[j] = u[j] + t * (v[j] - u[j]);
                }
            }
            if (tv <= 0.0) {
                this.tmpPolygon.setPointFrom(pos++, v);
            }
            u = v;
            tu = tv;
        }
        Polygon r = this.polygon;
        this.polygon = this.tmpPolygon;
        this.tmpPolygon = r;
    }

    public final void setMatrix(double[] matrix) {
        this.matrix = matrix;
        Rn.transpose(this.inverseTransposeMatrix, matrix);
        Rn.inverse(this.inverseTransposeMatrix, this.inverseTransposeMatrix);
        this.environment.setMatrix(matrix);
    }

    public final void sortTriangles() {
        Arrays.sort(this.triangles.getArray(), 0, this.triangles.getSize(), this.comp);
    }

    public final CameraProjection getPerspective() {
        return this.perspective;
    }

    public final void setPerspective(CameraProjection perspective) {
        this.perspective = perspective;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private final void rasterRemaining() {
        this.sortTriangles();
        this.rasterizer.setTransparencyEnabled(true);
        while (!this.triangles.isEmpty()) {
            Triangle tri = this.triangles.pop();
            this.rasterizer.renderTriangle(tri, false);
            this.freeTriangles.push(tri);
        }
    }

    public final void processPseudoSphere(double[] data, int index, int length) {
        if (this.pointShader == null) {
            return;
        }
        double r = this.pointShader.getPointRadius();
        if (length == 4) {
            this.processPseudoSphere(data[index], data[index + 1], data[index + 2], data[index + 3], r, null);
        } else {
            this.processPseudoSphere(data[index], data[index + 1], data[index + 2], 1.0, r, null);
        }
    }

    public final void processPseudoSphere(DoubleArrayArray data, int index, DataList vertexColors, DataList vertexRadii) {
        DoubleArray da = data.item(index).toDoubleArray();
        double w = 1.0;
        if (da.size() == 4) {
            w = da.getValueAt(3);
        }
        if (vertexColors != null) {
            DoubleArray color = vertexColors.item(index).toDoubleArray();
            for (int i = 0; i < 16; ++i) {
                TrianglePipeline.pointColors[i][0] = color.getValueAt(0);
                TrianglePipeline.pointColors[i][1] = color.getValueAt(1);
                TrianglePipeline.pointColors[i][2] = color.getValueAt(2);
                TrianglePipeline.pointColors[i][3] = color.size() > 3 ? color.getValueAt(3) : 1.0;
            }
        }
        double r = vertexRadii != null ? vertexRadii.toDoubleArray().getValueAt(index) : this.pointShader.getPointRadius();
        this.processPseudoSphere(da.getValueAt(0), da.getValueAt(1), da.getValueAt(2), w, r, vertexColors != null ? this.pointColorsDataList : null);
    }

    public final void processPseudoSphere(double x, double y, double z, double w, double pointRadius, DataList pointColors) {
        if (this.pointShader == null) {
            return;
        }
        VecMat.transform(this.matrix, x, y, z, w, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, pointRadius, this.normal0, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = this.substMatrix;
        double outlineFraction = this.pointShader.getOutlineFraction();
        double d = 1.0 - outlineFraction;
        double l = VecMat.norm(this.normal0);
        VecMat.assignScale(this.matrix, l * d);
        this.matrix[3] = this.point0[0];
        this.matrix[7] = this.point0[1];
        this.matrix[11] = this.point0[2] + pointRadius;
        Rn.transpose(this.inverseTransposeMatrix, this.matrix);
        Rn.inverse(this.inverseTransposeMatrix, this.inverseTransposeMatrix);
        this.shader = this.pointShader.getCoreShader();
        this.process(this.pointVerticesDataList, this.pointIndicesDataList, this.zNormalDataList, this.pointNormalsDataList, null, pointColors, null, null, true);
        if (outlineFraction > 0.0) {
            int i;
            this.shader = this.pointShader.getOutlineShader();
            d = 1.0 / d;
            for (i = 0; i < 24; i += 3) {
                this.pointVertices[24 + i] = this.pointVertices[i] * d;
                this.pointVertices[25 + i] = this.pointVertices[i + 1] * d;
                this.pointVertices[26 + i] = -d;
            }
            for (i = 0; i < 8; ++i) {
                this.process(this.pointVerticesDataList, this.pointOutlineIndicesDataList.item(i).toIntArray(), this.zNormalDataList, this.pointOutlineNormalsDataList.item(i).toIntArray(), null, this.pointColorsDataList, null, null, true);
            }
        }
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public final void processPoint(DoubleArrayArray data, int index, DataList vertexColors, DataList vertexRadii) {
        if (vertexColors != null) {
            DoubleArray color = vertexColors.item(index).toDoubleArray();
            this.constantVertexShader.setColor(color.getValueAt(0), color.getValueAt(1), color.getValueAt(2));
        } else {
            this.shader = this.pointShader.getCoreShader();
            this.constantVertexShader.setColor(this.shader.getRed(), this.shader.getGreen(), this.shader.getBlue());
        }
        this.shader = this.constantLineShader;
        this.polygon.setLength(0);
        this.tmpPolygon.setLength(0);
        IntArray vertices = new IntArray(new int[]{index, index, index, index});
        this.fillVertexData(data, vertices, procPointNormalData, procPointNormals, null, null, zNormalDoubleArray, null, true);
        this.shader.shadePolygon(this.polygon, this.environment, false);
        if (this.clipPlanes()) {
            return;
        }
        this.computePerspective();
        double minDim = this.rasterizer.getMinDim();
        double pointSize = this.pointShader.getPointSize();
        double[] f1 = this.polygon.getPoint(0);
        double[] f2 = this.polygon.getPoint(1);
        double[] t1 = this.polygon.getPoint(2);
        double[] t2 = this.polygon.getPoint(3);
        f1[4] = f1[4] + f1[7] * (pointSize /= minDim);
        f2[5] = f2[5] + f2[7] * pointSize;
        t1[4] = t1[4] - t1[7] * pointSize;
        t2[5] = t2[5] - t2[7] * pointSize;
        if (this.clipFrustum()) {
            return;
        }
        this.triangulateAndRaster();
    }

    public final void processLine(DoubleArray from, DoubleArray to, DataList vertexColours) {
        if (this.lineShader == null) {
            return;
        }
        this.shader = this.lineShader.getPolygonShader();
        this.constantVertexShader.setColor(this.shader.getRed(), this.shader.getGreen(), this.shader.getBlue());
        this.shader = this.constantLineShader;
        this.polygon.setLength(0);
        this.tmpPolygon.setLength(0);
        DoubleArrayArray.Array vd = new DoubleArrayArray.Array(new double[][]{from.toDoubleArray(null), to.toDoubleArray(null)});
        this.fillVertexData(vd, procLineVertices, this.zNormalDataList, procLineNormals, null, vertexColours, faceNormalDataList, null, true);
        this.shader.shadePolygon(this.polygon, this.environment, vertexColours != null);
        if (this.clipPlanes()) {
            return;
        }
        this.computePerspective();
        double lineWidth = this.lineShader.getLineWidth();
        double minDim = this.rasterizer.getMinDim();
        double[] f1 = this.polygon.getPoint(0);
        double[] f2 = this.polygon.getPoint(1);
        double[] t1 = this.polygon.getPoint(2);
        double[] t2 = this.polygon.getPoint(3);
        double fx = f1[4] * minDim / f1[7];
        double fy = f1[5] * minDim / f1[7];
        double tx = t1[4] * minDim / t1[7];
        double ty = t1[5] * minDim / t1[7];
        double dirx = tx - fx;
        double diry = ty - fy;
        double fac = lineWidth / Math.sqrt(dirx * dirx + diry * diry);
        f1[4] = f1[4] + -f1[7] * (diry *= fac / minDim);
        f1[5] = f1[5] + f1[7] * (dirx *= fac / minDim);
        f2[4] = f2[4] - -f2[7] * diry;
        f2[5] = f2[5] - f2[7] * dirx;
        t1[4] = t1[4] - -t1[7] * diry;
        t1[5] = t1[5] - t1[7] * dirx;
        t2[4] = t2[4] + -t2[7] * diry;
        t2[5] = t2[5] + t2[7] * dirx;
        if (this.clipFrustum()) {
            return;
        }
        this.triangulateAndRaster();
    }

    public final void processLineOld(DoubleArray from, DoubleArray to) {
        if (this.lineShader == null) {
            return;
        }
        this.shader = this.lineShader.getPolygonShader();
        double lineWidth = this.lineShader.getLineWidth();
        double w = 1.0;
        if (from.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, from.getValueAt(0), from.getValueAt(1), from.getValueAt(2), w, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, lineWidth, this.normal0, 0);
        w = 1.0;
        if (to.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, to.getValueAt(0), to.getValueAt(1), to.getValueAt(2), w, this.point1, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = identity;
        this.inverseTransposeMatrix = identity;
        this.direction[0] = this.point1[0] - this.point0[0];
        this.direction[1] = this.point1[1] - this.point0[1];
        this.direction[2] = this.point1[2] - this.point0[2];
        if (VecMat.norm(this.direction) == 0.0) {
            this.matrix = mat;
            this.inverseTransposeMatrix = tmat;
            return;
        }
        VecMat.normalize(this.direction);
        double length = VecMat.norm(this.normal0);
        VecMat.cross(this.direction, zNormal, this.normal0);
        VecMat.normalize(this.normal0);
        this.normal0[0] = this.normal0[0] * length;
        this.normal0[1] = this.normal0[1] * length;
        this.normal0[2] = this.normal0[2] * length;
        VecMat.cross(this.normal0, this.direction, this.normal1);
        VecMat.normalize(this.normal1);
        this.line[0] = this.point0[0] - this.normal0[0];
        this.line[1] = this.point0[1] - this.normal0[1];
        this.line[2] = this.point0[2] + length;
        this.line[3] = this.point0[0] + this.normal0[0];
        this.line[4] = this.point0[1] + this.normal0[1];
        this.line[5] = this.point0[2] + length;
        this.line[6] = this.point1[0] + this.normal0[0];
        this.line[7] = this.point1[1] + this.normal0[1];
        this.line[8] = this.point1[2] + length;
        this.line[9] = this.point1[0] - this.normal0[0];
        this.line[10] = this.point1[1] - this.normal0[1];
        this.line[11] = this.point1[2] + length;
        this.process(this.lineDataList, this.lineIndicesDataList, this.normal1DataList, this.pointNormalsDataList, null, null, null, null, true);
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public final void processPseudoTube(DoubleArray from, DoubleArray to, double lineWidth, DoubleArray colors) {
        if (this.lineShader == null) {
            return;
        }
        this.shader = this.lineShader.getPolygonShader();
        double w = 1.0;
        if (from.size() == 4) {
            w = from.getValueAt(3);
        }
        VecMat.transform(this.matrix, from.getValueAt(0), from.getValueAt(1), from.getValueAt(2), w, this.point0, 0);
        VecMat.transformUnNormalized(this.matrix, 0.0, 0.0, lineWidth, this.normal0, 0);
        w = 1.0;
        if (to.size() == 4) {
            w = to.getValueAt(3);
        }
        VecMat.transform(this.matrix, to.getValueAt(0), to.getValueAt(1), to.getValueAt(2), w, this.point1, 0);
        double[] mat = this.matrix;
        double[] tmat = this.inverseTransposeMatrix;
        this.matrix = identity;
        this.inverseTransposeMatrix = identity;
        this.direction[0] = this.point1[0] - this.point0[0];
        this.direction[1] = this.point1[1] - this.point0[1];
        this.direction[2] = this.point1[2] - this.point0[2];
        this.zzNormal[0] = this.point1[0] + this.point0[0];
        this.zzNormal[1] = this.point1[1] + this.point0[1];
        this.zzNormal[2] = this.point1[2] + this.point0[2];
        VecMat.normalize(this.zzNormal);
        if (VecMat.norm(this.direction) == 0.0) {
            this.matrix = mat;
            this.inverseTransposeMatrix = tmat;
            return;
        }
        VecMat.normalize(this.direction);
        double length = VecMat.norm(this.normal0);
        VecMat.cross(this.direction, this.zzNormal, this.normal0);
        VecMat.normalize(this.normal0);
        VecMat.cross(this.normal0, this.direction, this.normal1);
        this.normal0[0] = this.normal0[0] * length;
        this.normal0[1] = this.normal0[1] * length;
        this.normal0[2] = this.normal0[2] * length;
        VecMat.normalize(this.normal1);
        if (VecMat.dot(this.normal1, this.zzNormal) < 0.0) {
            this.normal1[0] = this.normal1[0] * -1.0;
            this.normal1[1] = this.normal1[1] * -1.0;
            this.normal1[2] = this.normal1[2] * -1.0;
            System.out.println("flip");
        }
        this.line[0] = this.point0[0] - this.normal0[0];
        this.line[1] = this.point0[1] - this.normal0[1];
        this.line[2] = this.point0[2];
        this.line[3] = this.point0[0];
        this.line[4] = this.point0[1];
        this.line[5] = this.point0[2] + length;
        this.line[6] = this.point1[0];
        this.line[7] = this.point1[1];
        this.line[8] = this.point1[2] + length;
        this.line[9] = this.point1[0] - this.normal0[0];
        this.line[10] = this.point1[1] - this.normal0[1];
        this.line[11] = this.point1[2];
        this.normal2[0] = cs / length * this.normal0[0] + ss * this.normal1[0];
        this.normal2[1] = cs / length * this.normal0[1] + ss * this.normal1[1];
        this.normal2[2] = ss * this.normal1[2];
        this.normal2[3] = this.normal1[0];
        this.normal2[4] = this.normal1[1];
        this.normal2[5] = this.normal1[2];
        this.process(this.lineDataList, this.lineIndicesDataList, this.normal2DataList, this.nIndicesDataList, null, null, null, colors, false);
        this.line[0] = this.point0[0];
        this.line[1] = this.point0[1];
        this.line[2] = this.point0[2] + length;
        this.line[3] = this.point0[0] + this.normal0[0];
        this.line[4] = this.point0[1] + this.normal0[1];
        this.line[5] = this.point0[2];
        this.line[6] = this.point1[0] + this.normal0[0];
        this.line[7] = this.point1[1] + this.normal0[1];
        this.line[8] = this.point1[2];
        this.line[9] = this.point1[0];
        this.line[10] = this.point1[1];
        this.line[11] = this.point1[2] + length;
        this.normal2[0] = this.normal1[0];
        this.normal2[1] = this.normal1[1];
        this.normal2[2] = this.normal1[2];
        this.normal2[3] = -cs / length * this.normal0[0] + ss * this.normal1[0];
        this.normal2[4] = -cs / length * this.normal0[1] + ss * this.normal1[1];
        this.normal2[5] = ss * this.normal1[2];
        this.process(this.lineDataList, this.lineIndicesDataList, this.normal2DataList, this.nIndicesDataList, null, null, null, colors, false);
        this.matrix = mat;
        this.inverseTransposeMatrix = tmat;
    }

    public PolygonShader getFaceShader() {
        return this.faceShader;
    }

    public void setFaceShader(PolygonShader faceShader) {
        this.faceShader = faceShader;
    }

    public LineShader getLineShader() {
        return this.lineShader;
    }

    public PointShader getPointShader() {
        return this.pointShader;
    }

    public void setLineShader(LineShader lineShader) {
        this.lineShader = lineShader;
    }

    public void setPointShader(PointShader pointShader) {
        this.pointShader = pointShader;
        if (pointShader != null) {
            // empty if block
        }
    }

    public void finish() {
        this.rasterRemaining();
    }

    public void transformNDC(double[] p1, double[] p2) {
        VecMat.transformUnNormalized(this.matrix, p2[0], p2[1], p2[2], p2);
        VecMat.transform(this.matrix, p1[0], p1[1], p1[2], p1);
        double r = VecMat.norm(p2);
        p2[0] = r + p1[0];
        p2[1] = p1[1];
        p2[2] = p1[2];
        this.perspective.perspective(p1);
        this.perspective.perspective(p2);
    }

    public void setTransparencyEnabled(boolean transparencyEnabled) {
        this.transparencyEnabled = transparencyEnabled;
        this.rasterizer.setTransparencyEnabled(transparencyEnabled);
    }
}

