/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.AbstractPolygon;

public class Triangle
extends AbstractPolygon {
    private final double[] p0 = new double[17];
    private final double[] p1 = new double[17];
    private final double[] p2 = new double[17];

    public final double[] getPoint(int i) {
        switch (i) {
            case 0: {
                return this.p0;
            }
            case 1: {
                return this.p1;
            }
            case 2: {
                return this.p2;
            }
        }
        throw new IllegalArgumentException("a triangle has only three points");
    }

    public final double[] getP1() {
        return this.p1;
    }

    public final double[] getP2() {
        return this.p2;
    }

    public final double[] getP0() {
        return this.p0;
    }

    public final double getP1(int i) {
        return this.p1[i];
    }

    public final double getP2(int i) {
        return this.p2[i];
    }

    public final double getP0(int i) {
        return this.p0[i];
    }

    public final void setP1(int i, double v) {
        this.p1[i] = v;
    }

    public final void setP2(int i, double v) {
        this.p2[i] = v;
    }

    public final void setP0(int i, double v) {
        this.p0[i] = v;
    }

    public final double getCenterZ() {
        return (this.p0[6] / this.p0[7] + this.p1[6] / this.p1[7] + this.p2[6] / this.p2[7]) / 3.0;
    }

    public int getLength() {
        return 3;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("t[\n");
        b.append(this.p0[0]);
        b.append(", ");
        b.append(this.p0[1]);
        b.append(", ");
        b.append(this.p0[2]);
        b.append(",\n");
        b.append(this.p1[0]);
        b.append(", ");
        b.append(this.p1[1]);
        b.append(", ");
        b.append(this.p1[2]);
        b.append(",\n");
        b.append(this.p2[0]);
        b.append(", ");
        b.append(this.p2[1]);
        b.append(", ");
        b.append(this.p2[2]);
        b.append("\n]");
        return b.toString();
    }
}

