/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.TriangleRasterizer;
import java.awt.Color;
import java.io.PrintWriter;

public class SVGRasterizer
extends TriangleRasterizer {
    public static final String NONE = "none";
    private boolean useGradients = false;
    private int background;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private double[][] triangle = new double[3][17];
    protected double transparency = 0.0;
    protected double oneMinusTransparency = 1.0;
    private PrintWriter writer;
    private int count;
    private double wh;
    private double hh;
    private double mh;
    private boolean transparencyEnabled;

    public SVGRasterizer(PrintWriter w) {
        this.writer = w;
    }

    public void renderTriangle(Triangle t, boolean outline) {
        this.transparency = t.getTransparency();
        if (!this.transparencyEnabled) {
            this.transparency = !(this.transparency < 1.0) ? 1 : 0;
        }
        this.oneMinusTransparency = 1.0 - this.transparency;
        double[] t0 = new double[17];
        for (int i = 0; i < 3; ++i) {
            double[] pi = this.triangle[i];
            double[] vertexData = t.getPoint(i);
            double w = 1.0 / vertexData[7];
            double wxy = w * this.mh;
            pi[4] = this.wh + vertexData[4] * wxy;
            pi[5] = this.hh - vertexData[5] * wxy;
            pi[6] = vertexData[6] * w;
            pi[8] = vertexData[8] > 1.0 ? 255.0 : 255.0 * vertexData[8];
            pi[9] = vertexData[9] > 1.0 ? 255.0 : 255.0 * vertexData[9];
            pi[10] = vertexData[10] > 1.0 ? 255.0 : 255.0 * vertexData[10];
            t0[4] = t0[4] + pi[4];
            t0[5] = t0[5] + pi[5];
            t0[6] = t0[6] + pi[6];
            t0[8] = t0[8] + pi[8];
            t0[9] = t0[9] + pi[9];
            t0[10] = t0[10] + pi[10];
        }
        t0[4] = t0[4] / 3.0;
        t0[5] = t0[5] / 3.0;
        t0[8] = t0[8] / 3.0;
        t0[9] = t0[9] / 3.0;
        t0[10] = t0[10] / 3.0;
        if (this.useGradients && t.isInterpolateColor()) {
            double[][] pol = new double[3][];
            pol[2] = t0;
            String t0Col = this.colorString((int)t0[8], (int)t0[9], (int)t0[10]);
            for (int n = 0; n < 2; ++n) {
                pol[0] = this.triangle[n];
                pol[1] = this.triangle[n + 1];
                this.writeGradients(pol);
                String col = "url(#" + this.count + "a)";
                col = t0Col;
                this.writePolygon(pol, 3, col, NONE);
                col = "url(#" + this.count + "b)";
                this.writePolygon(pol, 3, col, NONE);
                col = "url(#" + this.count + "c)";
                this.writePolygon(pol, 3, col, NONE);
                ++this.count;
            }
            pol[0] = this.triangle[2];
            pol[1] = this.triangle[0];
            this.writeGradients(pol);
            String col = "url(#" + this.count + "a)";
            col = t0Col;
            this.writePolygon(pol, 3, col, NONE);
            col = "url(#" + this.count + "b)";
            this.writePolygon(pol, 3, col, NONE);
            col = "url(#" + this.count + "c)";
            this.writePolygon(pol, 3, col, NONE);
            ++this.count;
        } else {
            String col = this.colorString((int)t0[8], (int)t0[9], (int)t0[10]);
            this.writePolygon(this.triangle, 3, col, NONE);
        }
        ++this.count;
    }

    private void writeGradients(double[][] p) {
        this.writeGradient(p[1], p[2], p[0], "" + this.count + "b");
        this.writeGradient(p[2], p[0], p[1], "" + this.count + "c");
    }

    private void writeGradient(double[] p0, double[] p1, double[] p2, String name) {
        double[] proj = this.project(p0, p1, p2);
        this.writer.print("<linearGradient gradientUnits=\"userSpaceOnUse\" ");
        this.writer.print("id=\"" + name + "\" ");
        this.writer.print("x1=\"" + proj[0] + "\" ");
        this.writer.print("y1=\"" + proj[1] + "\" ");
        this.writer.print("x2=\"" + p2[4] + "\" ");
        this.writer.print("y2=\"" + p2[5] + "\" ");
        this.writer.println(">");
        String col = this.colorString((int)p2[8], (int)p2[9], (int)p2[10]);
        String col2 = this.colorString((int)(this.oneMinusTransparency * p2[8]), (int)(this.oneMinusTransparency * p2[9]), (int)(this.oneMinusTransparency * p2[10]));
        this.writer.print("<stop offset=\"0\" stop-color=\"" + col + "\" stop-opacity=\"0\" ");
        this.writer.print("/>");
        this.writer.print("<stop offset=\".99\" stop-color=\"" + col + "\" stop-opacity=\"" + 1 + "\" ");
        this.writer.print("/>");
        this.writer.println("</linearGradient>");
    }

    private void writePolygon(double[][] polygon, int pLength, String color, String outlineColor) {
        this.writer.print("<polygon ");
        this.writer.print("stroke=\"" + outlineColor + "\" ");
        if (!outlineColor.equals(NONE)) {
            this.writer.print("stroke-opacity=\"" + this.oneMinusTransparency + "\" ");
        }
        this.writer.print("fill=\"" + color + "\" ");
        this.writer.print("fill-opacity=\"" + this.oneMinusTransparency + "\" ");
        this.writer.print("points=\"");
        for (int i = 0; i < pLength; ++i) {
            this.writer.print(" " + polygon[i][4]);
            this.writer.print(" " + polygon[i][5]);
        }
        this.writer.print("\"");
        this.writer.println(" />");
    }

    private double[] project(double[] p0, double[] p1, double[] p2) {
        double l;
        double[] r = new double[3];
        double d0 = p1[4] - p0[4];
        double d1 = p1[5] - p0[5];
        double e0 = p2[4] - p0[4];
        double e1 = p2[5] - p0[5];
        double normS = d0 * d0 + d1 * d1;
        double s = d0 * e0 + d1 * e1;
        if (normS != 0.0) {
            l = s / normS;
            d0 *= l;
            d1 *= l;
        } else {
            d1 = 0.0;
            d0 = 0.0;
            l = 0.0;
        }
        r[0] = p0[4] + d0;
        r[1] = p0[5] + d1;
        r[2] = l / Math.sqrt(normS);
        return r;
    }

    private String colorString(int r, int g, int b) {
        String sr = Integer.toHexString(r);
        sr = sr.length() == 1 ? "0" + sr : sr;
        String sg = Integer.toHexString(g);
        sg = sg.length() == 1 ? "0" + sg : sg;
        String sb = Integer.toHexString(b);
        sb = sb.length() == 1 ? "0" + sb : sb;
        return "#" + sr + sg + sb;
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public void clear(boolean clearBackground) {
    }

    public void start() {
        this.count = 0;
        this.writer.println("<svg color-interpolation=\"sRGB\" color-rendering=\"auto\" fill=\"none\"    fill-opacity=\"1\" font-family=\"'Arial'\" font-size=\"12\" font-style=\"normal\"    font-weight=\"normal\"   viewBox=\"" + this.xmin + " " + this.ymin + " " + (this.xmax - this.xmin) + " " + (this.ymax - this.ymin) + " \" " + " image-rendering=\"auto\" " + "    shape-rendering=\"auto\" stroke=\"black\" stroke-dasharray=\"none\" " + "    stroke-dashoffset=\"0\" stroke-linecap=\"square\" stroke-linejoin=\"bevel\"" + "    stroke-miterlimit=\"10\" stroke-opacity=\"1\" stroke-width=\"1\" " + "    text-rendering=\"auto\" >");
    }

    public void stop() {
        this.writer.println("</svg>");
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
    }

    public int getBackground() {
        return this.background;
    }

    public void setBackgroundColors(Color[] c) {
    }

    public void setTransparencyEnabled(boolean transparencyEnabled) {
        this.transparencyEnabled = transparencyEnabled;
    }

    public double getMinDim() {
        return 2.0 * this.mh;
    }
}

