/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.AbstractPolygon;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.VecMat;
import java.util.Vector;

public class PolygonUtility {
    private static final boolean DEBUG = false;
    public static final int CLIPPED_OUT = -1;
    public static final int CLIPPED_PARTIAL = 1;
    public static final int CLIPPED_IN = 0;
    private static double[] zNormal = new double[]{0.0, 0.0, 1.0};
    private static final double EPS = Math.ulp(2.0);

    public static final void dehomogenize(AbstractPolygon p) {
        for (int i = 0; i < p.getLength(); ++i) {
            double[] vd = p.getPoint(i);
            double w = 1.0 / vd[7];
            vd[4] = vd[4] * w;
            vd[5] = vd[5] * w;
            vd[6] = vd[6] * w;
            vd[7] = 1.0;
        }
    }

    public static int liesBehind(AbstractPolygon a, AbstractPolygon b) {
        double[] x = b.getPoint(0);
        double[] y = b.getPoint(1);
        double[] z = b.getPoint(2);
        double[] d1 = VecMat.difference(y, 4, x, 4);
        double[] d2 = VecMat.difference(z, 4, x, 4);
        double[] normalA = new double[3];
        VecMat.cross(d1, d2, normalA);
        VecMat.normalize(normalA);
        double d = VecMat.dot(normalA, 0, x, 4);
        int sign = (int)Math.signum(VecMat.dot(normalA, zNormal));
        int inP = 0;
        int in = 0;
        int out = 0;
        boolean noIntersect = false;
        double dist0 = (double)sign * (VecMat.dot(normalA, 0, a.getPoint(0), 4) - d);
        int n = a.getLength();
        for (int i = 1; i < n + 1; ++i) {
            double dist1 = dist0;
            dist0 = (double)sign * (VecMat.dot(normalA, 0, a.getPoint(i % n), 4) - d);
            inP += Math.abs(dist1) < EPS ? 1 : 0;
            in += dist1 > EPS ? 1 : 0;
            out += dist1 < -EPS ? 1 : 0;
            if (!(Math.abs(dist1) < EPS) || !(Math.abs(dist0) < EPS)) continue;
            noIntersect = true;
        }
        if (inP == a.getLength()) {
            return 1;
        }
        if (out == 0) {
            return 1;
        }
        int result = PolygonUtility.testPolygonInHalfSpace(a, 4, normalA, -sign, d);
        if (result == 0) {
            return 1;
        }
        if (result == -1) {
            noIntersect = true;
        }
        AbstractPolygon p = a;
        Polygon clipPoly = null;
        int n2 = b.getLength();
        for (int j = 0; j < n2; ++j) {
            double[] lx = b.getPoint(j);
            double[] ly = b.getPoint((j + 1) % n2);
            double[] lz = b.getPoint((j + 2) % n2);
            double[] ld1 = VecMat.difference(lx, 4, ly, 4);
            double[] lnormalA = new double[3];
            VecMat.cross(ld1, zNormal, lnormalA);
            VecMat.normalize(lnormalA);
            double ldist = VecMat.dot(lnormalA, 0, lx, 4);
            int lsign = (int)Math.signum(VecMat.dot(lnormalA, 0, lz, 4) - ldist);
            if (lsign == 0) continue;
            clipPoly = new Polygon(3);
            int lresult = PolygonUtility.clipToHalfspace(p, 4, lnormalA, -lsign, ldist, clipPoly);
            if (lresult == -1) {
                return 1;
            }
            if (lresult != 1) continue;
            p = clipPoly;
        }
        Polygon poly = new Polygon(3);
        result = PolygonUtility.clipToHalfspace(p, 4, normalA, -sign, d, poly);
        if (result == 1) {
            if (noIntersect) {
                System.err.println("intersection detected while two points are in plane");
                int n3 = p.getLength();
                for (int i = 0; i < n3; ++i) {
                    double[] v = p.getPoint(i);
                    double test = (double)(-sign) * (VecMat.dot(v, 4, normalA, 0) - d * v[7]);
                    if (!(test < -EPS)) continue;
                    return 1;
                }
            } else {
                return 0;
            }
        }
        if (result == 0) {
            return 1;
        }
        return -1;
    }

    public static AbstractPolygon[] cutOut(AbstractPolygon a, AbstractPolygon b) {
        Vector<AbstractPolygon> v = new Vector<AbstractPolygon>();
        AbstractPolygon p = a;
        Polygon clipPoly = null;
        int length = b.getLength();
        for (int j = 0; j < length; ++j) {
            double[] lx = b.getPoint(j);
            double[] ly = b.getPoint((j + 1) % length);
            double[] lz = b.getPoint((j + 2) % length);
            double[] ld1 = VecMat.difference(lx, 4, ly, 4);
            double[] lnormalA = new double[3];
            VecMat.cross(ld1, zNormal, lnormalA);
            VecMat.normalize(lnormalA);
            double ldist = VecMat.dot(lnormalA, 0, lx, 4);
            int lsign = (int)Math.signum(VecMat.dot(lnormalA, 0, lz, 4) - ldist);
            clipPoly = new Polygon(3);
            int lresult = PolygonUtility.clipToHalfspace(p, 4, lnormalA, -lsign, ldist, clipPoly);
            if (lresult == 1) {
                Polygon poly = new Polygon(3);
                PolygonUtility.clipToHalfspace(p, 4, lnormalA, lsign, ldist, poly);
                v.add(poly);
                p = clipPoly;
                continue;
            }
            if (lresult != -1) continue;
            v.add(p);
            p = clipPoly;
            clipPoly.setLength(0);
            break;
        }
        if (p.getLength() != 0) {
            // empty if block
        }
        return v.toArray(new AbstractPolygon[0]);
    }

    private static String s(double[] u) {
        return "(" + u[0] + ", " + u[1] + ", " + u[2] + ")";
    }

    public static double minZ(AbstractPolygon p) {
        double min = Double.MAX_VALUE;
        int n = p.getLength();
        for (int i = 0; i < n; ++i) {
            min = Math.min(min, p.getPoint(i)[6] / p.getPoint(i)[7]);
        }
        return min;
    }

    public static double maxZ(AbstractPolygon p) {
        double max = -1.7976931348623157E308;
        int n = p.getLength();
        for (int i = 0; i < n; ++i) {
            max = Math.max(max, p.getPoint(i)[6] / p.getPoint(i)[7]);
        }
        return max;
    }

    private static int testTriangleInHalfSpace(Triangle t, double[] planeNormal, int sign, double k) {
        int hin = 0;
        int hout = 0;
        double[] vd = t.getP0();
        double test = (double)sign * (VecMat.dot(vd, 4, planeNormal, 0) - k * vd[7]);
        if (test < -EPS) {
            ++hin;
        } else if (test > EPS) {
            ++hout;
        }
        vd = t.getP1();
        test = (double)sign * (VecMat.dot(vd, 4, planeNormal, 0) - k * vd[7]);
        if (test < -EPS) {
            ++hin;
        } else if (test > EPS) {
            ++hout;
        }
        vd = t.getP2();
        test = (double)sign * (VecMat.dot(vd, 4, planeNormal, 0) - k * vd[7]);
        if (test < -EPS) {
            ++hin;
        } else if (test > EPS) {
            ++hout;
        }
        if (hin == 0) {
            return -1;
        }
        if (hout == 0) {
            return 0;
        }
        return 1;
    }

    public static int clipTriangleToHalfspace(Triangle tri, double[] planeNormal, int sign, double k, Triangle a, Triangle b) {
        int testResult = PolygonUtility.testTriangleInHalfSpace(tri, planeNormal, sign, k);
        if (testResult != 1) {
            return testResult;
        }
        int result = 1;
        double[] u = tri.getPoint(2);
        double[] v = tri.getPoint(0);
        double tu = (double)sign * (VecMat.dot(u, 4, planeNormal, 0) - k * u[7]);
        double tv = 0.0;
        int newTriVertex = 0;
        Triangle newTri = a;
        a.setShadingFrom(tri);
        for (int i = 0; i < 3; ++i) {
            if (tu <= 0.0 ^ (tv = (double)sign * (VecMat.dot(v = tri.getPoint(i), 4, planeNormal, 0) - k * v[7])) <= 0.0) {
                double t = tu / (tu - tv);
                double[] vd = newTri.getPoint(newTriVertex);
                for (int j = 0; j < 17; ++j) {
                    vd[j] = u[j] + t * (v[j] - u[j]);
                }
                ++newTriVertex;
            }
            if (tv <= 0.0) {
                newTri.setPointFrom(newTriVertex++, v);
            }
            if (newTriVertex == 3) {
                b.setPointFrom(0, a.getP0());
                b.setPointFrom(1, a.getP2());
                b.setShadingFrom(tri);
                newTri = b;
                newTriVertex = 2;
                result = 2;
            }
            u = v;
            tu = tv;
        }
        return result;
    }

    private static int testPolygonInHalfSpace(AbstractPolygon p, int off, double[] planeNormal, int sign, double k) {
        int length = p.getLength();
        if (length == 0) {
            return -1;
        }
        int hin = 0;
        int hout = 0;
        for (int i = 0; i < length; ++i) {
            double[] v = p.getPoint(i);
            double test = (double)sign * (VecMat.dot(v, off, planeNormal, 0) - k * v[off + 3]);
            if (test < -EPS) {
                ++hin;
                continue;
            }
            if (!(test > EPS)) continue;
            ++hout;
        }
        if (hin == 0) {
            return -1;
        }
        if (hout == 0) {
            return 0;
        }
        return 1;
    }

    public static int clipToHalfspace(AbstractPolygon p, int off, double[] planeNormal, int sign, double k, Polygon dst) {
        int testResult = PolygonUtility.testPolygonInHalfSpace(p, off, planeNormal, sign, k);
        if (testResult != 1) {
            return testResult;
        }
        int length = p.getLength();
        double[] u = p.getPoint(length - 1);
        double[] v = p.getPoint(0);
        double tu = (double)sign * (VecMat.dot(u, off, planeNormal, 0) - k * u[off + 3]);
        double tv = 0.0;
        dst.setLength(0);
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            if (tu <= 0.0 ^ (tv = (double)sign * (VecMat.dot(v = p.getPoint(i), off, planeNormal, 0) - k * v[off + 3])) <= 0.0) {
                double t = tu / (tu - tv);
                double[] vd = dst.getPoint(pos++);
                for (int j = 0; j < 17; ++j) {
                    vd[j] = u[j] + t * (v[j] - u[j]);
                }
            }
            if (tv < 0.0) {
                dst.setPointFrom(pos++, v);
            }
            u = v;
            tu = tv;
        }
        dst.setShadingFrom(p);
        return 1;
    }

    public static void intersect(AbstractPolygon a, AbstractPolygon b, int s, Polygon resBefore, Polygon resBehind) {
        double[] x = b.getPoint(0);
        double[] y = b.getPoint(1);
        double[] z = b.getPoint(2);
        double[] d1 = VecMat.difference(y, 4, x, 4);
        double[] d2 = VecMat.difference(z, 4, x, 4);
        double[] normal = new double[3];
        VecMat.cross(d1, d2, normal);
        VecMat.normalize(normal);
        double dist = VecMat.dot(normal, 0, x, 4);
        int sign = (int)((double)s * Math.signum(VecMat.dot(normal, new double[]{0.0, 0.0, 1.0})));
        int test = PolygonUtility.clipToHalfspace(a, 4, normal, sign, dist, resBefore);
        int test2 = PolygonUtility.clipToHalfspace(a, 4, normal, -sign, dist, resBehind);
        if (test != 1) {
            System.err.println(" warning: intersect gives no intersection!!!");
        }
        if (resBefore.getLength() < 3) {
            System.err.println("WARNING intersect generated polygon of length " + resBefore.getLength());
        }
        if (resBehind.getLength() < 3) {
            System.err.println("WARNING intersect generated polygon of length " + resBehind.getLength());
        }
    }
}

