/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.CameraProjection;

public class PerspectiveProjection
extends CameraProjection {
    private double fieldOfView = 1.0471975511965976;
    private double focalLength = 1.0 / Math.tan(0.1308996938995747);
    private int width = 640;
    private int height = 480;
    private double wh = (double)this.width / 2.0;
    private double hh = (double)this.height / 2.0;
    private double mh = Math.min(this.wh, this.hh);
    private double nearclip = 3.0;
    private double farclip = 50.0;

    public PerspectiveProjection() {
        this.setFrustumZmin(-1.0);
        this.setFrustumZmax(1.0);
    }

    public final void perspective(double[] v) {
        double vz = -v[2];
        v[4] = v[0] * this.focalLength;
        v[5] = v[1] * this.focalLength;
        v[6] = ((this.nearclip + this.farclip) * vz - v[3] * (2.0 * this.nearclip * this.farclip)) / (this.farclip - this.nearclip);
        v[7] = vz;
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public void setFieldOfViewDeg(double fieldOfView) {
        this.fieldOfView = fieldOfView / 180.0 * Math.PI;
        this.focalLength = 1.0 / Math.tan(this.fieldOfView / 2.0);
    }

    public void setFocalLength(double focalLength) {
        this.focalLength = focalLength;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.hh = (double)height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
        this.setFrustumYmax(Math.max(1.0, this.hh / this.mh));
        this.setFrustumYmin(-this.getFrustumYmax());
        this.setFrustumXmax(Math.max(1.0, this.wh / this.mh));
        this.setFrustumXmin(-this.getFrustumXmax());
    }

    public void setWidth(int width) {
        this.width = width;
        this.wh = (double)width / 2.0;
        this.mh = Math.min(this.wh, this.hh);
        this.setFrustumYmax(Math.max(1.0, this.hh / this.mh));
        this.setFrustumYmin(-this.getFrustumYmax());
        this.setFrustumXmax(Math.max(1.0, this.wh / this.mh));
        this.setFrustumXmin(-this.getFrustumXmax());
    }

    public void setNear(double d) {
        this.nearclip = d;
    }

    public void setFar(double d) {
        this.farclip = d;
    }
}

