/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.AbstractPolygon;
import de.jreality.softviewer.Polygon;
import de.jreality.softviewer.PolygonUtility;
import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.TrianglePipeline;
import de.jreality.softviewer.TriangleRasterizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectingPipeline
extends TrianglePipeline {
    private int count;
    LinkedList<AbstractPolygon> polys = new LinkedList();
    LinkedList<AbstractPolygon> postponed = new LinkedList();
    HashMap<AbstractPolygon, List<AbstractPolygon>> ignore = new HashMap();
    HashMap<AbstractPolygon, List<AbstractPolygon>> obstruct = new HashMap();
    Vector<Pair> looP = new Vector();
    private Comparator<AbstractPolygon> comparator = new Comparator<AbstractPolygon>(){

        @Override
        public int compare(AbstractPolygon o1, AbstractPolygon o2) {
            double z = PolygonUtility.maxZ(o1);
            return (z -= PolygonUtility.maxZ(o2)) < 0.0 ? 1 : (z > 0.0 ? -1 : 0);
        }
    };
    private Triangle[] tris = new Triangle[1];

    public IntersectingPipeline(TriangleRasterizer rasterizer, boolean sortAll) {
        super(rasterizer, sortAll);
    }

    @Override
    public void finish() {
        int preCount = this.triangles.getSize();
        this.count = 0;
        this.rasterRemaining_new();
        System.out.println(" rastered " + this.count + " triangles (" + preCount + ")");
        System.out.println(" polys " + this.polys.size());
        System.out.println(" ignore " + this.ignore.size());
        System.out.println(" obstruct " + this.obstruct.size());
    }

    private List<AbstractPolygon> getIgnoreList(AbstractPolygon p) {
        List<AbstractPolygon> l = this.ignore.get(p);
        if (l == null) {
            l = new LinkedList<AbstractPolygon>();
            this.ignore.put(p, l);
        }
        return l;
    }

    private List<AbstractPolygon> getObstructList(AbstractPolygon p) {
        List<AbstractPolygon> l = this.obstruct.get(p);
        if (l == null) {
            l = new LinkedList<AbstractPolygon>();
            this.obstruct.put(p, l);
        }
        return l;
    }

    private void rasterRemaining_new() {
        this.rasterizer.setTransparencyEnabled(true);
        this.ignore.clear();
        this.obstruct.clear();
        int n = this.triangles.getSize();
        for (int i = 0; i < n; ++i) {
            Triangle t = this.triangles.pop();
            PolygonUtility.dehomogenize(t);
            this.polys.add(t);
        }
        Collections.sort(this.polys, this.comparator);
        while (!this.polys.isEmpty()) {
            AbstractPolygon t = this.polys.removeFirst();
            this.rasterQueque_new(this.polys, t, 0, 0);
        }
    }

    private void rasterQueque_new(LinkedList<AbstractPolygon> polys, AbstractPolygon a, int n, int depth) {
        boolean passed = this.test_new(polys, a, n, depth);
        if (passed) {
            this.tris = a.triangulate(this.tris, this.freeTriangles);
            int l = a.getLength() - 2;
            for (int i = 0; i < l; ++i) {
                this.rasterizer.renderTriangle(this.tris[i], false);
                this.freeTriangles.push(this.tris[i]);
                ++this.count;
            }
            this.ignore.remove(a);
            this.obstruct.remove(a);
            this.looP.removeAllElements();
        }
    }

    private boolean test_new(LinkedList<AbstractPolygon> polys, AbstractPolygon a, int n, int depth) {
        List<AbstractPolygon> ignoreForA = this.getIgnoreList(a);
        List<AbstractPolygon> obstructsA = this.getObstructList(a);
        double minA = PolygonUtility.minZ(a);
        for (int i = n; i < polys.size(); ++i) {
            AbstractPolygon b = polys.get(i);
            List<AbstractPolygon> obstructsB = this.getObstructList(b);
            if (PolygonUtility.maxZ(b) < minA) {
                return true;
            }
            if (ignoreForA.contains(b)) continue;
            int test = obstructsA.contains(b) ? -1 : PolygonUtility.liesBehind(a, b);
            if (test == 1) {
                ignoreForA.add(b);
                continue;
            }
            if (test == -1) {
                Pair p = new Pair(a, b);
                if (this.looP.contains(p)) {
                    AbstractPolygon[] array = PolygonUtility.cutOut(b, a);
                    System.out.println("obstruction loop resolved by adding " + array.length + " polygons (to " + polys.size() + " depth " + depth + ") loopsize " + this.looP.size());
                    polys.remove(i);
                    List<AbstractPolygon> ib = this.getIgnoreList(b);
                    this.obstruct.remove(b);
                    this.ignore.remove(b);
                    if (b instanceof Triangle) {
                        this.freeTriangles.push((Triangle)b);
                    }
                    for (int j = 0; j < array.length; ++j) {
                        this.insert(polys, array[j]);
                        ignoreForA.add(array[j]);
                        LinkedList<AbstractPolygon> l = new LinkedList<AbstractPolygon>();
                        l.add(a);
                        l.addAll(ib);
                        for (int k = 0; k < array.length; ++k) {
                            if (k == j) continue;
                            l.add(array[k]);
                        }
                        this.ignore.put(array[j], l);
                    }
                    continue;
                }
                polys.remove(i);
                this.looP.add(p);
                this.insert(polys, a);
                obstructsA.add(b);
                List<AbstractPolygon> ignoreForB = this.getIgnoreList(b);
                ignoreForB.add(a);
                polys.add(0, b);
                return false;
            }
            if (obstructsB.contains(a)) {
                System.err.println("try to do unncecessary cut");
            }
            Polygon resultBehindB = new Polygon(3);
            Polygon resultBeforeB = new Polygon(3);
            PolygonUtility.intersect(a, b, 1, resultBeforeB, resultBehindB);
            for (List<AbstractPolygon> l : this.ignore.values()) {
                if (!l.contains(a)) continue;
                l.remove(a);
                l.add(resultBeforeB);
                l.add(resultBehindB);
            }
            List<AbstractPolygon> ignoreForB = this.getIgnoreList(b);
            ignoreForB.add(resultBeforeB);
            obstructsB.add(resultBehindB);
            LinkedList<AbstractPolygon> l = new LinkedList<AbstractPolygon>();
            l.add(b);
            l.add(resultBeforeB);
            l.addAll(ignoreForA);
            this.ignore.put(resultBehindB, l);
            l = new LinkedList();
            l.add(b);
            this.obstruct.put(resultBeforeB, l);
            l = new LinkedList();
            l.addAll(ignoreForA);
            l.add(resultBehindB);
            this.ignore.put(resultBeforeB, l);
            this.insert(polys, resultBeforeB);
            this.insert(polys, resultBehindB);
            if (a instanceof Triangle) {
                this.freeTriangles.push((Triangle)a);
            }
            this.obstruct.remove(a);
            this.ignore.remove(a);
            this.looP.removeAllElements();
            return false;
        }
        return true;
    }

    private String getColor(AbstractPolygon b) {
        double[] v = b.getPoint(0);
        return "[" + v[8] + ", " + v[9] + ", " + v[10] + "]";
    }

    private void insert(LinkedList<AbstractPolygon> tris2, AbstractPolygon triangle) {
        int i = Collections.binarySearch(tris2, triangle, this.comparator);
        if (i < 0) {
            i = -i - 1;
        }
        tris2.add(i, triangle);
    }

    private class Pair {
        private AbstractPolygon one;
        private AbstractPolygon two;

        Pair(AbstractPolygon t1, AbstractPolygon t2) {
            this.one = t1;
            this.two = t2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair p = (Pair)obj;
                return this.one == p.one && this.two == p.two;
            }
            return false;
        }
    }
}

