/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.Triangle;

public class ArrayStack {
    private Triangle[] data;
    int position = -1;
    private final int increment;

    public ArrayStack(int initialCapacity) {
        this.data = new Triangle[initialCapacity];
        this.increment = initialCapacity;
    }

    public boolean isEmpty() {
        return this.position == -1;
    }

    public int getSize() {
        return this.position + 1;
    }

    public Triangle pop() {
        if (this.position > -1) {
            Triangle result = this.data[this.position];
            this.data[this.position--] = null;
            return result;
        }
        return new Triangle();
    }

    public Triangle peek() {
        return this.data[this.position];
    }

    public void push(Triangle element) {
        if (++this.position >= this.data.length) {
            Triangle[] tmp = new Triangle[this.data.length + this.increment];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        this.data[this.position] = element;
    }

    public Triangle[] getArray() {
        return this.data;
    }

    public void set(int i, Triangle e) {
        this.data[i] = e;
    }

    public Triangle get(int i) {
        return this.data[i];
    }
}

