/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.CubeMap;
import de.jreality.softviewer.CameraProjection;
import de.jreality.softviewer.IntersectingPipeline;
import de.jreality.softviewer.OrthographicProjection;
import de.jreality.softviewer.PerspectiveProjection;
import de.jreality.softviewer.PrimitiveCache;
import de.jreality.softviewer.RenderingVisitor;
import de.jreality.softviewer.TrianglePipeline;
import de.jreality.softviewer.TriangleRasterizer;
import de.jreality.util.DefaultMatrixSupport;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import java.util.List;

public abstract class AbstractRenderer {
    protected Camera camera;
    protected SceneGraphComponent root;
    protected SceneGraphComponent auxiliaryRoot;
    private SceneGraphPath cameraPath;
    private Transformation cameraWorld = new Transformation();
    protected TrianglePipeline pipeline;
    protected TriangleRasterizer rasterizer;
    protected RenderingVisitor renderTraversal;
    private Color leftlower;
    private Color rightupper;
    private Color leftupper;
    private Color rightlower;

    public AbstractRenderer(TriangleRasterizer r, boolean intersecting, boolean sortAll) {
        this.rasterizer = r;
        this.pipeline = intersecting ? new IntersectingPipeline(this.rasterizer, sortAll) : new TrianglePipeline(this.rasterizer);
        this.renderTraversal = new RenderingVisitor();
        this.renderTraversal.setPipeline(this.pipeline);
    }

    public void setBackgroundColor(int c) {
        this.rasterizer.setBackground(c);
    }

    public int getBackgroundColor() {
        return this.rasterizer.getBackground();
    }

    protected void render(int width, int height) {
        Color background;
        this.rasterizer.setWindow(0, width, 0, height);
        this.rasterizer.setSize(width, height);
        Appearance a = this.root == null ? null : this.root.getAppearance();
        CubeMap sky = null;
        if (a != null) {
            Object o;
            if (AttributeEntityUtility.hasAttributeEntity(CubeMap.class, "skyBox", a)) {
                sky = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, "skyBox", a, true);
            }
            if ((o = a.getAttribute("backgroundColors")) instanceof Color[]) {
                Color[] colors = (Color[])o;
                this.rasterizer.setBackgroundColors(colors);
            } else {
                this.rasterizer.setBackgroundColors(null);
            }
            o = a.getAttribute("backgroundColor");
            background = o instanceof Color ? (Color)o : CommonAttributes.BACKGROUND_COLOR_DEFAULT;
        } else {
            background = Color.WHITE;
            this.rasterizer.setBackgroundColors(null);
        }
        this.rasterizer.setBackground(background.getRGB());
        this.rasterizer.clear(sky == null);
        this.rasterizer.start();
        if (this.root != null && this.camera != null) {
            CameraProjection pp;
            boolean isPerspective = this.camera.isPerspective();
            CameraProjection p = this.pipeline.getPerspective();
            if (isPerspective) {
                pp = null;
                if (!(p instanceof PerspectiveProjection)) {
                    pp = new PerspectiveProjection();
                    this.pipeline.setPerspective(pp);
                } else {
                    pp = (PerspectiveProjection)p;
                }
                ((PerspectiveProjection)pp).setFieldOfViewDeg(this.camera.getFieldOfView());
                ((PerspectiveProjection)pp).setNear(this.camera.getNear());
                ((PerspectiveProjection)pp).setFar(this.camera.getFar());
            } else {
                pp = null;
                if (!(p instanceof OrthographicProjection)) {
                    pp = new OrthographicProjection();
                    this.pipeline.setPerspective(pp);
                } else {
                    pp = (OrthographicProjection)p;
                }
                ((OrthographicProjection)pp).setFieldOfViewDeg(this.camera.getFieldOfView());
                ((OrthographicProjection)pp).setNear(this.camera.getNear());
                ((OrthographicProjection)pp).setFar(this.camera.getFar());
                ((OrthographicProjection)pp).setFocus(this.camera.getFocus());
            }
            this.pipeline.getPerspective().setWidth(width);
            this.pipeline.getPerspective().setHeight(height);
            DefaultMatrixSupport.getSharedInstance().restoreDefault(this.cameraWorld, true);
            this.cameraWorld.setMatrix(this.cameraPath.getMatrix(null));
            this.pipeline.clearPipeline();
            double[] im = new double[16];
            Rn.inverse(im, this.cameraWorld.getMatrix());
            this.cameraWorld.setMatrix(im);
            this.renderTraversal.setInitialTransformation(this.cameraWorld);
            this.renderTraversal.traverse(this.root);
            if (this.auxiliaryRoot != null) {
                this.renderTraversal.traverse(this.auxiliaryRoot);
            }
            if (sky != null) {
                PrimitiveCache.renderSky(this.pipeline, sky);
            }
        }
        this.pipeline.finish();
        this.rasterizer.stop();
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
        this.camera = p == null ? null : (Camera)p.getLastElement();
    }

    public SceneGraphComponent getSceneRoot() {
        return this.root;
    }

    public void setSceneRoot(SceneGraphComponent component) {
        this.root = component;
        if (this.root != null && this.camera != null) {
            List<SceneGraphPath> camPaths = SceneGraphUtility.getPathsBetween(this.root, this.camera);
            if (camPaths.size() > 0) {
                this.cameraPath = camPaths.get(0);
            } else {
                this.camera = null;
                this.cameraPath = null;
            }
        }
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.auxiliaryRoot;
    }

    public void setAuxiliaryRoot(SceneGraphComponent component) {
        this.auxiliaryRoot = component;
        if (this.root != null && this.camera != null) {
            List<SceneGraphPath> camPaths = SceneGraphUtility.getPathsBetween(this.root, this.camera);
            if (camPaths.size() > 0) {
                this.cameraPath = camPaths.get(0);
            } else {
                this.camera = null;
                this.cameraPath = null;
            }
        }
    }

    public abstract void render();

    public abstract void update();

    public void setBestQuality(boolean b) {
        this.renderTraversal.setBestQuality(b);
    }
}

