/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.soft.DefaultPolygonShader;
import de.jreality.soft.Environment;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.Texture;
import de.jreality.soft.VertexShader;

public class TwoSidePolygonShader
implements PolygonShader {
    private PolygonShader front;
    private PolygonShader back;

    public TwoSidePolygonShader() {
        this.front = new DefaultPolygonShader();
        this.back = new DefaultPolygonShader();
    }

    public TwoSidePolygonShader(PolygonShader f, PolygonShader b) {
        this.front = f;
        this.back = b;
    }

    public final void shadePolygon(Polygon p, double[] vd, Environment environment) {
        boolean faceforward;
        int pos = p.vertices[0];
        double px = vd[pos + 0];
        double py = vd[pos + 1];
        double pz = vd[pos + 2];
        double[] d1 = new double[3];
        pos = p.vertices[1];
        d1[0] = vd[pos + 0] - px;
        d1[1] = vd[pos + 1] - py;
        d1[2] = vd[pos + 2] - pz;
        double[] d2 = new double[3];
        pos = p.vertices[p.length - 1];
        d2[0] = vd[pos + 0] - px;
        d2[1] = vd[pos + 1] - py;
        d2[2] = vd[pos + 2] - pz;
        boolean bl = faceforward = px * (d1 = Rn.crossProduct(null, d1, d2))[0] + py * d1[1] + pz * d1[2] <= 0.0;
        if (faceforward) {
            this.front.shadePolygon(p, vd, environment);
            p.setShader(this.front);
        } else {
            this.back.shadePolygon(p, vd, environment);
            p.setShader(this.back);
        }
    }

    public final VertexShader getVertexShader() {
        return null;
    }

    public final void setVertexShader(VertexShader s) {
    }

    public final boolean interpolateColor() {
        return false;
    }

    public boolean interpolateAlpha() {
        return false;
    }

    public boolean isOutline() {
        return false;
    }

    public void setOutline(boolean outline) {
    }

    public void setup(EffectiveAppearance eAppearance, String shaderName) {
        this.front = ShaderLookup.getPolygonShaderAttr(eAppearance, shaderName, "front");
        this.back = ShaderLookup.getPolygonShaderAttr(eAppearance, shaderName, "back");
    }

    public Texture getTexture() {
        return null;
    }

    public boolean hasTexture() {
        return false;
    }

    public void startGeometry(Geometry geom) {
        this.front.startGeometry(geom);
        this.back.startGeometry(geom);
    }

    public boolean needsSorting() {
        return false;
    }
}

