/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import de.jreality.soft.ConstantVertexShader;
import de.jreality.soft.DefaultVertexShader;
import de.jreality.soft.Environment;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.SimpleTexture;
import de.jreality.soft.Texture;
import de.jreality.soft.VertexShader;

public class SkyboxPolygonShader
implements PolygonShader {
    private boolean interpolateColor = true;
    private VertexShader vertexShader;
    private boolean outline = false;
    private Texture texture;

    public SkyboxPolygonShader() {
        this.vertexShader = new DefaultVertexShader();
    }

    public SkyboxPolygonShader(VertexShader v) {
        this.vertexShader = v;
    }

    public SkyboxPolygonShader(VertexShader v, boolean outline) {
        this.vertexShader = v;
        this.outline = outline;
    }

    public final void shadePolygon(Polygon p, double[] vertexData, Environment environment) {
        double[] matrix = environment.getMatrix();
        double x = -matrix[3];
        double y = -matrix[7];
        double z = -matrix[11];
        for (int i = 0; i < p.length; ++i) {
            int pos = p.vertices[i];
            vertexData[pos + 0] = vertexData[pos + 0] + x;
            vertexData[pos + 1] = vertexData[pos + 1] + y;
            vertexData[pos + 2] = vertexData[pos + 2] + z;
            this.vertexShader.shadeVertex(vertexData, p.vertices[i], environment);
        }
    }

    public final VertexShader getVertexShader() {
        return this.vertexShader;
    }

    public final void setVertexShader(VertexShader s) {
        if (this.vertexShader != s) {
            this.vertexShader = s;
            this.interpolateColor = !(s instanceof ConstantVertexShader);
        }
    }

    public final boolean interpolateColor() {
        return this.interpolateColor;
    }

    public boolean interpolateAlpha() {
        return false;
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public void setup(EffectiveAppearance eAppearance, String name) {
        this.outline = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "outline"), this.outline);
        this.setVertexShader(ShaderLookup.getVertexShaderAttr(eAppearance, name, "vertexShader"));
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eAppearance)) {
            this.texture = new SimpleTexture((Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eAppearance));
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void startGeometry(Geometry geom) {
        if (this.vertexShader != null) {
            this.vertexShader.startGeometry(geom);
        }
    }

    public boolean needsSorting() {
        return this.getVertexShader().getTransparency() != 0.0 || this.hasTexture() || this.interpolateAlpha();
    }
}

