/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import java.io.PrintWriter;

public class SVGRasterizer
implements PolygonRasterizer {
    public static final String NONE = "none";
    private boolean useGradients = false;
    private int background;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private int pLength = 0;
    private double[][] polygon = new double[Polygon.MAXPOLYVERTEX][13];
    protected double transparency = 0.0;
    protected double oneMinusTransparency = 1.0;
    private PrintWriter writer;
    private int count;
    private double wh;
    private double hh;
    private double mh;

    public SVGRasterizer(PrintWriter w) {
        this.writer = w;
    }

    public void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = p.getShader().getVertexShader().getTransparency();
        this.oneMinusTransparency = 1.0 - this.transparency;
        this.pLength = p.length;
        double[] t0 = new double[13];
        for (int i = 0; i < this.pLength; ++i) {
            int pos = p.vertices[i];
            double[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * this.mh;
            pi[0] = this.wh + vertexData[pos + 0] * wxy;
            pi[1] = this.hh - vertexData[pos + 1] * wxy;
            pi[2] = vertexData[pos + 2] * w;
            pi[4] = vertexData[pos + 4] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 4];
            pi[5] = vertexData[pos + 5] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 5];
            pi[6] = vertexData[pos + 6] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 6];
            t0[0] = t0[0] + pi[0];
            t0[1] = t0[1] + pi[1];
            t0[2] = t0[2] + pi[2];
            t0[4] = t0[4] + pi[4];
            t0[5] = t0[5] + pi[5];
            t0[6] = t0[6] + pi[6];
        }
        t0[0] = t0[0] / (double)this.pLength;
        t0[1] = t0[1] / (double)this.pLength;
        t0[4] = t0[4] / (double)this.pLength;
        t0[5] = t0[5] / (double)this.pLength;
        t0[6] = t0[6] / (double)this.pLength;
        if (!this.useGradients || p.getShader().interpolateColor()) {
            // empty if block
        }
        if (this.useGradients && p.getShader().interpolateColor()) {
            double[][] pol = new double[3][];
            pol[2] = t0;
            String t0Col = this.colorString((int)t0[4], (int)t0[5], (int)t0[6]);
            for (int n = 0; n < this.pLength - 1; ++n) {
                pol[0] = this.polygon[n];
                pol[1] = this.polygon[n + 1];
                this.writeGradients(pol);
                String col = "url(#" + this.count + "a)";
                col = t0Col;
                this.writePolygon(pol, 3, col, NONE);
                col = "url(#" + this.count + "b)";
                this.writePolygon(pol, 3, col, NONE);
                col = "url(#" + this.count + "c)";
                this.writePolygon(pol, 3, col, NONE);
                ++this.count;
            }
            pol[0] = this.polygon[this.pLength - 1];
            pol[1] = this.polygon[0];
            this.writeGradients(pol);
            String col = "url(#" + this.count + "a)";
            col = t0Col;
            this.writePolygon(pol, 3, col, NONE);
            col = "url(#" + this.count + "b)";
            this.writePolygon(pol, 3, col, NONE);
            col = "url(#" + this.count + "c)";
            this.writePolygon(pol, 3, col, NONE);
            ++this.count;
            if (p.getShader().isOutline()) {
                this.writePolygon(this.polygon, this.pLength, NONE, "black");
            }
        } else {
            String col = this.colorString((int)t0[4], (int)t0[5], (int)t0[6]);
            this.writePolygon(this.polygon, this.pLength, col, p.getShader().isOutline() ? "black" : NONE);
        }
        ++this.count;
    }

    private void writeGradients(double[][] p) {
        this.writeGradient(p[1], p[2], p[0], "" + this.count + "b");
        this.writeGradient(p[2], p[0], p[1], "" + this.count + "c");
    }

    private void writeGradient(double[] p0, double[] p1, double[] p2, String name) {
        double[] proj = this.project(p0, p1, p2);
        this.writer.print("<linearGradient gradientUnits=\"userSpaceOnUse\" ");
        this.writer.print("id=\"" + name + "\" ");
        this.writer.print("x1=\"" + proj[0] + "\" ");
        this.writer.print("y1=\"" + proj[1] + "\" ");
        this.writer.print("x2=\"" + p2[0] + "\" ");
        this.writer.print("y2=\"" + p2[1] + "\" ");
        this.writer.println(">");
        String col = this.colorString((int)p2[4], (int)p2[5], (int)p2[6]);
        String col2 = this.colorString((int)(this.oneMinusTransparency * p2[4]), (int)(this.oneMinusTransparency * p2[5]), (int)(this.oneMinusTransparency * p2[6]));
        this.writer.print("<stop offset=\"0\" stop-color=\"" + col + "\" stop-opacity=\"0\" ");
        this.writer.print("/>");
        this.writer.print("<stop offset=\".99\" stop-color=\"" + col + "\" stop-opacity=\"" + 1 + "\" ");
        this.writer.print("/>");
        this.writer.println("</linearGradient>");
    }

    private void writePolygon(double[][] polygon, int pLength, String color, String outlineColor) {
        this.writer.print("<polygon ");
        this.writer.print("stroke=\"" + outlineColor + "\" ");
        if (!outlineColor.equals(NONE)) {
            this.writer.print("stroke-opacity=\"" + this.oneMinusTransparency + "\" ");
        }
        this.writer.print("fill=\"" + color + "\" ");
        this.writer.print("fill-opacity=\"" + this.oneMinusTransparency + "\" ");
        this.writer.print("points=\"");
        for (int i = 0; i < pLength; ++i) {
            this.writer.print(" " + polygon[i][0]);
            this.writer.print(" " + polygon[i][1]);
        }
        this.writer.print("\"");
        this.writer.println(" />");
    }

    private double[] project(double[] p0, double[] p1, double[] p2) {
        double l;
        double[] r = new double[3];
        double d0 = p1[0] - p0[0];
        double d1 = p1[1] - p0[1];
        double e0 = p2[0] - p0[0];
        double e1 = p2[1] - p0[1];
        double normS = d0 * d0 + d1 * d1;
        double s = d0 * e0 + d1 * e1;
        if (normS != 0.0) {
            l = s / normS;
            d0 *= l;
            d1 *= l;
        } else {
            d1 = 0.0;
            d0 = 0.0;
            l = 0.0;
        }
        r[0] = p0[0] + d0;
        r[1] = p0[1] + d1;
        r[2] = l / Math.sqrt(normS);
        return r;
    }

    private String colorString(int r, int g, int b) {
        String sr = Integer.toHexString(r);
        sr = sr.length() == 1 ? "0" + sr : sr;
        String sg = Integer.toHexString(g);
        sg = sg.length() == 1 ? "0" + sg : sg;
        String sb = Integer.toHexString(b);
        sb = sb.length() == 1 ? "0" + sb : sb;
        return "#" + sr + sg + sb;
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public void clear() {
    }

    public void start() {
        this.count = 0;
        this.writer.println("<?xml version=\"1.0\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg xmlns=\"http://www.w3.org/2000/svg\" color-interpolation=\"sRGB\" color-rendering=\"auto\" fill=\"none\"    fill-opacity=\"1\" font-family=\"'Arial'\" font-size=\"12\" font-style=\"normal\"    font-weight=\"normal\"   viewBox=\"" + this.xmin + " " + this.ymin + " " + (this.xmax - this.xmin) + " " + (this.ymax - this.ymin) + " \" " + " image-rendering=\"auto\" " + "    shape-rendering=\"auto\" stroke=\"black\" stroke-dasharray=\"none\" " + "    stroke-dashoffset=\"0\" stroke-linecap=\"square\" stroke-linejoin=\"miter\"" + "    stroke-miterlimit=\"10\" stroke-opacity=\"1\" stroke-width=\"1\" " + "    text-rendering=\"auto\" >");
    }

    public void stop() {
        this.writer.println("</svg>");
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
    }
}

