/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Cylinder;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.pick.PickResult;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.ConstantVertexShader;
import de.jreality.soft.DefaultLineShader;
import de.jreality.soft.DefaultPointShader;
import de.jreality.soft.DefaultPolygonShader;
import de.jreality.soft.Environment;
import de.jreality.soft.FlatPolygonShader;
import de.jreality.soft.Geometries;
import de.jreality.soft.LineShader;
import de.jreality.soft.NewDoublePolygonRasterizer;
import de.jreality.soft.PointShader;
import de.jreality.soft.PolygonPipeline;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;
import de.jreality.soft.VecMat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class PickVisitor
extends SceneGraphVisitor {
    private static final String FACE_SHADER = "polygonShader";
    private boolean shaderUptodate;
    protected Environment environment = new Environment();
    protected HitDetector hitDetector = new HitDetector();
    protected EffectiveAppearance eAppearance;
    double[] initialTrafo;
    double[] currentTrafo;
    private Transformation initialTransformation;
    protected LineShader lineShader = new DefaultLineShader(new DefaultPolygonShader(new ConstantVertexShader()));
    protected PolygonPipeline pipeline;
    protected PointShader pointShader = new DefaultPointShader(new DefaultPolygonShader(new ConstantVertexShader()), new DefaultPolygonShader(new ConstantVertexShader()));
    protected PolygonShader polygonShader = new DefaultPolygonShader(new ConstantVertexShader());
    protected PickVisitor reclaimableSubcontext;
    private int[] fni = new int[13];
    private IntArray fnia = new IntArray(this.fni);

    public PickVisitor() {
        this.eAppearance = EffectiveAppearance.create();
    }

    protected PickVisitor(PickVisitor parentContext) {
        this.eAppearance = parentContext.eAppearance;
        this.initializeFromParentContext(parentContext);
    }

    private void hit() {
        System.out.println("hit");
    }

    public PolygonPipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(PolygonPipeline pipeline) {
        if (this.pipeline != null) {
            this.pipeline.setEnvironment(null);
        }
        this.pipeline = pipeline;
        pipeline.setEnvironment(this.environment);
    }

    protected void initializeFromParentContext(PickVisitor parentContext) {
        PickVisitor p = parentContext;
        this.environment = p.environment;
        this.eAppearance = parentContext.eAppearance;
        this.hitDetector = parentContext.hitDetector;
        this.pipeline = p.pipeline;
        this.polygonShader = p.polygonShader;
        this.pipeline.setFaceShader(this.polygonShader);
        this.lineShader = p.lineShader;
        this.pipeline.setLineShader(this.lineShader);
        this.pointShader = p.pointShader;
        this.pipeline.setPointShader(this.pointShader);
        this.initialTrafo = parentContext.currentTrafo;
        this.currentTrafo = parentContext.currentTrafo;
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void setInitialTransformation(Transformation initialTransformation) {
        this.initialTransformation = initialTransformation;
        this.environment.setInitialTransformation(initialTransformation);
    }

    PickVisitor subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            this.reclaimableSubcontext.shaderUptodate = false;
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new PickVisitor(this);
        return this.reclaimableSubcontext;
    }

    public void traverse(SceneGraphComponent root) {
        this.environment.removeAll();
        if (this.initialTrafo == null) {
            this.initialTrafo = new double[16];
        }
        if (this.initialTransformation != null) {
            this.initialTransformation.getMatrix(this.initialTrafo);
        } else {
            VecMat.assignIdentity(this.initialTrafo);
        }
        this.currentTrafo = this.initialTrafo;
        this.hitDetector.clear();
        double[] im = new double[16];
        Rn.inverse(im, this.initialTrafo);
        this.hitDetector.setCameraToWorld(im);
        this.visit(root);
        this.pipeline.setMatrix(this.initialTrafo);
    }

    public void visit(SceneGraphComponent c) {
        if (c.isVisible()) {
            this.hitDetector.path.push(c);
            c.childrenAccept(this.subContext());
            this.hitDetector.path.pop();
        }
    }

    public void visit(Transformation t) {
        if (this.initialTrafo == this.currentTrafo) {
            this.currentTrafo = new double[16];
        }
        VecMat.copyMatrix(this.initialTrafo, this.currentTrafo);
        VecMat.multiplyFromRight(this.currentTrafo, t.getMatrix());
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void visit(Appearance app) {
        this.eAppearance = this.eAppearance.create(app);
        this.shaderUptodate = false;
    }

    private void setupShader() {
        String geomShaderName;
        if (!this.eAppearance.getAttribute("geometryShader", "default").equals("default")) {
            Logger.getLogger("de.jreality").warning("unsupported geometry shader");
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName = (String)this.eAppearance.getAttribute("geometryShader.name", ""), "showFaces"), true)) {
            PolygonShader fs;
            this.polygonShader = fs = ShaderLookup.getPolygonShaderAttr(this.eAppearance, geomShaderName, FACE_SHADER);
            this.pipeline.setFaceShader(this.polygonShader);
        } else {
            this.polygonShader = null;
            this.pipeline.setFaceShader(null);
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showLines"), true)) {
            LineShader ls;
            this.lineShader = ls = ShaderLookup.getLineShaderAttr(this.eAppearance, geomShaderName, "lineShader");
            this.pipeline.setLineShader(this.lineShader);
        } else {
            this.lineShader = null;
            this.pipeline.setLineShader(null);
        }
        if (this.eAppearance.getAttribute(ShaderUtility.nameSpace(geomShaderName, "showPoints"), true)) {
            PointShader ps;
            this.pointShader = ps = ShaderLookup.getPointShaderAttr(this.eAppearance, geomShaderName, "pointShader");
            this.pipeline.setPointShader(this.pointShader);
        } else {
            this.pointShader = null;
            this.pipeline.setPointShader(null);
        }
        this.shaderUptodate = true;
    }

    public void visit(IndexedLineSet g) {
        this.hitDetector.path.push(g);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DataList dl = g.getEdgeAttributes(Attribute.INDICES);
        if (this.lineShader != null && dl != null) {
            IntArrayArray edgeIndices = dl.toIntArrayArray();
            DoubleArrayArray vertices = g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            this.pipeline.startGeometry(g);
            int n = edgeIndices.size();
            for (int i = 0; i < n; ++i) {
                IntArray edge = edgeIndices.item(i).toIntArray();
                for (int j = 0; j < edge.getLength() - 1; ++j) {
                    DoubleArray p1 = vertices.item(edge.getValueAt(j)).toDoubleArray();
                    DoubleArray p2 = vertices.item(edge.getValueAt(j + 1)).toDoubleArray();
                    this.pipeline.processPseudoTube(p1, p2);
                }
            }
        }
        this.hitDetector.path.pop();
        this.visit((PointSet)g);
    }

    public void visit(IndexedFaceSet ifs) {
        DataList indices;
        this.hitDetector.path.push(ifs);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        if (this.polygonShader != null && (indices = ifs.getFaceAttributes(Attribute.INDICES)) != null) {
            DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            DoubleArrayArray normals = null;
            DataList vndl = ifs.getVertexAttributes(Attribute.NORMALS);
            if (vndl != null) {
                normals = vndl.toDoubleArrayArray();
            }
            DataList texCoords = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
            this.pipeline.startGeometry(ifs);
            if (normals == null || this.polygonShader instanceof FlatPolygonShader) {
                DoubleArrayArray faceNormals = null;
                DataList fndl = ifs.getFaceAttributes(Attribute.NORMALS);
                if (fndl != null) {
                    faceNormals = fndl.toDoubleArrayArray();
                }
                for (int i = 0; i < ifs.getNumFaces(); ++i) {
                    IntArray faceIndices = indices.item(i).toIntArray();
                    Arrays.fill(this.fni, i);
                    this.pipeline.processPolygon(points, faceIndices, faceNormals, this.fnia, texCoords);
                }
            } else {
                for (int i = 0; i < ifs.getNumFaces(); ++i) {
                    IntArray faceIndices = indices.item(i).toIntArray();
                    this.pipeline.processPolygon(points, faceIndices, normals, faceIndices, texCoords);
                }
            }
        }
        this.hitDetector.path.pop();
        this.visit((IndexedLineSet)ifs);
    }

    public void visit(PointSet p) {
        this.hitDetector.path.push(p);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DoubleArrayArray a = null;
        int n = p.getNumPoints();
        if (this.pointShader != null) {
            a = p.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            if (a == null) {
                return;
            }
            this.pipeline.startGeometry(p);
            for (int i = 0; i < n; ++i) {
                this.pipeline.processPoint(a, i);
            }
        }
        this.hitDetector.path.pop();
    }

    public void visit(Sphere s) {
        this.hitDetector.path.push(s);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        this.pipeline.startGeometry(s);
        Geometries.unitSphere().apply(this.pipeline);
        this.hitDetector.path.pop();
    }

    public void visit(Cylinder c) {
        this.hitDetector.path.push(c);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        this.pipeline.startGeometry(c);
        Geometries.cylinder().apply(this.pipeline);
        this.hitDetector.path.pop();
    }

    public HitDetector getHitDetector() {
        return this.hitDetector;
    }

    public static class HitComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double b;
            double a = ((Hit)o1).getPointNDC()[2];
            return a > (b = ((Hit)o2).getPointNDC()[2]) ? 1 : (b > a ? -1 : 0);
        }
    }

    public static class Hit
    implements PickResult {
        SceneGraphPath path;
        double[] pointCamera;
        double[] pointWorld;
        double[] pointNDC;
        double[] pointObject;
        double[] textureCoords;

        public Hit(SceneGraphPath path, double[] pointNDC, double[] pointCamera, double[] pointWorld, double[] pointObject, double[] textureCoords) {
            this.path = path;
            this.pointCamera = pointCamera;
            this.pointWorld = pointWorld;
            this.pointNDC = pointNDC;
            this.pointObject = pointObject;
            this.textureCoords = textureCoords;
        }

        public SceneGraphPath getPickPath() {
            return this.path;
        }

        public double[] getPointCamera() {
            return this.pointCamera;
        }

        public double[] getPointNDC() {
            return this.pointNDC;
        }

        public double[] getWorldCoordinates() {
            return this.pointWorld;
        }

        public double[] getObjectCoordinates() {
            return this.pointObject;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Soft-Pick: ");
            sb.append(" dist=").append(Rn.euclideanDistance(this.pointCamera, this.pointWorld));
            sb.append(" world=").append(Rn.toString(this.pointWorld));
            sb.append(" path=").append(this.path.toString());
            return sb.toString();
        }

        public int getIndex() {
            return -1;
        }

        public int getPickType() {
            return -1;
        }

        public int hasTextureCoordinates() {
            if (this.textureCoords == null) {
                return 0;
            }
            return this.textureCoords.length;
        }

        public double[] getTextureCoordinates() {
            return this.textureCoords;
        }
    }

    public static class HitDetector
    extends NewDoublePolygonRasterizer.Colorizer {
        private Comparator comparator = new HitComparator();
        protected SceneGraphPath path = new SceneGraphPath();
        protected ArrayList list = new ArrayList();
        private double[] ndcToCamera;
        private double[] cameraToWorld;

        public double[] getCameraToWorld() {
            return this.cameraToWorld;
        }

        public void setCameraToWorld(double[] cameraToWorld) {
            this.cameraToWorld = cameraToWorld;
        }

        public double[] getNdcToCamera() {
            return this.ndcToCamera;
        }

        public void setNdcToCamera(double[] ndcToCamera) {
            this.ndcToCamera = ndcToCamera;
        }

        public void colorize(int[] pixels, double[] zBuff, int pos, double[] data, boolean interpolateUV) {
            double[] pointNDC = new double[]{0.0, 0.0, data[2], 1.0};
            double[] pointCamera = new double[4];
            Rn.matrixTimesVector(pointCamera, this.ndcToCamera, pointNDC);
            Pn.dehomogenize(pointCamera, pointCamera);
            double[] pointWorld = new double[4];
            Rn.matrixTimesVector(pointWorld, this.cameraToWorld, pointCamera);
            Pn.dehomogenize(pointWorld, pointWorld);
            double[] pointObject = new double[4];
            Rn.matrixTimesVector(pointObject, this.path.getInverseMatrix(null), pointWorld);
            Pn.dehomogenize(pointObject, pointObject);
            double[] texCoords = null;
            if (interpolateUV) {
                texCoords = new double[]{data[8], data[9]};
            }
            this.list.add(new Hit((SceneGraphPath)this.path.clone(), pointNDC, pointCamera, pointWorld, pointObject, texCoords));
        }

        protected void clear() {
            this.list = new ArrayList();
            this.path = new SceneGraphPath();
        }

        public List getHitList() {
            Collections.sort(this.list, this.comparator);
            return this.list;
        }
    }
}

