/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import java.io.PrintWriter;

public class PSRasterizer
implements PolygonRasterizer {
    public static final String NONE = "none";
    private boolean useGradients = false;
    private int background;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private double wh;
    private double hh;
    private double mh;
    private int pLength = 0;
    private double[][] polygon = new double[Polygon.MAXPOLYVERTEX][13];
    protected double transparency = 0.0;
    protected double oneMinusTransparency = 1.0;
    private PrintWriter writer;
    private int count;

    public PSRasterizer(PrintWriter w) {
        this.writer = w;
    }

    public void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = p.getShader().getVertexShader().getTransparency();
        this.oneMinusTransparency = 1.0 - this.transparency;
        this.pLength = p.length;
        if (this.pLength == 0) {
            System.err.println("Warning polygon of length 0");
            return;
        }
        double[] t0 = new double[13];
        for (int i = 0; i < this.pLength; ++i) {
            int pos = p.vertices[i];
            double[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * this.mh;
            pi[0] = this.wh + vertexData[pos + 0] * wxy;
            pi[1] = this.hh - vertexData[pos + 1] * wxy;
            pi[2] = vertexData[pos + 2] * w;
            pi[4] = vertexData[pos + 4] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 4];
            pi[5] = vertexData[pos + 5] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 5];
            pi[6] = vertexData[pos + 6] > 1.0 ? 255.0 : 255.0 * vertexData[pos + 6];
            t0[0] = t0[0] + pi[0];
            t0[1] = t0[1] + pi[1];
            t0[2] = t0[2] + pi[2];
            t0[4] = t0[4] + pi[4];
            t0[5] = t0[5] + pi[5];
            t0[6] = t0[6] + pi[6];
        }
        t0[0] = t0[0] / (double)this.pLength;
        t0[1] = t0[1] / (double)this.pLength;
        t0[4] = t0[4] / (double)this.pLength;
        t0[5] = t0[5] / (double)this.pLength;
        t0[6] = t0[6] / (double)this.pLength;
        double[][] pol = new double[3][];
        pol[2] = t0;
        for (int n = 0; n < this.pLength - 1; ++n) {
            pol[0] = this.polygon[n];
            pol[1] = this.polygon[n + 1];
            this.writePolygon(pol);
            ++this.count;
        }
        pol[0] = this.polygon[this.pLength - 1];
        pol[1] = this.polygon[0];
        this.writePolygon(pol);
        ++this.count;
        if (p.getShader().isOutline()) {
            this.linePolygon(this.polygon);
        }
        ++this.count;
    }

    private void writePolygon(double[][] polygon) {
        this.writer.println("<<\n/ColorSpace [/DeviceRGB]\n/ShadingType 4\n/DataSource [");
        for (int i = 0; i < 3; ++i) {
            this.writer.print(" 0");
            this.writer.print(" " + polygon[i][0]);
            this.writer.print(" " + ((double)(this.ymax - this.ymin) - polygon[i][1]));
            this.writer.print(" " + polygon[i][4] / 255.0);
            this.writer.print(" " + polygon[i][5] / 255.0);
            this.writer.println(" " + polygon[i][6] / 255.0);
        }
        this.writer.print("]\n>> shfill");
    }

    private void linePolygon(double[][] p) {
        this.writer.println("\n" + p[0][0] + " " + ((double)(this.ymax - this.ymin) - p[0][1]) + " moveto");
        for (int i = 1; i < this.pLength; ++i) {
            this.writer.println(p[i][0] + " " + ((double)(this.ymax - this.ymin) - p[i][1]) + " lineto");
        }
        this.writer.println("\n" + p[0][0] + " " + ((double)(this.ymax - this.ymin) - p[0][1]) + " lineto");
        this.writer.println("stroke");
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public void clear() {
    }

    public void start() {
        this.count = 0;
        this.writer.println("%!PS-Adobe-3.0 EPSF-3.0\n%%Creator: jReality");
        this.writer.println("%%LanguageLevel: 3");
        this.writer.println("%%BoundingBox: " + this.xmin + " " + this.ymin + " " + (this.xmax - this.xmin) + " " + (this.ymax - this.ymin) + "\n%%EndComments");
        this.writer.println("gsave\n");
    }

    public void stop() {
        this.writer.println(" \ngrestore");
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
    }
}

