/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.HatchImager;
import de.jreality.soft.Imager;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.SkyboxPolygonShader;
import de.jreality.soft.Texture;
import de.jreality.soft.ToonImager;
import de.jreality.util.Secure;
import java.util.Arrays;

public class NewPolygonRasterizer
implements PolygonRasterizer {
    public static final int FIXP = 16;
    protected static final int FIXPS = 65536;
    protected static final long LONG_DFIXPS = 0x100000000L;
    protected static final double DOUBLE_DFIXPS = 4.294967296E9;
    protected static final int HIGH_BITS = -65536;
    protected static final int MAX_RANGE_FACTOR = 16383;
    public static final int COLOR_CH_SCALE = NewPolygonRasterizer.fpInverse(0xFE0000);
    public static final int COLOR_CH_MASK = 255;
    private static final int OPAQUE = -16777216;
    protected static final int R_MASK = 0xFF0000;
    protected static final int G_MASK = 65280;
    protected static final int B_MASK = 255;
    private static final boolean correctInterpolation = false;
    private Imager imager = null;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private int wh;
    private int hh;
    private int minDim;
    private int maxDim;
    private int[][] polygon;
    private final Quantity xxx;
    private final Quantity yyy;
    private final Quantity zzz;
    private final Quantity www;
    private final Quantity rrr;
    private final Quantity ggg;
    private final Quantity bbb;
    private final Quantity aaa;
    private final Quantity uuu;
    private final Quantity vvv;
    private boolean interpolateColor;
    private boolean interpolateW;
    private boolean interpolateA;
    private boolean interpolateUV;
    protected int transparency;
    protected double dTransparency;
    private Texture texture;
    private int[] zBuffer;
    private int w;
    private int h;
    private int[] pixels;
    private int background;
    private final int[] color;
    private static final int ZEPS = -6;

    public NewPolygonRasterizer(int[] pixelBuf) {
        try {
            String img = Secure.getProperty("jreality.soft.imager");
            if (img != null && img.equals("hatch")) {
                this.imager = new HatchImager();
            }
            if (img != null && img.equals("toon")) {
                this.imager = new ToonImager();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.xmin = 0;
        this.xmax = 0;
        this.ymin = 0;
        this.ymax = 0;
        this.polygon = new int[Polygon.MAXPOLYVERTEX][13];
        this.xxx = new Quantity();
        this.yyy = new Quantity();
        this.zzz = new Quantity();
        this.www = new Quantity();
        this.rrr = new Quantity();
        this.ggg = new Quantity();
        this.bbb = new Quantity();
        this.aaa = new Quantity();
        this.uuu = new Quantity();
        this.vvv = new Quantity();
        this.transparency = 0;
        this.dTransparency = 0.0;
        this.texture = null;
        this.color = new int[4];
        this.pixels = pixelBuf;
    }

    public final void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.dTransparency = p.getShader().getVertexShader().getTransparency();
        this.transparency = (int)(65536.0 * this.dTransparency);
        this.texture = p.getShader().getTexture();
        this.interpolateUV = this.texture != null;
        this.interpolateColor = p.getShader().interpolateColor();
        this.interpolateW = false;
        int pLength = p.length;
        for (int i = 0; i < pLength; ++i) {
            int pos = p.vertices[i];
            int[] pi = this.polygon[i];
            double w = 65536.0 / vertexData[pos + 3];
            double wxy = w * (double)this.minDim;
            pi[0] = (int)((double)this.wh + vertexData[pos + 0] * wxy);
            pi[1] = (int)((double)this.hh - vertexData[pos + 1] * wxy);
            pi[2] = (int)(vertexData[pos + 2] * w * 16383.0);
            if (p.getShader() instanceof SkyboxPolygonShader) {
                pi[2] = 0x7FFFFFFE;
            }
            double iw = (this.interpolateW ? w : 65536.0) * 16383.0;
            pi[3] = (int)iw;
            pi[8] = (int)(vertexData[pos + 8] * iw);
            pi[9] = (int)(vertexData[pos + 9] * iw);
            pi[7] = (int)(vertexData[pos + 7] * iw);
            if (!this.interpolateColor) continue;
            pi[4] = (int)((vertexData[pos + 4] >= 1.0 ? 1.0 : vertexData[pos + 4]) * iw);
            pi[5] = (int)((vertexData[pos + 5] >= 1.0 ? 1.0 : vertexData[pos + 5]) * iw);
            pi[6] = (int)((vertexData[pos + 6] >= 1.0 ? 1.0 : vertexData[pos + 6]) * iw);
        }
        if (!this.interpolateColor) {
            int pos = p.vertices[0];
            this.rrr.value = (int)Math.min(1.073676288E9, vertexData[pos + 4] * 65536.0 * 16383.0);
            this.ggg.value = (int)Math.min(1.073676288E9, vertexData[pos + 5] * 65536.0 * 16383.0);
            this.bbb.value = (int)Math.min(1.073676288E9, vertexData[pos + 6] * 65536.0 * 16383.0);
        }
        this.www.value = this.polygon[0][3];
        this.interpolateA = p.getShader().interpolateAlpha();
        if (this.interpolateA) {
            this.aaa.value = 1;
        }
        if (outline) {
            this.transparency = 0;
            for (int j = 0; j < pLength - 1; ++j) {
                this.line(this.polygon[j][0], this.polygon[j][1], this.polygon[j][2], this.polygon[j + 1][0], this.polygon[j + 1][1], this.polygon[j + 1][2], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[pLength - 1][0], this.polygon[pLength - 1][1], this.polygon[pLength - 1][2], this.polygon[0][0], this.polygon[0][1], this.polygon[0][2], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.scanPolygon(this.polygon, pLength);
    }

    private final void scanPolygon(int[][] p, int plength) {
        int ry;
        int top = 0;
        if (plength > Polygon.MAXPOLYVERTEX) {
            System.err.println("scanPoly: polygon had to many vertices: " + plength);
            return;
        }
        int minY = Integer.MAX_VALUE;
        for (int i = 0; i < plength; ++i) {
            if (p[i][1] >= minY) continue;
            minY = p[i][1];
            top = i;
        }
        int li = top;
        int ri = top;
        int rem = plength;
        int y = NewPolygonRasterizer.fpCeil(minY - 32768);
        int ly = ry = y - 1;
        while (rem > 0) {
            int i = li;
            while (ly <= y && rem > 0) {
                --rem;
                li = i--;
                if (i < 0) {
                    i = plength - 1;
                }
                ly = NewPolygonRasterizer.fpFloor(p[i][1] + 32768);
            }
            if (i != li) {
                this.makeYIncrement(p[li], p[i], y, true);
                li = i;
            }
            i = ri;
            while (ry <= y && rem > 0) {
                --rem;
                ri = i++;
                if (i >= plength) {
                    i = 0;
                }
                ry = NewPolygonRasterizer.fpFloor(p[i][1] + 32768);
            }
            if (i != ri) {
                this.makeYIncrement(p[ri], p[i], y, false);
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= this.ymin && y < this.ymax) {
                    this.scanline(y);
                }
                ++y;
                this.xxx.incrementY();
                this.zzz.incrementY();
                if (this.interpolateW) {
                    this.www.incrementY();
                }
                if (this.interpolateColor) {
                    this.rrr.incrementY();
                    this.ggg.incrementY();
                    this.bbb.incrementY();
                }
                if (this.interpolateA) {
                    this.aaa.incrementY();
                }
                if (!this.interpolateUV) continue;
                this.uuu.incrementY();
                this.vvv.incrementY();
            }
        }
    }

    private final void makeYIncrement(int[] p1, int[] p2, int y, boolean left) {
        int p1y = p1[1];
        int tmp = p2[1] - p1y;
        int dy = NewPolygonRasterizer.fpInverse(65536 > tmp ? 65536 : tmp);
        int frac = (y << 16) + 32768 - p1y;
        if (left) {
            this.xxx.makeLeftYIncrement(p1[0], p2[0], dy, frac);
            this.zzz.makeLeftYIncrement(p1[2], p2[2], dy, frac);
            if (this.interpolateW) {
                this.www.makeLeftYIncrement(p1[3], p2[3], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeLeftYIncrement(p1[4], p2[4], dy, frac);
                this.ggg.makeLeftYIncrement(p1[5], p2[5], dy, frac);
                this.bbb.makeLeftYIncrement(p1[6], p2[6], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeLeftYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeLeftYIncrement(p1[8], p2[8], dy, frac);
                this.vvv.makeLeftYIncrement(p1[9], p2[9], dy, frac);
            }
        } else {
            this.xxx.makeRightYIncrement(p1[0], p2[0], dy, frac);
            this.zzz.makeRightYIncrement(p1[2], p2[2], dy, frac);
            if (this.interpolateW) {
                this.www.makeRightYIncrement(p1[3], p2[3], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeRightYIncrement(p1[4], p2[4], dy, frac);
                this.ggg.makeRightYIncrement(p1[5], p2[5], dy, frac);
                this.bbb.makeRightYIncrement(p1[6], p2[6], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeRightYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeRightYIncrement(p1[8], p2[8], dy, frac);
                this.vvv.makeRightYIncrement(p1[9], p2[9], dy, frac);
            }
        }
    }

    private final void scanline(int y) {
        int inc;
        int rx;
        int lx;
        boolean lr;
        int l = this.xxx.leftValue;
        int r = this.xxx.rightValue;
        boolean bl = lr = l < r;
        if (lr) {
            lx = NewPolygonRasterizer.fpCeil(l - 32768);
            rx = NewPolygonRasterizer.fpFloor(r - 32768);
            if (lx < this.xmin) {
                lx = this.xmin;
            }
            if (rx >= this.xmax) {
                rx = this.xmax - 1;
            }
            if (lx > rx) {
                return;
            }
            inc = 1;
        } else {
            lx = NewPolygonRasterizer.fpFloor(l - 32768);
            rx = NewPolygonRasterizer.fpCeil(r - 32768);
            if (rx < this.xmin) {
                rx = this.xmin;
            }
            if (lx >= this.xmax) {
                lx = this.xmax - 1;
            }
            if (rx > lx) {
                return;
            }
            inc = -1;
        }
        this.makeXincrement(lx);
        int posOff = y * this.w;
        this.colorize(lx + posOff);
        int end = inc * (rx + posOff);
        int x = lx + inc + posOff;
        while (x * inc <= end) {
            this.zzz.incrementX();
            if (this.interpolateW) {
                this.www.incrementX();
            }
            if (this.interpolateColor) {
                this.rrr.incrementX();
                this.ggg.incrementX();
                this.bbb.incrementX();
            }
            if (this.interpolateA) {
                this.aaa.incrementX();
            }
            if (this.interpolateUV) {
                this.uuu.incrementX();
                this.vvv.incrementX();
            }
            this.colorize(x);
            x += inc;
        }
    }

    private static final int abs(int a) {
        return a < 0 ? -a : a;
    }

    private final void makeXincrement(int leftBound) {
        int tmp = NewPolygonRasterizer.abs(this.xxx.rightValue - this.xxx.leftValue);
        int dx = NewPolygonRasterizer.fpInverse(tmp > 65536 ? tmp : 65536);
        int frac = NewPolygonRasterizer.abs((leftBound << 16) + 32768 - this.xxx.leftValue);
        this.zzz.makeXIncrement(dx, frac);
        if (this.interpolateW) {
            this.www.makeXIncrement(dx, frac);
        }
        if (this.interpolateColor) {
            this.rrr.makeXIncrement(dx, frac);
            this.ggg.makeXIncrement(dx, frac);
            this.bbb.makeXIncrement(dx, frac);
        }
        if (this.interpolateA) {
            this.aaa.makeXIncrement(dx, frac);
        }
        if (this.interpolateUV) {
            this.uuu.makeXIncrement(dx, frac);
            this.vvv.makeXIncrement(dx, frac);
        }
    }

    private final void colorize(int pos) {
        int z = this.zzz.value;
        if (z >= this.zBuffer[pos]) {
            return;
        }
        int ww = this.www.value;
        double factor = this.interpolateColor ? 255.0 / (double)ww : 2.375017524835195E-7;
        int r = (int)((double)this.rrr.value * factor);
        int g = (int)((double)this.ggg.value * factor);
        int b = (int)((double)this.bbb.value * factor);
        int omt = 255 * (65536 - this.transparency) >> 16;
        if (this.interpolateA) {
            omt = (int)((1.0 - this.dTransparency) * factor * (double)this.aaa.value);
        }
        if (this.interpolateUV) {
            int[] color = this.color;
            double WW = ww;
            color[0] = r;
            color[1] = g;
            color[2] = b;
            color[3] = omt;
            this.texture.getColor((double)this.uuu.value / WW, (double)this.vvv.value / WW, pos % this.w, pos / this.w, color);
            omt = color[3] * COLOR_CH_SCALE >> 16;
            r = color[0] * COLOR_CH_SCALE >> 16;
            g = color[1] * COLOR_CH_SCALE >> 16;
            b = color[2] * COLOR_CH_SCALE >> 16;
        }
        if (omt < 255) {
            int sample = this.pixels[pos];
            int t = 255 - omt;
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            r = (r * omt + t * sr) * 257 & 0xFF0000;
            g = (g * omt + t * sg) * 257 >> 8 & 0xFF00;
            b = (b * omt + t * sb) * 257 >> 16 & 0xFF;
        } else {
            r = r << 16 & 0xFF0000;
            g = g << 8 & 0xFF00;
            b &= 0xFF;
        }
        this.pixels[pos] = 0xFF000000 | r | g | b;
        this.zBuffer[pos] = z;
    }

    private final void line(int x1, int y1, int z1, int x2, int y2, int z2, int xmin, int xmax, int ymin, int ymax) {
        int dirX = x2 - x1;
        int dirY = y2 - y1;
        int dirZ = z2 - z1;
        double l = (double)dirX * (double)dirX + (double)dirY * (double)dirY;
        int il = 1 * ((int)(l = Math.sqrt(l)) >> 16);
        if (il == 0) {
            return;
        }
        int zz1 = z1 - (dirZ /= il) + -6;
        int zz2 = z2 + dirZ + -6;
        this.scanPolygon(new int[][]{{x1 - (dirX /= il) - (dirY /= il), y1 - dirY + dirX, zz1, 0, 0, 0, 0, 0, 1}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0, 0, 0, 0, 0, 1}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0, 0, 0, 0, 0, 1}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0, 0, 0, 0, 0, 1}}, 4);
    }

    public final void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new int[numPx];
        }
    }

    public final void setSize(double width, double height) {
        this.wh = (int)width / 2;
        this.hh = (int)height / 2;
        this.minDim = Math.min(this.wh, this.hh);
        this.maxDim = Math.max(this.wh, this.hh);
        this.wh *= 65536;
        this.hh *= 65536;
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public final void clear() {
        Arrays.fill(this.zBuffer, Integer.MAX_VALUE);
        Arrays.fill(this.pixels, this.background);
    }

    public final void start() {
    }

    public final void stop() {
        if (this.imager != null) {
            this.imager.process(this.pixels, this.zBuffer, this.w, this.h);
        }
    }

    public static final int fpTimes(int x, int y) {
        return (int)((long)x * (long)y >> 16);
    }

    public static final long fpTimes(long x, long y) {
        return x * y >> 16;
    }

    public static final int fpInverse(int x) {
        return (int)(4.294967296E9 / (double)x);
    }

    public static long fpInverse(long x) {
        return 0x100000000L / x;
    }

    public static final int fpCeil(int x) {
        return x + 65536 - 1 >> 16;
    }

    public static final int fpFloor(int x) {
        return x >> 16;
    }

    private static final class Quantity {
        public int leftValue;
        public int leftYIncrement;
        public int rightValue;
        public int rightYIncrement;
        public int value;
        public int xIncrement;

        Quantity() {
        }

        final void makeXIncrement(int dxi, int frac) {
            this.xIncrement = NewPolygonRasterizer.fpTimes(this.rightValue - this.leftValue, dxi);
            this.value = this.leftValue + NewPolygonRasterizer.fpTimes(this.xIncrement, frac);
        }

        final void makeLeftYIncrement(int start, int end, int dyi, int frac) {
            this.leftYIncrement = NewPolygonRasterizer.fpTimes(end - start, dyi);
            this.leftValue = start + NewPolygonRasterizer.fpTimes(this.leftYIncrement, frac);
        }

        final void makeRightYIncrement(int start, int end, int dy, int frac) {
            this.rightYIncrement = NewPolygonRasterizer.fpTimes(end - start, dy);
            this.rightValue = start + NewPolygonRasterizer.fpTimes(this.rightYIncrement, frac);
        }

        final void incrementY() {
            this.leftValue += this.leftYIncrement;
            this.rightValue += this.rightYIncrement;
        }

        final void incrementX() {
            this.value += this.xIncrement;
        }

        public void dump() {
            System.out.println("dump:");
            System.out.println("value      :" + this.value);
            System.out.println("xIncr      :" + this.xIncrement);
            System.out.println("leftValue  :" + this.leftValue);
            System.out.println("leftIncr   :" + this.leftYIncrement);
            System.out.println("rightValue :" + this.rightValue);
            System.out.println("rightIncr  :" + this.rightYIncrement);
        }
    }
}

