/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.SkyboxPolygonShader;
import de.jreality.soft.Texture;
import java.util.Arrays;

public class NewDoublePolygonRasterizer
implements PolygonRasterizer {
    private static final double COLOR_CH_SCALE = 0.00392156862745098;
    private static final int COLOR_CH_MASK = 255;
    private static final int OPAQUE = -16777216;
    private static final boolean correctInterpolation = true;
    private final Colorizer colorizer;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private double wh;
    private double hh;
    private double minDim;
    private double maxDim;
    private double[][] polygon = new double[Polygon.MAXPOLYVERTEX][13];
    private final Quantity xxx = new Quantity();
    private final Quantity yyy = new Quantity();
    private final Quantity zzz = new Quantity();
    private final Quantity www = new Quantity();
    private final Quantity rrr = new Quantity();
    private final Quantity ggg = new Quantity();
    private final Quantity bbb = new Quantity();
    private final Quantity aaa = new Quantity();
    private final Quantity uuu = new Quantity();
    private final Quantity vvv = new Quantity();
    private final boolean interpolateY;
    private final boolean interpolateFullX;
    private boolean interpolateColor;
    private boolean interpolateW;
    private boolean interpolateA;
    private boolean interpolateUV;
    protected double transparency = 0.0;
    private Texture texture = null;
    private double[] zBuffer;
    private int w;
    private int h;
    private int[] pixels;
    private int background;
    private final int[] color = new int[4];
    final double[] data = new double[13];
    private static final double ZEPS = -1.0E-4;

    public NewDoublePolygonRasterizer(int[] pixelBuf, boolean interpolateY, boolean interpolateFullX, Colorizer colorizer) {
        this.colorizer = colorizer;
        this.interpolateY = interpolateY;
        this.interpolateFullX = interpolateFullX;
        this.pixels = pixelBuf;
    }

    public NewDoublePolygonRasterizer(int[] pixelBuf) {
        this(pixelBuf, false, false, null);
    }

    public final void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = p.getShader().getVertexShader().getTransparency();
        this.texture = p.getShader().getTexture();
        this.interpolateUV = this.texture != null;
        this.interpolateColor = p.getShader().interpolateColor();
        this.interpolateW = this.interpolateColor || this.interpolateUV;
        int pLength = p.length;
        for (int i = 0; i < pLength; ++i) {
            double iw;
            int pos = p.vertices[i];
            double[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * this.minDim;
            pi[0] = this.wh + vertexData[pos + 0] * wxy;
            pi[1] = this.hh - vertexData[pos + 1] * wxy;
            pi[2] = vertexData[pos + 2] * w;
            if (p.getShader() instanceof SkyboxPolygonShader) {
                pi[2] = 2.0;
            }
            pi[3] = iw = this.interpolateW ? w : 1.0;
            pi[8] = vertexData[pos + 8] * iw;
            pi[9] = vertexData[pos + 9] * iw;
            pi[7] = vertexData[pos + 7] * iw;
            if (!this.interpolateColor) continue;
            pi[4] = (vertexData[pos + 4] >= 1.0 ? 1.0 : vertexData[pos + 4]) * iw;
            pi[5] = (vertexData[pos + 5] >= 1.0 ? 1.0 : vertexData[pos + 5]) * iw;
            pi[6] = (vertexData[pos + 6] >= 1.0 ? 1.0 : vertexData[pos + 6]) * iw;
        }
        if (!this.interpolateColor) {
            int pos = p.vertices[0];
            this.rrr.value = Math.min(1.0, vertexData[pos + 4]);
            this.ggg.value = Math.min(1.0, vertexData[pos + 5]);
            this.bbb.value = Math.min(1.0, vertexData[pos + 6]);
        }
        this.www.value = this.polygon[0][3];
        this.interpolateA = p.getShader().interpolateAlpha();
        if (this.interpolateA) {
            this.aaa.value = 1.0;
        }
        if (outline) {
            this.transparency = 0.0;
            for (int j = 0; j < pLength - 1; ++j) {
                this.line(this.polygon[j][0], this.polygon[j][1], this.polygon[j][2], this.polygon[j + 1][0], this.polygon[j + 1][1], this.polygon[j + 1][2], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[pLength - 1][0], this.polygon[pLength - 1][1], this.polygon[pLength - 1][2], this.polygon[0][0], this.polygon[0][1], this.polygon[0][2], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.scanPolygon(this.polygon, pLength);
    }

    private final void scanPolygon(double[][] p, int plength) {
        int ry;
        int top = 0;
        if (plength > Polygon.MAXPOLYVERTEX) {
            System.err.println("scanPoly: polygon had to many vertices: " + plength);
            return;
        }
        double minY = Double.MAX_VALUE;
        for (int i = 0; i < plength; ++i) {
            if (!(p[i][1] < minY)) continue;
            minY = p[i][1];
            top = i;
        }
        int li = top;
        int ri = top;
        int rem = plength;
        int y = (int)Math.ceil(minY - 0.5);
        int ly = ry = y - 1;
        while (rem > 0) {
            int i = li;
            while (ly <= y && rem > 0) {
                --rem;
                li = i--;
                if (i < 0) {
                    i = plength - 1;
                }
                ly = (int)Math.floor(p[i][1] + 0.5);
            }
            if (i != li) {
                this.makeYIncrement(p[li], p[i], y, true);
                li = i;
            }
            i = ri;
            while (ry <= y && rem > 0) {
                --rem;
                ri = i++;
                if (i >= plength) {
                    i = 0;
                }
                ry = (int)Math.floor(p[i][1] + 0.5);
            }
            if (i != ri) {
                this.makeYIncrement(p[ri], p[i], y, false);
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= this.ymin && y < this.ymax) {
                    this.scanline(y);
                }
                ++y;
                this.xxx.incrementY();
                if (this.interpolateY) {
                    this.yyy.incrementY();
                }
                this.zzz.incrementY();
                if (this.interpolateW) {
                    this.www.incrementY();
                }
                if (this.interpolateColor) {
                    this.rrr.incrementY();
                    this.ggg.incrementY();
                    this.bbb.incrementY();
                }
                if (this.interpolateA) {
                    this.aaa.incrementY();
                }
                if (!this.interpolateUV) continue;
                this.uuu.incrementY();
                this.vvv.incrementY();
            }
        }
    }

    private final void makeYIncrement(double[] p1, double[] p2, int y, boolean left) {
        double p1y = p1[1];
        double dy = 1.0 / Math.max(1.0, p2[1] - p1y);
        double frac = (double)y + 0.5 - p1y;
        if (left) {
            this.xxx.makeLeftYIncrement(p1[0], p2[0], dy, frac);
            if (this.interpolateY) {
                this.yyy.makeLeftYIncrement(p1[1], p2[1], dy, frac);
            }
            this.zzz.makeLeftYIncrement(p1[2], p2[2], dy, frac);
            if (this.interpolateW) {
                this.www.makeLeftYIncrement(p1[3], p2[3], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeLeftYIncrement(p1[4], p2[4], dy, frac);
                this.ggg.makeLeftYIncrement(p1[5], p2[5], dy, frac);
                this.bbb.makeLeftYIncrement(p1[6], p2[6], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeLeftYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeLeftYIncrement(p1[8], p2[8], dy, frac);
                this.vvv.makeLeftYIncrement(p1[9], p2[9], dy, frac);
            }
        } else {
            this.xxx.makeRightYIncrement(p1[0], p2[0], dy, frac);
            if (this.interpolateY) {
                this.yyy.makeRightYIncrement(p1[1], p2[1], dy, frac);
            }
            this.zzz.makeRightYIncrement(p1[2], p2[2], dy, frac);
            if (this.interpolateW) {
                this.www.makeRightYIncrement(p1[3], p2[3], dy, frac);
            }
            if (this.interpolateColor) {
                this.rrr.makeRightYIncrement(p1[4], p2[4], dy, frac);
                this.ggg.makeRightYIncrement(p1[5], p2[5], dy, frac);
                this.bbb.makeRightYIncrement(p1[6], p2[6], dy, frac);
            }
            if (this.interpolateA) {
                this.aaa.makeRightYIncrement(p1[7], p2[7], dy, frac);
            }
            if (this.interpolateUV) {
                this.uuu.makeRightYIncrement(p1[8], p2[8], dy, frac);
                this.vvv.makeRightYIncrement(p1[9], p2[9], dy, frac);
            }
        }
    }

    private final void scanline(int y) {
        int rx;
        int lx;
        boolean lr;
        double l = this.xxx.leftValue;
        double r = this.xxx.rightValue;
        boolean bl = lr = l < r;
        if (lr) {
            lx = (int)Math.ceil(l - 0.5);
            rx = (int)Math.floor(r - 0.5);
            if (lx < this.xmin) {
                lx = this.xmin;
            }
            if (rx >= this.xmax) {
                rx = this.xmax - 1;
            }
            if (lx > rx) {
                return;
            }
        } else {
            lx = (int)Math.floor(l - 0.5);
            rx = (int)Math.ceil(r - 0.5);
            if (rx < this.xmin) {
                rx = this.xmin;
            }
            if (lx >= this.xmax) {
                lx = this.xmax - 1;
            }
            if (rx > lx) {
                return;
            }
        }
        this.makeXincrement(lx);
        int inc = lr ? 1 : -1;
        int posOff = y * this.w;
        this.colorize(lx + posOff);
        int x = lx + inc + posOff;
        while (lr ? x <= rx + posOff : x >= rx + posOff) {
            if (this.interpolateFullX) {
                this.xxx.incrementX();
            }
            if (this.interpolateY) {
                this.yyy.incrementX();
            }
            this.zzz.incrementX();
            if (this.interpolateW) {
                this.www.incrementX();
            }
            if (this.interpolateColor) {
                this.rrr.incrementX();
                this.ggg.incrementX();
                this.bbb.incrementX();
            }
            if (this.interpolateA) {
                this.aaa.incrementX();
            }
            if (this.interpolateUV) {
                this.uuu.incrementX();
                this.vvv.incrementX();
            }
            this.colorize(x);
            x += inc;
        }
    }

    private final void makeXincrement(int leftBound) {
        double dx = 1.0 / Math.max(1.0, Math.abs(this.xxx.rightValue - this.xxx.leftValue));
        double frac = Math.abs((double)leftBound + 0.5 - this.xxx.leftValue);
        if (this.interpolateFullX) {
            this.xxx.makeXIncrement(dx, frac);
        }
        if (this.interpolateY) {
            this.yyy.makeXIncrement(dx, frac);
        }
        this.zzz.makeXIncrement(dx, frac);
        if (this.interpolateW) {
            this.www.makeXIncrement(dx, frac);
        }
        if (this.interpolateColor) {
            this.rrr.makeXIncrement(dx, frac);
            this.ggg.makeXIncrement(dx, frac);
            this.bbb.makeXIncrement(dx, frac);
        }
        if (this.interpolateA) {
            this.aaa.makeXIncrement(dx, frac);
        }
        if (this.interpolateUV) {
            this.uuu.makeXIncrement(dx, frac);
            this.vvv.makeXIncrement(dx, frac);
        }
    }

    private final void colorize(int pos) {
        double z = this.zzz.value;
        if (z >= this.zBuffer[pos]) {
            return;
        }
        double ww = this.www.value;
        double factor = this.interpolateColor ? 255.0 / ww : 255.0;
        double r = this.rrr.value * factor;
        double g = this.ggg.value * factor;
        double b = this.bbb.value * factor;
        double omt = 1.0 - this.transparency;
        if (this.interpolateA) {
            omt = omt * this.aaa.value / ww;
        }
        if (this.interpolateUV) {
            int[] color = this.color;
            double WW = ww;
            color[0] = (int)r;
            color[1] = (int)g;
            color[2] = (int)b;
            color[3] = (int)omt;
            this.texture.getColor(this.uuu.value / WW, this.vvv.value / WW, pos % this.w, pos / this.w, color);
            omt = (double)color[3] * 0.00392156862745098;
            r = (double)color[0] * 0.00392156862745098;
            g = (double)color[1] * 0.00392156862745098;
            b = (double)color[2] * 0.00392156862745098;
        }
        if (omt < 1.0) {
            int sample = this.pixels[pos];
            double t = 1.0 - omt;
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            r = r * omt + t * (double)sr;
            g = g * omt + t * (double)sg;
            b = b * omt + t * (double)sb;
        }
        if (this.colorizer != null) {
            this.data[0] = this.xxx.value / ww;
            this.data[1] = this.yyy.value / ww;
            this.data[2] = z;
            this.data[4] = r;
            this.data[5] = g;
            this.data[6] = b;
            this.data[7] = this.aaa.value / ww;
            this.data[8] = this.uuu.value / ww;
            this.data[9] = this.vvv.value / ww;
            this.colorizer.colorize(this.pixels, this.zBuffer, pos, this.data, this.interpolateUV);
        } else {
            this.pixels[pos] = 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
            this.zBuffer[pos] = z;
        }
    }

    private final void line(double x1, double y1, double z1, double x2, double y2, double z2, int xmin, int xmax, int ymin, int ymax) {
        double dirX = x2 - x1;
        double dirY = y2 - y1;
        double dirZ = z2 - z1;
        double l = dirX * dirX + dirY * dirY;
        if ((l = Math.sqrt(l)) < 1.0) {
            return;
        }
        double zz1 = z1 - (dirZ /= l) + -1.0E-4;
        double zz2 = z2 + dirZ + -1.0E-4;
        this.scanPolygon(new double[][]{{x1 - (dirX /= l) - (dirY /= l), y1 - dirY + dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}}, 4);
    }

    public final void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new double[numPx];
        }
    }

    public final void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.minDim = Math.min(this.wh, this.hh);
        this.maxDim = Math.max(this.wh, this.hh);
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public final void clear() {
        Arrays.fill(this.zBuffer, 2.147483647E9);
        Arrays.fill(this.pixels, this.background);
    }

    public final void start() {
    }

    public final void stop() {
    }

    public boolean isInterpolateUV() {
        return this.interpolateUV;
    }

    public static abstract class Colorizer {
        public abstract void colorize(int[] var1, double[] var2, int var3, double[] var4, boolean var5);
    }

    private final class Quantity {
        double leftValue;
        double leftYIncrement;
        double rightValue;
        double rightYIncrement;
        double value;
        double xIncrement;

        Quantity() {
        }

        final void makeXIncrement(double dx, double frac) {
            this.xIncrement = (this.rightValue - this.leftValue) * dx;
            this.value = this.leftValue + this.xIncrement * frac;
        }

        final void makeLeftYIncrement(double start, double end, double dy, double frac) {
            this.leftYIncrement = (end - start) * dy;
            this.leftValue = start + this.leftYIncrement * frac;
        }

        final void makeRightYIncrement(double start, double end, double dy, double frac) {
            this.rightYIncrement = (end - start) * dy;
            this.rightValue = start + this.rightYIncrement * frac;
        }

        final void incrementY() {
            this.leftValue += this.leftYIncrement;
            this.rightValue += this.rightYIncrement;
        }

        final void incrementX() {
            this.value += this.xIncrement;
        }

        public void dump() {
            System.out.println("dump:");
            System.out.println("value      :" + this.value);
            System.out.println("xIncr      :" + this.xIncrement);
            System.out.println("leftValue  :" + this.leftValue);
            System.out.println("leftIncr   :" + this.leftYIncrement);
            System.out.println("rightValue :" + this.rightValue);
            System.out.println("rightIncr  :" + this.rightYIncrement);
        }
    }
}

