/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.SkyboxPolygonShader;
import de.jreality.soft.Texture;

public abstract class ModularIntegerPolygonRasterizer
implements PolygonRasterizer {
    protected static final int FIXP = 14;
    protected static final int FIXPS = 16384;
    protected static final int FIXPZ = 30;
    protected static final int FIXPZS = 0x40000000;
    protected static final int FIXPT = 30;
    protected static final int FIXPTS = 0x40000000;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private int wh;
    private int hh;
    private int mh;
    private double maxDim;
    private int pLength = 0;
    private int[][] polygon = new int[Polygon.MAXPOLYVERTEX][13];
    protected int transparency = 0;
    protected int oneMinusTransparency = 255;
    private Texture texture = null;
    private boolean interpolateColor = true;
    private boolean interpolateAlpha = false;
    private boolean interpolateTexture = false;
    private static final boolean correctInterpolation = false;
    private int[][] tri = new int[3][];
    private int alsxI;
    private int alsyI;
    private int alszI;
    private int alrI;
    private int algI;
    private int albI;
    private int aluI;
    private int alvI;
    private int alwI;
    private int alaI;
    private int adlsxI;
    private int adlsyI;
    private int adlszI;
    private int adlrI;
    private int adlgI;
    private int adlbI;
    private int adluI;
    private int adlvI;
    private int adlwI;
    private int adlaI;
    private int arsxI;
    private int arsyI;
    private int arszI;
    private int arrI;
    private int argI;
    private int arbI;
    private int aruI;
    private int arvI;
    private int arwI;
    private int araI;
    private int adrsxI;
    private int adrsyI;
    private int adrszI;
    private int adrrI;
    private int adrgI;
    private int adrbI;
    private int adruI;
    private int adrvI;
    private int adrwI;
    private int adraI;
    protected int apsxI;
    protected int apsyI;
    protected int apszI;
    protected int aprI;
    protected int apgI;
    protected int apbI;
    protected int apuI;
    protected int apvI;
    protected int apwI;
    protected int apaI;
    protected int adpsxI;
    protected int adpsyI;
    protected int adpszI;
    protected int adprI;
    protected int adpgI;
    protected int adpbI;
    protected int adpuI;
    protected int adpvI;
    protected int adpwI;
    protected int adpaI;
    private int[] color = new int[4];
    private static final int FIXPHS = 65536;
    private static final int ZEPS = -107374;

    public final void renderPolygon(Polygon p, double[] vertexData, boolean outline) {
        this.transparency = (int)(p.getShader().getVertexShader().getTransparency() * 255.0);
        this.oneMinusTransparency = 255 - this.transparency;
        this.pLength = p.length;
        for (int i = 0; i < this.pLength; ++i) {
            int pos = p.vertices[i];
            int[] pi = this.polygon[i];
            double w = 1.0 / vertexData[pos + 3];
            double wxy = w * (double)this.mh;
            pi[0] = (int)((double)this.wh + vertexData[pos + 0] * wxy);
            pi[1] = (int)((double)this.hh - vertexData[pos + 1] * wxy);
            pi[2] = (int)(vertexData[pos + 2] * w * 1.073741824E9);
            if (p.getShader() instanceof SkyboxPolygonShader) {
                pi[2] = 0x40000000;
            }
            this.interpolateColor = p.getShader().interpolateColor();
            this.interpolateAlpha = p.getShader().interpolateAlpha();
            pi[8] = (int)(vertexData[pos + 8] * 1.073741824E9);
            pi[9] = (int)(vertexData[pos + 9] * 1.073741824E9);
            if (this.interpolateAlpha) {
                this.transparency = (int)(vertexData[pos + 7] > 1.0 ? 255.0 : vertexData[pos + 7] * 255.0);
                pi[7] = this.transparency * 16384;
                this.oneMinusTransparency = 255 - this.transparency;
                this.transparency = 0;
            }
            if (this.transparency == 0) {
                pi[4] = (int)((vertexData[pos + 4] > 1.0 ? 255.0 : vertexData[pos + 4] * 255.0) * 16384.0);
                pi[5] = (int)((vertexData[pos + 5] > 1.0 ? 255.0 : vertexData[pos + 5] * 255.0) * 16384.0);
                pi[6] = (int)((vertexData[pos + 6] > 1.0 ? 255.0 : vertexData[pos + 6] * 255.0) * 16384.0);
                continue;
            }
            pi[4] = this.oneMinusTransparency * (int)((vertexData[pos + 4] > 1.0 ? 255.0 : vertexData[pos + 4] * 255.0) * 16384.0);
            pi[5] = this.oneMinusTransparency * (int)((vertexData[pos + 5] > 1.0 ? 255.0 : vertexData[pos + 5] * 255.0) * 16384.0);
            pi[6] = this.oneMinusTransparency * (int)((vertexData[pos + 6] > 1.0 ? 255.0 : vertexData[pos + 6] * 255.0) * 16384.0);
        }
        if (outline) {
            this.transparency = 0;
            for (int j = 0; j < this.pLength - 1; ++j) {
                this.line(this.polygon[j][0], this.polygon[j][1], this.polygon[j][2], this.polygon[j + 1][0], this.polygon[j + 1][1], this.polygon[j + 1][2], this.xmin, this.xmax, this.ymin, this.ymax);
            }
            this.line(this.polygon[this.pLength - 1][0], this.polygon[this.pLength - 1][1], this.polygon[this.pLength - 1][2], this.polygon[0][0], this.polygon[0][1], this.polygon[0][2], this.xmin, this.xmax, this.ymin, this.ymax);
        }
        this.transparency = (int)(p.getShader().getVertexShader().getTransparency() * 255.0);
        this.texture = p.getShader().getTexture();
        this.interpolateTexture = this.texture != null;
        this.interpolateColor = p.getShader().interpolateColor();
        if (this.interpolateColor) {
            // empty if block
        }
        this.scanPolyI(this.polygon, this.pLength, this.xmin, this.xmax - 1, this.ymin, this.ymax - 1);
    }

    private final void scanPolyI(int[][] p, int plength, int wxmin, int wxmax, int wymin, int wymax) {
        int ry;
        int ri;
        int i;
        int top = 0;
        if (plength > Polygon.MAXPOLYVERTEX) {
            System.err.println("scanPoly: polygon had to many vertices: " + plength);
            return;
        }
        if (!this.interpolateColor) {
            this.aprI = p[0][4];
            this.apgI = p[0][5];
            this.apbI = p[0][6];
            this.apaI = p[0][7];
            this.adprI = 0;
            this.adpgI = 0;
            this.adpbI = 0;
        }
        if (!this.interpolateAlpha) {
            this.adpaI = 0;
        }
        this.adpwI = 0;
        if (!this.interpolateTexture) {
            this.adpuI = 0;
            this.adpvI = 0;
        }
        int ymin = Integer.MAX_VALUE;
        for (i = 0; i < plength; ++i) {
            if (p[i][1] >= ymin) continue;
            ymin = p[i][1];
            top = i;
        }
        int li = ri = top;
        int rem = plength;
        int y = ymin + 8192 - 1 >> 14;
        int ly = ry = y - 1;
        while (rem > 0) {
            while (ly <= y && rem > 0) {
                --rem;
                i = li - 1;
                if (i < 0) {
                    i = plength - 1;
                }
                this.incrementalizeYldlI(p[li], p[i], y);
                ly = p[i][1] + 8192 >> 14;
                li = i;
            }
            while (ry <= y && rem > 0) {
                --rem;
                i = ri + 1;
                if (i >= plength) {
                    i = 0;
                }
                this.incrementalizeYrdrI(p[ri], p[i], y);
                ry = p[i][1] + 8192 >> 14;
                ri = i;
            }
            while (y < ly && y < ry) {
                if (y >= wymin && y <= wymax) {
                    if (this.alsxI <= this.arsxI) {
                        this.scanlinelrI(y, wxmin, wxmax, wymin, wymax);
                    } else {
                        this.scanlinerlI(y, wxmin, wxmax, wymin, wymax);
                    }
                }
                ++y;
                this.incrementldlI();
                this.incrementrdrI();
            }
        }
    }

    private final void incrementldlI() {
        this.alsxI += this.adlsxI;
        this.alszI += this.adlszI;
        if (this.interpolateColor) {
            this.alrI += this.adlrI;
            this.algI += this.adlgI;
            this.albI += this.adlbI;
        }
        if (this.interpolateTexture) {
            this.aluI += this.adluI;
            this.alvI += this.adlvI;
        }
        if (this.interpolateAlpha) {
            this.alaI += this.adlaI;
        }
    }

    private final void incrementrdrI() {
        this.arsxI += this.adrsxI;
        this.arszI += this.adrszI;
        if (this.interpolateColor) {
            this.arrI += this.adrrI;
            this.argI += this.adrgI;
            this.arbI += this.adrbI;
        }
        if (this.interpolateTexture) {
            this.aruI += this.adruI;
            this.arvI += this.adrvI;
        }
        if (this.interpolateAlpha) {
            this.araI += this.adraI;
        }
    }

    private final void incrementpdpI() {
        this.apszI += this.adpszI;
        this.aprI += this.adprI;
        this.apgI += this.adpgI;
        this.apbI += this.adpbI;
        this.apuI += this.adpuI;
        this.apvI += this.adpvI;
        this.apwI += this.adpwI;
        this.apaI += this.adpaI;
    }

    private final void scanlinelrI(int y, int wxmin, int wxmax, int wymin, int wymax) {
        int x = 0;
        int lx = 0;
        int rx = 0;
        lx = this.alsxI + 8192 - 1 >> 14;
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = this.arsxI - 8192 >> 14) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXlrpdpI(lx);
        this.colorize(lx, y);
        for (x = lx + 1; x <= rx; ++x) {
            this.incrementpdpI();
            this.colorize(x, y);
        }
    }

    private final void colorize(int x, int y) {
        int pxTrans;
        int r = this.aprI;
        int g = this.apgI;
        int b = this.apbI;
        int t = 255 - this.transparency;
        if (this.interpolateTexture) {
            double div = 1.073741824E9;
            this.texture.getColor((double)this.apuI / div, (double)this.apvI / div, x, y, this.color);
            t = (0xFF & this.color[3]) + t >> 1;
            r = (r >> 8) * this.color[0];
            g = (g >> 8) * this.color[1];
            b = (b >> 8) * this.color[2];
        } else {
            t = 255 - this.transparency;
        }
        boolean ww = false;
        if (this.interpolateAlpha) {
            pxTrans = this.apaI >> 14;
            t = 255 - pxTrans;
        } else {
            pxTrans = 255 - t;
        }
        if (t < 255 && this.transparency == 0) {
            r *= t;
            g *= t;
            b *= t;
        }
        this.setPixel(x, y, this.apszI, r >>= 14, g >>= 14, b >>= 14, pxTrans);
    }

    private final void scanlinerlI(int y, int wxmin, int wxmax, int wymin, int wymax) {
        int rx;
        int lx = this.arsxI + 8192 - 1 >> 14;
        if (lx < wxmin) {
            lx = wxmin;
        }
        if ((rx = this.alsxI - 8192 >> 14) > wxmax) {
            rx = wxmax;
        }
        if (lx > rx) {
            return;
        }
        this.incrementalizeXrlpdpI(lx);
        this.colorize(lx, y);
        for (int x = lx + 1; x <= rx; ++x) {
            this.incrementpdpI();
            this.colorize(x, y);
        }
    }

    protected abstract void setPixel(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private final void incrementalizeXrlpdpI(int x) {
        int dx = this.alsxI - this.arsxI >> 7;
        if (dx < 128) {
            dx = 128;
        }
        int frac = (x << 14) + 8192 - this.arsxI >> 7;
        this.adpszI = (this.alszI - this.arszI) / dx;
        this.apszI = this.arszI + this.adpszI * frac;
        this.adpszI <<= 7;
        if (this.interpolateColor) {
            this.adprI = (this.alrI - this.arrI) / dx;
            this.aprI = this.arrI + this.adprI * frac;
            this.adprI <<= 7;
            this.adpgI = (this.algI - this.argI) / dx;
            this.apgI = this.argI + this.adpgI * frac;
            this.adpgI <<= 7;
            this.adpbI = (this.albI - this.arbI) / dx;
            this.apbI = this.arbI + this.adpbI * frac;
            this.adpbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adpuI = (this.aluI - this.aruI) / dx;
            this.apuI = this.aruI + this.adpuI * frac;
            this.adpuI <<= 7;
            this.adpvI = (this.alvI - this.arvI) / dx;
            this.apvI = this.arvI + this.adpvI * frac;
            this.adpvI <<= 7;
        }
        if (this.interpolateAlpha) {
            this.adpaI = (this.alaI - this.araI) / dx;
            this.apaI = this.araI + this.adpaI * frac;
            this.adpaI <<= 7;
        }
    }

    private final void incrementalizeXlrpdpI(int x) {
        int dx = this.arsxI - this.alsxI >> 7;
        if (dx < 128) {
            dx = 128;
        }
        int frac = (x << 14) + 8192 - this.alsxI >> 7;
        this.adpszI = (this.arszI - this.alszI) / dx;
        this.apszI = this.alszI + this.adpszI * frac;
        this.adpszI <<= 7;
        if (this.interpolateColor) {
            this.adprI = (this.arrI - this.alrI) / dx;
            this.aprI = this.alrI + this.adprI * frac;
            this.adprI <<= 7;
            this.adpgI = (this.argI - this.algI) / dx;
            this.apgI = this.algI + this.adpgI * frac;
            this.adpgI <<= 7;
            this.adpbI = (this.arbI - this.albI) / dx;
            this.apbI = this.albI + this.adpbI * frac;
            this.adpbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adpuI = (this.aruI - this.aluI) / dx;
            this.apuI = this.aluI + this.adpuI * frac;
            this.adpuI <<= 7;
            this.adpvI = (this.arvI - this.alvI) / dx;
            this.apvI = this.alvI + this.adpvI * frac;
            this.adpvI <<= 7;
        }
        if (this.interpolateAlpha) {
            this.adpaI = (this.araI - this.alaI) / dx;
            this.apaI = this.alaI + this.adpaI * frac;
            this.adpaI <<= 7;
        }
    }

    private final void incrementalizeYldlI(int[] p1, int[] p2, int y) {
        int dy = p2[1] - p1[1] >> 7;
        if (dy < 128) {
            dy = 128;
        }
        int frac = (y << 14) + 8192 - p1[1] >> 7;
        this.adlsxI = (p2[0] - p1[0]) / dy;
        this.alsxI = p1[0] + this.adlsxI * frac;
        this.adlsxI <<= 7;
        this.adlszI = (p2[2] - p1[2]) / dy;
        this.alszI = p1[2] + this.adlszI * frac;
        this.adlszI <<= 7;
        if (this.interpolateColor) {
            this.adlrI = (p2[4] - p1[4]) / dy;
            this.alrI = p1[4] + this.adlrI * frac;
            this.adlrI <<= 7;
            this.adlgI = (p2[5] - p1[5]) / dy;
            this.algI = p1[5] + this.adlgI * frac;
            this.adlgI <<= 7;
            this.adlbI = (p2[6] - p1[6]) / dy;
            this.albI = p1[6] + this.adlbI * frac;
            this.adlbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adluI = (p2[8] - p1[8]) / dy;
            this.aluI = p1[8] + this.adluI * frac;
            this.adluI <<= 7;
            this.adlvI = (p2[9] - p1[9]) / dy;
            this.alvI = p1[9] + this.adlvI * frac;
            this.adlvI <<= 7;
        }
        if (this.interpolateAlpha) {
            this.adlaI = (p2[7] - p1[7]) / dy;
            this.alaI = p1[7] + this.adlaI * frac;
            this.adlaI <<= 7;
        }
    }

    private final void incrementalizeYrdrI(int[] p1, int[] p2, int y) {
        int dy = p2[1] - p1[1] >> 7;
        if (dy < 128) {
            dy = 128;
        }
        int frac = (y << 14) + 8192 - p1[1] >> 7;
        this.adrsxI = (p2[0] - p1[0]) / dy;
        this.arsxI = p1[0] + this.adrsxI * frac;
        this.adrsxI <<= 7;
        this.adrszI = (p2[2] - p1[2]) / dy;
        this.arszI = p1[2] + this.adrszI * frac;
        this.adrszI <<= 7;
        if (this.interpolateColor) {
            this.adrrI = (p2[4] - p1[4]) / dy;
            this.arrI = p1[4] + this.adrrI * frac;
            this.adrrI <<= 7;
            this.adrgI = (p2[5] - p1[5]) / dy;
            this.argI = p1[5] + this.adrgI * frac;
            this.adrgI <<= 7;
            this.adrbI = (p2[6] - p1[6]) / dy;
            this.arbI = p1[6] + this.adrbI * frac;
            this.adrbI <<= 7;
        }
        if (this.interpolateTexture) {
            this.adruI = (p2[8] - p1[8]) / dy;
            this.aruI = p1[8] + this.adruI * frac;
            this.adruI <<= 7;
            this.adrvI = (p2[9] - p1[9]) / dy;
            this.arvI = p1[9] + this.adrvI * frac;
            this.adrvI <<= 7;
        }
        if (this.interpolateAlpha) {
            this.adraI = (p2[7] - p1[7]) / dy;
            this.araI = p1[7] + this.adraI * frac;
            this.adraI <<= 7;
        }
    }

    private final void line(int x1, int y1, int z1, int x2, int y2, int z2, int xmin, int xmax, int ymin, int ymax) {
        int dirX = x2 - x1;
        int dirY = y2 - y1;
        int dirZ = z2 - z1;
        double l = (double)dirX * (double)dirX + (double)dirY * (double)dirY;
        int il = 1 * ((int)(l = Math.sqrt(l)) >> 14);
        if (il == 0) {
            return;
        }
        int zz1 = z1 - (dirZ /= il) + -107374;
        int zz2 = z2 + dirZ + -107374;
        this.interpolateColor = false;
        this.interpolateTexture = false;
        this.scanPolyI(new int[][]{{x1 - dirX - (dirY /= il), y1 - dirY + (dirX /= il), zz1, 0, 0, 0, 0, 0, 1}, {x1 - dirX + dirY, y1 - dirY - dirX, zz1, 0, 0, 0, 0, 0, 1}, {x2 + dirX + dirY, y2 + dirY - dirX, zz2, 0, 0, 0, 0, 0, 1}, {x2 + dirX - dirY, y2 + dirY + dirX, zz2, 0, 0, 0, 0, 0, 1}}, 4, xmin, xmax - 1, ymin, ymax - 1);
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = (int)width * 16384 / 2;
        this.hh = (int)height * 16384 / 2;
        this.mh = Math.min(this.wh, this.hh);
        this.maxDim = Math.min(width, height) / Math.max(width, height);
    }
}

