/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.soft.Polygon;
import de.jreality.soft.PolygonPipeline;
import de.jreality.soft.VecMat;
import java.util.Arrays;

public class Intersector {
    private static final boolean DEBUG = false;
    private static final int CLIPPED_OUT = -1;
    private static final int CLIPPED_PARTIAL = 0;
    private static final int CLIPPED_IN = 1;
    private static int once = 0;
    private static final double EPS = 1.0E-4;

    public static void intersectPolygons(PolygonPipeline pipeline) {
        Polygon[] polygons = pipeline.polygons;
        for (int i = 0; i < pipeline.polygonCount; ++i) {
            Arrays.sort(pipeline.polygons, i, pipeline.polygonCount, pipeline.comp);
            Polygon p = polygons[i];
            double minZ = p.getMinZ(pipeline.vertexData);
            int pc = pipeline.polygonCount;
            for (int j = i + 1; j < pc && polygons[j].getCenterZ() > minZ; ++j) {
                Intersector.intersect(p, polygons[j], pipeline);
                polygons = pipeline.polygons;
                minZ = p.getMinZ(pipeline.vertexData);
            }
        }
    }

    public static boolean intersect(Polygon p1, Polygon p2, PolygonPipeline pipeline) {
        double[] n2;
        double[] vd = pipeline.vertexData;
        Intersector.dehomogenize(p1, vd);
        Intersector.dehomogenize(p2, vd);
        double xmin = -1.7976931348623157E308;
        double xmax = Double.MIN_VALUE;
        double ymin = -1.7976931348623157E308;
        double ymax = Double.MIN_VALUE;
        double zmin = -1.7976931348623157E308;
        double zmax = Double.MIN_VALUE;
        for (int i = 0; i < p1.length; ++i) {
            int v = p1.vertices[i];
            if (vd[v + 0] < xmin) {
                xmin = vd[v + 0];
            }
            if (vd[v + 0] > xmax) {
                xmax = vd[v + 0];
            }
            if (vd[v + 1] < ymin) {
                ymin = vd[v + 1];
            }
            if (vd[v + 1] > ymax) {
                ymax = vd[v + 1];
            }
            if (vd[v + 2] < zmin) {
                zmin = vd[v + 2];
            }
            if (!(vd[v + 2] > zmax)) continue;
            zmax = vd[v + 2];
        }
        double xmin2 = -1.7976931348623157E308;
        double xmax2 = Double.MIN_VALUE;
        double ymin2 = -1.7976931348623157E308;
        double ymax2 = Double.MIN_VALUE;
        double zmin2 = -1.7976931348623157E308;
        double zmax2 = Double.MIN_VALUE;
        for (int i = 0; i < p2.length; ++i) {
            int v = p2.vertices[i];
            if (vd[v + 0] < xmin2) {
                xmin2 = vd[v + 0];
            }
            if (vd[v + 0] > xmax2) {
                xmax2 = vd[v + 0];
            }
            if (vd[v + 1] < ymin2) {
                ymin2 = vd[v + 1];
            }
            if (vd[v + 1] > ymax2) {
                ymax2 = vd[v + 1];
            }
            if (vd[v + 2] < zmin2) {
                zmin2 = vd[v + 2];
            }
            if (!(vd[v + 2] > zmax2)) continue;
            zmax2 = vd[v + 2];
        }
        if (xmin > xmax2) {
            return false;
        }
        if (xmin2 > xmax) {
            return false;
        }
        if (ymin > ymax2) {
            return false;
        }
        if (ymin2 > ymax) {
            return false;
        }
        if (zmin > zmax2) {
            return false;
        }
        if (zmin2 > zmax) {
            return false;
        }
        double[] n1 = p1.getVertexNormal(0, vd);
        if (n1[2] < 0.0) {
            n1[0] = n1[0] * -1.0;
            n1[1] = n1[1] * -1.0;
            n1[2] = n1[2] * -1.0;
        }
        if ((n2 = p2.getVertexNormal(0, vd))[2] < 0.0) {
            n2[0] = n2[0] * -1.0;
            n2[1] = n2[1] * -1.0;
            n2[2] = n2[2] * -1.0;
        }
        double[] dir = new double[3];
        Rn.crossProduct(dir, n1, n2);
        double l = Rn.euclideanNorm(dir);
        if (l == 0.0) {
            return false;
        }
        dir[0] = dir[0] / l;
        dir[1] = dir[1] / l;
        dir[2] = dir[2] / l;
        double[] pt = p2.getVertex(0, pipeline.vertexData);
        double k2 = Rn.innerProduct(pt, n2);
        pt = p1.getVertex(0, pipeline.vertexData);
        double k1 = Rn.innerProduct(pt, n1);
        if (Intersector.testClipToHalfspace(p2, n1, -1, k1, pipeline) != 0) {
            return false;
        }
        int second = pipeline.copyPolygon(p1);
        int res = Intersector.clipToHalfspace(p1, n2, -1, k2, pipeline);
        if (once < 2 && res == 0) {
            p1.computeMaxZ(pipeline.vertexData);
            p1 = pipeline.polygons[second];
            res = Intersector.clipToHalfspace(p1, n2, 1, k2, pipeline);
            p1.computeMaxZ(pipeline.vertexData);
        } else {
            pipeline.freePolygon(second);
        }
        return true;
    }

    public static void dehomogenize(Polygon p, double[] vd) {
        for (int i = 0; i < p.length; ++i) {
            int v = p.vertices[i];
            double w = 1.0 / vd[v + 3];
            int n = v + 0;
            vd[n] = vd[n] * w;
            int n2 = v + 1;
            vd[n2] = vd[n2] * w;
            int n3 = v + 2;
            vd[n3] = vd[n3] * w;
            vd[v + 3] = 1.0;
        }
    }

    private static int testClipToHalfspace(Polygon p, double[] planeNormal, int sign, double k, PolygonPipeline pipeline) {
        if (p.length == 0) {
            return -1;
        }
        int hin = 0;
        int hout = 0;
        for (int i = 0; i < p.length; ++i) {
            int v = p.vertices[i];
            double test = (double)sign * (VecMat.dot(pipeline.vertexData, v + 0, planeNormal, 0) - k * pipeline.vertexData[v + 3]);
            if (test < -1.0E-4) {
                ++hin;
                continue;
            }
            if (!(test > 1.0E-4)) continue;
            ++hout;
        }
        if (hin == 0) {
            return -1;
        }
        if (hout == 0) {
            return 1;
        }
        return 0;
    }

    public static int clipToHalfspace(Polygon p, double[] planeNormal, int sign, double k, PolygonPipeline pipeline) {
        int testResult = Intersector.testClipToHalfspace(p, planeNormal, sign, k, pipeline);
        if (testResult != 0) {
            return testResult;
        }
        int u = p.vertices[p.length - 1];
        int v = p.vertices[0];
        double tu = (double)sign * (VecMat.dot(pipeline.vertexData, u + 0, planeNormal, 0) - k * pipeline.vertexData[u + 3]);
        double tv = 0.0;
        int newPolygonPos = pipeline.getFreePolygon();
        Polygon newP = pipeline.polygons[newPolygonPos];
        newP.length = 0;
        int i = 0;
        while (i < p.length) {
            if (tu <= 0.0 ^ (tv = (double)sign * (VecMat.dot(pipeline.vertexData, v + 0, planeNormal, 0) - k * pipeline.vertexData[v + 3])) <= 0.0) {
                double t = tu / (tu - tv);
                int pos = pipeline.getFreeVertex();
                for (int j = 0; j < 13; ++j) {
                    pipeline.vertexData[pos + j] = pipeline.vertexData[u + j] + t * (pipeline.vertexData[v + j] - pipeline.vertexData[u + j]);
                }
                newP.vertices[newP.length++] = pos;
            }
            if (tv <= 0.0) {
                newP.vertices[newP.length++] = v;
            }
            u = v;
            tu = tv;
            v = p.vertices[++i];
        }
        int[] vp = p.vertices;
        p.vertices = newP.vertices;
        p.length = newP.length;
        newP.vertices = vp;
        pipeline.freePolygon(newPolygonPos);
        return 0;
    }
}

