/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.ModularIntegerPolygonRasterizer;
import java.util.Arrays;

public final class IntRasterizer
extends ModularIntegerPolygonRasterizer {
    private static final int OPAQUE = -16777216;
    private static final int ROUND_DOWN = 4177920;
    private static final boolean OPTIMIZED = true;
    protected int[] zBuffer;
    private int w;
    private int h;
    private int[] pixels;
    private int background;

    public IntRasterizer(int[] pixelBuf) {
        this.pixels = pixelBuf;
        System.out.println(">INT RASTERIZER<");
    }

    protected final void setPixel(int x, int y) {
        int pos = x + this.w * y;
        if (this.apszI >= this.zBuffer[pos]) {
            return;
        }
        if (this.transparency == 0) {
            int r = (this.aprI & 0x3FC000) << 2;
            int g = (this.apgI & 0x3FC000) >> 6;
            int b = this.apbI >> 14;
            this.pixels[pos] = 0xFF000000 | r | g | b;
        } else {
            int sample = this.pixels[pos];
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            int r = ((this.aprI >> 14) + this.transparency * sr) * 257 & 0xFF0000;
            int g = ((this.apgI >> 14) + this.transparency * sg) * 257 >> 8 & 0xFF00;
            int b = ((this.apbI >> 14) + this.transparency * sb) * 257 >> 16;
            this.pixels[pos] = 0xFF000000 | r | g | b;
        }
        this.zBuffer[pos] = this.apszI;
    }

    protected final void setPixel(int x, int y, int z, int red, int green, int blue, int transparency) {
        int pos = x + this.w * y;
        if (z >= this.zBuffer[pos]) {
            return;
        }
        if (transparency == 0) {
            red <<= 16;
            green <<= 8;
        } else {
            int sample = this.pixels[pos];
            int sb = sample & 0xFF;
            int sg = sample >> 8 & 0xFF;
            int sr = sample >> 16 & 0xFF;
            red = (red + transparency * sr) * 257 & 0xFF0000;
            green = (green + transparency * sg) * 257 >> 8 & 0xFF00;
            blue = (blue + transparency * sb) * 257 >> 16;
        }
        this.pixels[pos] = 0xFF000000 | red | green | blue;
        this.zBuffer[pos] = z;
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public void clear() {
        Arrays.fill(this.zBuffer, Integer.MAX_VALUE);
        Arrays.fill(this.pixels, this.background);
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        super.setWindow(xmin, xmax, ymin, ymax);
        int nw = xmax - xmin;
        int nh = ymax - ymin;
        if (nw != this.w || nh != this.h) {
            this.w = nw;
            this.h = nh;
            int numPx = this.w * this.h;
            this.zBuffer = new int[numPx];
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

