/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.PolygonProcessor;

public class Geometries {
    private static final int SPHERE_DETAIL = 20;
    private static IndexedFaceSet sphere;
    private static final int Cylinder_DETAIL = 20;
    private static IndexedFaceSet cylinder;

    public static IndexedFaceSet unitSphere() {
        if (sphere == null) {
            int j;
            int i;
            sphere = new IndexedFaceSet();
            int d = 21;
            double r = 1.0;
            Geometries.sphere.vertices = new double[d * d * 3];
            Geometries.sphere.normals = new double[d * d * 3];
            Geometries.sphere.faces = new int[(d - 1) * (d - 1)][4];
            Geometries.sphere.normalIndices = Geometries.sphere.faces;
            for (i = 0; i < d; ++i) {
                for (j = 0; j < d; ++j) {
                    double phi = (double)i * Math.PI * 2.0 / ((double)d - 1.0);
                    double theta = (double)j * Math.PI / ((double)d - 1.0) - 1.5707963267948966;
                    int pos = 3 * (i + d * j);
                    Geometries.sphere.normals[pos] = Math.cos(phi) * Math.cos(theta);
                    Geometries.sphere.vertices[pos] = r * Geometries.sphere.normals[pos];
                    double d2 = Math.sin(phi) * Math.cos(theta);
                    Geometries.sphere.normals[pos + 1] = d2;
                    Geometries.sphere.vertices[pos + 1] = r * d2;
                    double d3 = Math.sin(theta);
                    Geometries.sphere.normals[pos + 2] = d3;
                    Geometries.sphere.vertices[pos + 2] = r * d3;
                }
            }
            for (i = 0; i < d - 1; ++i) {
                for (j = 0; j < d - 1; ++j) {
                    int pos = i + (d - 1) * j;
                    Geometries.sphere.faces[pos][0] = 3 * (i + j * d);
                    Geometries.sphere.faces[pos][1] = 3 * (i + 1 + j * d);
                    Geometries.sphere.faces[pos][2] = 3 * (i + 1 + (j + 1) * d);
                    Geometries.sphere.faces[pos][3] = 3 * (i + (j + 1) * d);
                }
            }
        }
        return sphere;
    }

    public static IndexedFaceSet cylinder() {
        int k = 20;
        double r = 1.0;
        double h = 2.0;
        if (cylinder == null) {
            int pos;
            double sinT;
            double cosT;
            double theta;
            int ppos;
            int i;
            int i2;
            cylinder = new IndexedFaceSet();
            Geometries.cylinder.faces = new int[3 * k][];
            for (i2 = 0; i2 < k; ++i2) {
                Geometries.cylinder.faces[i2] = new int[4];
            }
            for (i2 = k; i2 < 3 * k; ++i2) {
                Geometries.cylinder.faces[i2] = new int[3];
            }
            Geometries.cylinder.vertices = new double[3 * (2 + 4 * k)];
            Geometries.cylinder.normals = new double[3 * (2 + 4 * k)];
            double al = 1.5707963267948966 - Math.asin(r / Math.sqrt(r * r + h * h));
            double cosA = Math.cos(al);
            for (i = 0; i < k; ++i) {
                Geometries.cylinder.faces[i][0] = ppos = 6 * i;
                Geometries.cylinder.faces[i][1] = ppos + 3;
                Geometries.cylinder.faces[i][2] = (ppos + 9) % (6 * k);
                Geometries.cylinder.faces[i][3] = (ppos + 6) % (6 * k);
                theta = Math.PI * 2 * (double)i / (double)k;
                cosT = Math.cos(theta);
                sinT = Math.sin(theta);
                pos = 6 * i;
                Geometries.cylinder.vertices[pos + 0] = r * cosT;
                Geometries.cylinder.vertices[pos + 1] = r * sinT;
                Geometries.cylinder.vertices[pos + 2] = h / 2.0;
                Geometries.cylinder.vertices[pos + 3] = r * cosT;
                Geometries.cylinder.vertices[pos + 4] = r * sinT;
                Geometries.cylinder.vertices[pos + 5] = -h / 2.0;
                Geometries.cylinder.normals[pos + 0] = cosT;
                Geometries.cylinder.normals[pos + 1] = sinT;
                Geometries.cylinder.normals[pos + 2] = 0.0;
                Geometries.cylinder.normals[pos + 3] = cosT;
                Geometries.cylinder.normals[pos + 4] = sinT;
                Geometries.cylinder.normals[pos + 5] = 0.0;
            }
            for (i = 0; i < k; ++i) {
                ppos = 2 * k + i;
                Geometries.cylinder.faces[i + k][0] = 3 * (2 * k + i);
                Geometries.cylinder.faces[i + k][1] = 3 * (2 * k + (i + 1) % k);
                Geometries.cylinder.faces[i + k][2] = 3 * (4 * k);
                Geometries.cylinder.faces[i + 2 * k][0] = 3 * (3 * k + i);
                Geometries.cylinder.faces[i + 2 * k][1] = 3 * (3 * k + (i + 1) % k);
                Geometries.cylinder.faces[i + 2 * k][2] = 3 * (4 * k + 1);
                theta = Math.PI * 2 * (double)i / (double)k;
                cosT = Math.cos(theta);
                sinT = Math.sin(theta);
                pos = 3 * (2 * k + i);
                Geometries.cylinder.vertices[pos + 0] = r * cosT;
                Geometries.cylinder.vertices[pos + 1] = r * sinT;
                Geometries.cylinder.vertices[pos + 2] = h / 2.0;
                Geometries.cylinder.normals[pos + 0] = 0.0;
                Geometries.cylinder.normals[pos + 1] = 0.0;
                Geometries.cylinder.normals[pos + 2] = 1.0;
                Geometries.cylinder.vertices[(pos += 3 * k) + 0] = r * cosT;
                Geometries.cylinder.vertices[pos + 1] = r * sinT;
                Geometries.cylinder.vertices[pos + 2] = -h / 2.0;
                Geometries.cylinder.normals[pos + 0] = 0.0;
                Geometries.cylinder.normals[pos + 1] = 0.0;
                Geometries.cylinder.normals[pos + 2] = -1.0;
            }
            Geometries.cylinder.vertices[3 * (4 * k)] = 0.0;
            Geometries.cylinder.vertices[3 * (4 * k) + 1] = 0.0;
            Geometries.cylinder.vertices[3 * (4 * k) + 2] = h / 2.0;
            Geometries.cylinder.vertices[3 * (4 * k + 1)] = 0.0;
            Geometries.cylinder.vertices[3 * (4 * k + 1) + 1] = 0.0;
            Geometries.cylinder.vertices[3 * (4 * k + 1) + 2] = -h / 2.0;
            Geometries.cylinder.normals[3 * (4 * k)] = 0.0;
            Geometries.cylinder.normals[3 * (4 * k) + 1] = 0.0;
            Geometries.cylinder.normals[3 * (4 * k) + 2] = 1.0;
            Geometries.cylinder.normals[3 * (4 * k + 1)] = 0.0;
            Geometries.cylinder.normals[3 * (4 * k + 1) + 1] = 0.0;
            Geometries.cylinder.normals[3 * (4 * k + 1) + 2] = -1.0;
            Geometries.cylinder.normalIndices = Geometries.cylinder.faces;
        }
        return cylinder;
    }

    public static class IndexedFaceSet {
        public double[] vertices;
        public double[] normals;
        public int[][] faces;
        public int[][] normalIndices;

        public void apply(PolygonProcessor p) {
            for (int i = 0; i < this.faces.length; ++i) {
                p.processPolygon(this.vertices, this.faces[i], this.normals, this.normalIndices[i]);
            }
        }
    }
}

