/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.PointShader;
import de.jreality.soft.PolygonShader;
import de.jreality.soft.ShaderLookup;

public class DefaultPointShader
implements PointShader {
    private PolygonShader coreShader = null;
    private PolygonShader outlineShader = null;
    private double pointRadius = 0.025;
    private double outlineFraction = 0.3333333333333333;

    public DefaultPointShader() {
    }

    public DefaultPointShader(PolygonShader coreShader, PolygonShader outlineShader) {
        this.coreShader = coreShader;
        this.outlineShader = outlineShader;
    }

    public PolygonShader getCoreShader() {
        return this.coreShader;
    }

    public PolygonShader getOutlineShader() {
        return this.outlineShader;
    }

    public double getPointRadius() {
        return this.pointRadius;
    }

    public double getOutlineFraction() {
        return this.outlineFraction;
    }

    public void setup(EffectiveAppearance eAppearance, String shaderName) {
        this.pointRadius = eAppearance.getAttribute(ShaderUtility.nameSpace(shaderName, "pointRadius"), this.pointRadius);
        this.outlineFraction = eAppearance.getAttribute(ShaderUtility.nameSpace(shaderName, "outlineFraction"), this.outlineFraction);
        this.coreShader = ShaderLookup.getPolygonShaderAttr(eAppearance, shaderName, "coreShader");
        this.outlineShader = ShaderLookup.getPolygonShaderAttr(eAppearance, shaderName, "outlineShader");
    }

    public void startGeometry(Geometry geom) {
        if (this.coreShader != null) {
            this.coreShader.startGeometry(geom);
        }
        if (this.outlineShader != null) {
            this.outlineShader.startGeometry(geom);
        }
    }
}

