/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.soft.ClippingBox;
import de.jreality.soft.Perspective;

public class DefaultPerspective
implements Perspective {
    private double fieldOfView = 1.0471975511965976;
    private double focalLength = 1.0 / Math.tan(0.1308996938995747);
    private int width = 640;
    private int height = 480;
    private double wh = (double)this.width / 2.0;
    private double hh = (double)this.height / 2.0;
    private double mh = Math.min(this.wh, this.hh);
    private double nearclip = 3.0;
    private double farclip = 50.0;
    ClippingBox frustum = new ClippingBox();

    public DefaultPerspective() {
        this.frustum.z0 = -1.0;
        this.frustum.z1 = 1.0;
    }

    public final void perspective(double[] v, int pos) {
        double vz = -v[2 + pos];
        int n = pos + 0;
        v[n] = v[n] * this.focalLength;
        int n2 = pos + 1;
        v[n2] = v[n2] * this.focalLength;
        v[pos + 2] = ((this.nearclip + this.farclip) * vz - 2.0 * this.nearclip * this.farclip) / (this.farclip - this.nearclip);
        int n3 = pos + 3;
        v[n3] = v[n3] * vz;
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public void setFieldOfViewDeg(double fieldOfView) {
        this.fieldOfView = fieldOfView / 180.0 * Math.PI;
        this.focalLength = 1.0 / Math.tan(this.fieldOfView / 2.0);
    }

    public void setFocalLength(double focalLength) {
        this.focalLength = focalLength;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.hh = (double)height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
        this.frustum.y1 = Math.max(1.0, this.hh / this.mh);
        this.frustum.y0 = -this.frustum.y1;
        this.frustum.x1 = Math.max(1.0, this.wh / this.mh);
        this.frustum.x0 = -this.frustum.x1;
    }

    public void setWidth(int width) {
        this.width = width;
        this.wh = (double)width / 2.0;
        this.mh = Math.min(this.wh, this.hh);
        this.frustum.y1 = Math.max(1.0, this.hh / this.mh);
        this.frustum.y0 = -this.frustum.y1;
        this.frustum.x1 = Math.max(1.0, this.wh / this.mh);
        this.frustum.x0 = -this.frustum.x1;
    }

    public ClippingBox getFrustum() {
        return this.frustum;
    }

    public void setNear(double d) {
        this.nearclip = d;
    }

    public void setFar(double d) {
        this.farclip = d;
    }
}

