/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.scene.Geometry;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.soft.Environment;
import de.jreality.soft.VertexShader;
import java.awt.Color;

public class ConstantVertexShader
implements VertexShader {
    private double red;
    private double green;
    private double blue;
    private double transparency = 0.0;

    public ConstantVertexShader() {
    }

    public ConstantVertexShader(double r, double g, double b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public ConstantVertexShader(double[] color, double transparency) {
        this.red = color[0];
        this.green = color[1];
        this.blue = color[2];
        this.transparency = transparency;
    }

    public void shadeVertex(double[] vertex, int pos, Environment environment) {
        vertex[pos + 4] = this.red;
        vertex[pos + 5] = this.green;
        vertex[pos + 6] = this.blue;
    }

    public boolean interpolateAlpha() {
        return false;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getGreen() {
        return this.green;
    }

    public double getRed() {
        return this.red;
    }

    public void setBlue(double blue) {
        this.blue = blue;
    }

    public void setGreen(double green) {
        this.green = green;
    }

    public void setRed(double red) {
        this.red = red;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public void setup(EffectiveAppearance eAppearance, String name) {
        this.transparency = eAppearance.getAttribute(ShaderUtility.nameSpace(name, "transparency"), this.transparency);
        Color c = (Color)eAppearance.getAttribute(ShaderUtility.nameSpace(name, "color"), Color.BLACK);
        c = (Color)eAppearance.getAttribute(ShaderUtility.nameSpace(name, "diffuseColor"), c);
        float[] rgb = c.getComponents(null);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    public void startGeometry(Geometry geom) {
    }
}

