/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.soft;

import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.soft.DefaultPerspective;
import de.jreality.soft.PolygonPipeline;
import de.jreality.soft.PolygonRasterizer;
import de.jreality.soft.RenderTraversal;
import de.jreality.util.DefaultMatrixSupport;
import java.awt.Color;
import java.awt.Dimension;

public abstract class AbstractViewer
implements Viewer {
    protected Camera camera;
    protected int argbBackground;
    protected SceneGraphComponent root;
    private SceneGraphPath cameraPath;
    private Transformation cameraWorld = new Transformation();
    private PolygonPipeline pipeline;
    protected PolygonRasterizer rasterizer;
    private RenderTraversal renderTraversal;
    int width;
    int height;

    public void setBackgroundColor(int c) {
        this.argbBackground = c;
        this.rasterizer.setBackground(c);
    }

    void render(int width, int height) {
        Object o;
        this.pipeline = new PolygonPipeline(this.rasterizer, true);
        this.renderTraversal = new RenderTraversal();
        this.renderTraversal.setPipeline(this.pipeline);
        if (this.root == null || this.camera == null) {
            throw new IllegalStateException("need camera and root node");
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.rasterizer.setWindow(0, width, 0, height);
        this.rasterizer.setSize(width, height);
        this.rasterizer.start();
        this.pipeline.getPerspective().setWidth(width);
        this.pipeline.getPerspective().setHeight(height);
        Appearance a = this.root.getAppearance();
        Color background = a != null ? ((o = a.getAttribute("backgroundColor")) instanceof Color ? (Color)o : Color.WHITE) : Color.WHITE;
        this.rasterizer.setBackground(background.getRGB());
        this.rasterizer.clear();
        DefaultPerspective p = (DefaultPerspective)this.pipeline.getPerspective();
        p.setFieldOfViewDeg(this.camera.getFieldOfView());
        p.setNear(this.camera.getNear());
        p.setFar(this.camera.getFar());
        DefaultMatrixSupport.getSharedInstance().restoreDefault(this.cameraWorld, true);
        this.cameraWorld.multiplyOnLeft(this.cameraPath.getMatrix(null));
        this.pipeline.clearPipeline();
        double[] im = new double[16];
        Rn.inverse(im, this.cameraWorld.getMatrix());
        this.cameraWorld.setMatrix(im);
        this.renderTraversal.setInitialTransformation(this.cameraWorld);
        this.renderTraversal.traverse(this.root);
        this.pipeline.sortPolygons();
        this.pipeline.renderRemaining(this.rasterizer);
        this.rasterizer.stop();
    }

    public SceneGraphComponent getSceneRoot() {
        return this.root;
    }

    public void setSceneRoot(SceneGraphComponent component) {
        this.root = component;
    }

    public Object getViewingComponent() {
        return null;
    }

    public Dimension getViewingComponentSize() {
        return null;
    }

    public void render() {
        this.render(this.width, this.height);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
        this.camera = (Camera)p.getLastElement();
    }

    public boolean hasViewingComponent() {
        return false;
    }

    public void initializeFrom(Viewer v) {
        this.setSceneRoot(v.getSceneRoot());
        this.setCameraPath(v.getCameraPath());
    }

    public boolean canRenderAsync() {
        return false;
    }

    public void renderAsync() {
        throw new UnsupportedOperationException();
    }
}

