/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.scene.Appearance;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.LineShader;
import de.jreality.shader.PointShader;
import de.jreality.shader.PolygonShader;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.shader.RootAppearance;
import de.jreality.shader.TextShader;
import de.jreality.shader.TwoSidePolygonShader;
import java.awt.Color;

public class ShaderUtility {
    private ShaderUtility() {
    }

    public static Color combineDiffuseColorWithTransparency(Color diffuseColor, double transparency, boolean useOldTransparency) {
        double alpha = 1.0 - transparency;
        if (useOldTransparency) {
            double alpha2 = (float)diffuseColor.getAlpha() / 255.0f;
            if ((alpha *= alpha2) < 0.0) {
                alpha = 0.0;
            }
            if (alpha > 1.0) {
                alpha = 1.0;
            }
        }
        float[] f = diffuseColor.getRGBComponents(null);
        Color ret = new Color(f[0], f[1], f[2], (float)alpha);
        return ret;
    }

    public static String nameSpace(String s1, String s2) {
        return s1.length() == 0 ? s2 : s1 + '.' + s2;
    }

    public static DefaultGeometryShader createDefaultGeometryShader(Appearance a, boolean readDefaults) {
        return (DefaultGeometryShader)AttributeEntityUtility.getAttributeEntity(DefaultGeometryShader.class, "", a, readDefaults);
    }

    public static DefaultGeometryShader createDefaultGeometryShader(EffectiveAppearance ea) {
        return (DefaultGeometryShader)AttributeEntityUtility.createAttributeEntity(DefaultGeometryShader.class, "", ea);
    }

    public static RenderingHintsShader createDefaultRenderingHintsShader(Appearance a, boolean readDefaults) {
        return (RenderingHintsShader)AttributeEntityUtility.getAttributeEntity(RenderingHintsShader.class, "", a, readDefaults);
    }

    public static RenderingHintsShader createRenderingHintsShader(EffectiveAppearance ea) {
        return (RenderingHintsShader)AttributeEntityUtility.createAttributeEntity(RenderingHintsShader.class, "", ea);
    }

    public static RootAppearance createRootAppearance(Appearance a) {
        return (RootAppearance)AttributeEntityUtility.createAttributeEntity(RootAppearance.class, "", a, true);
    }

    public static Class resolveEntity(Class type, String name) {
        if (PointShader.class.isAssignableFrom(type)) {
            if (name.equals("default")) {
                return DefaultPointShader.class;
            }
            throw new IllegalArgumentException(" no such point shader [" + name + "]");
        }
        if (LineShader.class.isAssignableFrom(type)) {
            if (name.equals("default")) {
                return DefaultLineShader.class;
            }
            throw new IllegalArgumentException(" no such line shader [" + name + "]");
        }
        if (PolygonShader.class.isAssignableFrom(type)) {
            if (name.equals("twoSide")) {
                return TwoSidePolygonShader.class;
            }
            if (name.equals("default")) {
                return DefaultPolygonShader.class;
            }
            if (name.equals("hatch")) {
                try {
                    return Class.forName("de.jreality.shader.HatchPolygonShader");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (name.equals("etch")) {
                try {
                    return Class.forName("de.jreality.shader.EtchPolygonShader");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                return Class.forName("de.jreality.shader." + name.substring(0, 1).toUpperCase() + name.substring(1) + "PolygonShader");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(" no such polygon shader [" + name + "]");
            }
        }
        if (TextShader.class.isAssignableFrom(type)) {
            if (name.equals("default")) {
                return DefaultTextShader.class;
            }
            throw new IllegalArgumentException(" no such text shader [" + name + "]");
        }
        throw new IllegalArgumentException("unhandled entity class " + type);
    }
}

