/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.math.Rn;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class ImageData
implements Serializable {
    private transient byte[] handOutArray;
    private transient Image img;
    private transient Image origImg;
    private byte[] byteArray;
    private byte[] origByteArray = null;
    private int[] intArray = null;
    private HashMap<Integer, Boolean> isClean = new HashMap();
    private float[] floatArray = null;
    private int width;
    private int height;
    public static final short RGBA_8BIT = 0;
    public static final short LUMINANCE_8BIT = 1;
    public static final short LUMINANCE_32BIT_FLOAT = 2;
    public static final short LUMINANCE_16BIT = 3;
    private short imageType;

    public static ImageData load(Input input) throws IOException {
        return new ImageData(ImageData.loadInput(input));
    }

    public static ImageData load(Input input, double[] channelMatrix) throws IOException {
        return new ImageData(ImageData.loadInput(input), channelMatrix);
    }

    private static Image loadInput(Input in) throws IOException {
        String urlString = in.toString().toLowerCase();
        if (urlString.endsWith(".jpeg") || urlString.endsWith(".jpg") || urlString.endsWith(".gif") || urlString.endsWith(".png")) {
            return Toolkit.getDefaultToolkit().getImage(in.toURL());
        }
        LoggingSystem.getLogger(ImageData.class).log(Level.INFO, "loading " + in + " trying ImageIO");
        BufferedImage img = ImageIO.read(in.getInputStream());
        if (img == null) {
            throw new IOException("read failed: " + in);
        }
        return img;
    }

    public ImageData(int[] data, int width, int height) {
        this.imageType = 0;
        this.width = width;
        this.height = height;
        this.intArray = data;
    }

    public ImageData(byte[] data, int width, int height) {
        this.imageType = 0;
        if (data.length != 4 * width * height) {
            throw new IllegalArgumentException("data doesn't match image dimensions");
        }
        this.byteArray = new byte[data.length];
        System.arraycopy(data, 0, this.byteArray, 0, data.length);
        this.width = width;
        this.height = height;
        this.isClean.clear();
    }

    public ImageData(float[] data, int width, int height) {
        this.imageType = (short)2;
        if (data.length != width * height) {
            throw new IllegalArgumentException("data doesn't match image dimensions");
        }
        this.floatArray = new float[data.length];
        System.arraycopy(data, 0, this.floatArray, 0, data.length);
        this.width = width;
        this.height = height;
        this.isClean.clear();
    }

    public ImageData(Image img) {
        this(img, null);
    }

    public ImageData(Image img, int width, int height) {
        this(img, width, height, null);
    }

    public ImageData(Image img, double[] channelMatrix) {
        this(img, img.getWidth(null), img.getHeight(null), channelMatrix);
    }

    public ImageData(Image img, int width, int height, double[] channelMatrix) {
        if (width == -1 || height == -1) {
            long st = System.currentTimeMillis();
            ImageData.wait(img);
            st = System.currentTimeMillis() - st;
            LoggingSystem.getLogger(this).log(Level.FINER, "waited {0} ms for image loading.", new Long(st));
            width = img.getWidth(null);
            height = img.getHeight(null);
        }
        this.imageType = 0;
        this.width = width;
        this.height = height;
        this.readBytes(img, channelMatrix);
    }

    static void wait(Image img) {
        MediaTracker t = new MediaTracker(new Component(){});
        t.addImage(img, 0);
        boolean gotIt = false;
        while (!gotIt) {
            try {
                t.waitForAll();
                gotIt = true;
            }
            catch (InterruptedException e) {
                throw new Error();
            }
        }
    }

    private Image createImage() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        WritableRaster raster = bi.getRaster();
        int[] pix = new int[4];
        int ptr = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                pix[0] = this.byteArray[ptr + 3];
                pix[1] = this.byteArray[ptr];
                pix[2] = this.byteArray[ptr + 1];
                pix[3] = this.byteArray[ptr + 2];
                raster.setPixel(x, y, pix);
                ++x;
                ptr += 4;
            }
        }
        return bi;
    }

    private Image createOrigImage() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        WritableRaster raster = bi.getRaster();
        int[] pix = new int[4];
        int ptr = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                pix[3] = this.byteArray[ptr + 3];
                pix[0] = this.byteArray[ptr];
                pix[1] = this.byteArray[ptr + 1];
                pix[2] = this.byteArray[ptr + 2];
                raster.setPixel(x, y, pix);
                ++x;
                ptr += 4;
            }
        }
        return bi;
    }

    private void readBytes(Image theImage, double[] channelArithmeticMatrix) {
        if (this.byteArray == null) {
            int j;
            int[] pixelsI = new int[this.width * this.height];
            PixelGrabber p = new PixelGrabber(theImage, 0, 0, this.width, this.height, pixelsI, 0, this.width);
            try {
                p.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int num = pixelsI.length << 2;
            this.byteArray = new byte[num];
            int i = 0;
            for (j = 0; j < num; j += 4) {
                int px = pixelsI[i];
                this.byteArray[j + 3] = (byte)(px >>> 24);
                this.byteArray[j] = (byte)(px >>> 16);
                this.byteArray[j + 1] = (byte)(px >>> 8);
                this.byteArray[j + 2] = (byte)px;
                ++i;
            }
            if (channelArithmeticMatrix != null) {
                double[] pixel = new double[4];
                for (j = 0; j < num; j += 4) {
                    int i2;
                    for (i2 = 0; i2 < 4; ++i2) {
                        pixel[i2] = this.byteArray[j + i2];
                    }
                    Rn.matrixTimesVector(pixel, channelArithmeticMatrix, pixel);
                    for (i2 = 0; i2 < 4; ++i2) {
                        this.byteArray[j + i2] = (byte)pixel[i2];
                    }
                }
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public short getImageType() {
        return this.imageType;
    }

    public Image getImage() {
        return this.img == null ? (this.img = this.createImage()) : this.img;
    }

    public byte[] getByteArray() {
        if (this.byteArray != null) {
            if (this.handOutArray == null) {
                this.handOutArray = (byte[])this.byteArray.clone();
            } else {
                System.arraycopy(this.byteArray, 0, this.handOutArray, 0, this.byteArray.length);
            }
            return this.handOutArray;
        }
        return null;
    }

    public float[] getFloatArray() {
        return this.floatArray;
    }

    public int[] getIntArray() {
        return this.intArray;
    }

    public Image getOriginalImage() {
        return this.origImg == null ? (this.origImg = this.createOrigImage()) : this.origImg;
    }

    public void updateData(float[] newData) {
        System.arraycopy(newData, 0, this.floatArray, 0, newData.length);
        this.isClean.clear();
    }

    public void updateData(byte[] newData) {
        System.arraycopy(newData, 0, this.byteArray, 0, newData.length);
        this.isClean.clear();
    }

    public synchronized boolean isDirty(int hashCode) {
        return this.isClean.get(hashCode) == null;
    }

    public synchronized void setClean(int hashCode) {
        this.isClean.put(hashCode, true);
    }

    public byte[] getByteArray(double[] channelArithmeticMatrix) {
        int numBytes = this.byteArray.length;
        byte[] ret = new byte[numBytes];
        if (channelArithmeticMatrix != null) {
            double[] pixel = new double[4];
            for (int j = 0; j < numBytes; j += 4) {
                int i;
                for (i = 0; i < 4; ++i) {
                    pixel[i] = this.byteArray[j + i];
                }
                Rn.matrixTimesVector(pixel, channelArithmeticMatrix, pixel);
                for (i = 0; i < 4; ++i) {
                    ret[j + i] = (byte)pixel[i];
                }
            }
        }
        return ret;
    }

    public void finalize() {
        this.floatArray = null;
    }

    public String toString() {
        return "ImageData: width=" + this.width + " height=" + this.height;
    }

    private final class ROImage
    extends Image {
        private final Image img;

        ROImage(Image img) {
            this.img = img;
        }

        public boolean equals(Object obj) {
            return this.img.equals(obj);
        }

        public void flush() {
            this.img.flush();
        }

        public Graphics getGraphics() {
            return this.img.getGraphics();
        }

        public int getHeight(ImageObserver observer) {
            return this.img.getHeight(observer);
        }

        public Object getProperty(String name, ImageObserver observer) {
            return this.img.getProperty(name, observer);
        }

        public Image getScaledInstance(int width, int height, int hints) {
            return this.img.getScaledInstance(width, height, hints);
        }

        public ImageProducer getSource() {
            return this.img.getSource();
        }

        public int getWidth(ImageObserver observer) {
            return this.img.getWidth(observer);
        }

        public int hashCode() {
            return this.img.hashCode();
        }

        public String toString() {
            return this.img.toString();
        }
    }
}

