/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.util.Input;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlslSource
implements Serializable {
    private String[] vertexProgs;
    private String[] fragmentProgs;
    private final transient HashMap<String, UniformParameter> uniforms = new HashMap();
    private final transient HashMap<String, AttributeParameter> attribs = new HashMap();
    private final transient Collection<UniformParameter> UNIFORMS = Collections.unmodifiableCollection(this.uniforms.values());
    private final transient Collection<AttributeParameter> ATTRIBUTES = Collections.unmodifiableCollection(this.attribs.values());
    private static final Pattern uniformPattern = Pattern.compile("^[\\w]*uniform[\\s]+([\\w]+)[\\s]+([\\w,\t ]+)[\\s]*\\[?[\\s]*([0-9]*)[\\s]*\\]?[\\s;]+", 8);
    private static final Pattern attribPattern = Pattern.compile("^[\\w]*attribute[\\s]+([\\w]+)[\\s]+([\\w,\t ]+)[\\s]*\\[?[\\s]*([0-9]*)[\\s]*\\]?[\\s;]+", 8);

    public GlslSource(Input vertexProgram, Input fragmentProgram) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        if (vertexProgram == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = GlslSource.readString(vertexProgram);
        }
        this.vertexProgs = stringArray2;
        if (fragmentProgram == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = GlslSource.readString(fragmentProgram);
        }
        this.fragmentProgs = stringArray;
        this.extractParams();
    }

    public GlslSource(String vertexProgram, String fragmentProgram) {
        String[] stringArray;
        String[] stringArray2;
        if (vertexProgram == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = new String(vertexProgram);
        }
        this.vertexProgs = stringArray2;
        if (fragmentProgram == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = new String(fragmentProgram);
        }
        this.fragmentProgs = stringArray;
        this.extractParams();
    }

    public GlslSource(String[] vertexProgram, String[] fragmentProgram) {
        this.vertexProgs = vertexProgram;
        this.fragmentProgs = fragmentProgram;
        this.extractParams();
    }

    private void extractParams() {
        int i;
        if (this.vertexProgs != null) {
            for (i = 0; i < this.vertexProgs.length; ++i) {
                this.extractUniforms(this.vertexProgs[i]);
                this.extractAttribs(this.vertexProgs[i]);
            }
        }
        if (this.fragmentProgs != null) {
            for (i = 0; i < this.fragmentProgs.length; ++i) {
                this.extractUniforms(this.fragmentProgs[i]);
                this.extractAttribs(this.fragmentProgs[i]);
            }
        }
    }

    private void extractUniforms(String prog) {
        Matcher m = uniformPattern.matcher(prog);
        while (m.find()) {
            String type = m.group(1);
            int arrayLen = -1;
            try {
                arrayLen = Integer.parseInt(m.group(3));
            }
            catch (Exception e) {
                // empty catch block
            }
            String nameStr = m.group(2);
            String[] names = nameStr.split(", ");
            for (int i = 0; i < names.length; ++i) {
                UniformParameter param = new UniformParameter(names[i], type, arrayLen);
                this.uniforms.put(names[i], param);
            }
        }
    }

    private void extractAttribs(String prog) {
        Matcher m = attribPattern.matcher(prog);
        while (m.find()) {
            String nameStr = m.group(2);
            String[] names = nameStr.split(", ");
            for (int i = 0; i < names.length; ++i) {
                AttributeParameter param = new AttributeParameter(names[i]);
                this.attribs.put(names[i], param);
                System.out.println("found attrib " + param);
            }
        }
    }

    public Collection<UniformParameter> getUniformParameters() {
        return this.UNIFORMS;
    }

    public Collection<AttributeParameter> getAttributes() {
        return this.ATTRIBUTES;
    }

    public AttributeParameter getAttribute(String name) {
        return this.attribs.get(name);
    }

    public UniformParameter getUniformParameter(String name) {
        return this.uniforms.get(name);
    }

    public String[] getVertexProgram() {
        return this.vertexProgs;
    }

    public String[] getFragmentProgram() {
        return this.fragmentProgs;
    }

    private static String readString(Input input) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[255];
        Reader r = input.getReader();
        int read = -1;
        while ((read = r.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return new GlslSource(this.vertexProgs, this.fragmentProgs);
    }

    public static void main(String[] args) throws Exception {
        GlslSource source = new GlslSource(Input.getInput("de/jreality/jogl/shader/resources/brick.vert"), Input.getInput("de/jreality/jogl/shader/resources/brick.frag"));
    }

    public class UniformParameter {
        private final String name;
        private final String type;
        private final boolean isArray;
        private final boolean isMatrix;
        private final Class primitiveType;
        private final int primitiveSize;
        private final int dataSize;
        private final int arrayLength;
        private final String stringRep;

        private UniformParameter(String name, String type, int arrayLen) {
            this.name = name;
            this.type = type;
            this.isArray = arrayLen > 0;
            this.isMatrix = type.startsWith("mat");
            this.arrayLength = arrayLen;
            int s = 1;
            try {
                s = Integer.parseInt(type.substring(type.length() - 1));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.primitiveSize = s;
            this.primitiveType = type.startsWith("i") || type.startsWith("sampler") || type.startsWith("bool") ? Integer.TYPE : Float.TYPE;
            int prDataSize = this.isMatrix ? this.primitiveSize * this.primitiveSize : this.primitiveSize;
            this.dataSize = this.isArray ? arrayLen * prDataSize : prDataSize;
            StringBuffer sb = new StringBuffer("glUniform");
            if (this.isMatrix()) {
                sb.append("Matrix");
            }
            sb.append(this.getPrimitiveSize());
            sb.append(this.getPrimitiveType() == Float.TYPE ? (char)'f' : 'i');
            System.out.println("name=" + name + " type=" + type + " primitiveType=" + this.getPrimitiveType());
            sb.append('v');
            this.stringRep = sb.toString();
        }

        public boolean isArray() {
            return this.isArray;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isMatrix() {
            return this.isMatrix;
        }

        public int getPrimitiveSize() {
            return this.primitiveSize;
        }

        public int getDataSize() {
            return this.dataSize;
        }

        public Class getPrimitiveType() {
            return this.primitiveType;
        }

        public int getArrayLength() {
            if (this.isArray) {
                return this.arrayLength;
            }
            throw new IllegalStateException("no array");
        }

        public String toString() {
            return "uniform: " + this.type + " " + this.name + " [" + (this.isArray ? "arrayLength=" + this.arrayLength : "") + " matrix=" + this.isMatrix + " primitive=" + this.primitiveType + " size=" + this.primitiveSize + "]";
        }

        public String getStringRep() {
            return this.stringRep;
        }
    }

    public class AttributeParameter {
        private final String name;

        private AttributeParameter(String name) {
            this.name = name;
        }

        public String toString() {
            return "attribute=" + this.name;
        }

        public String getName() {
            return this.name;
        }
    }
}

