/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.tool;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class InputSlot
implements Serializable {
    private static final Map<String, InputSlot> name2device = new HashMap<String, InputSlot>();
    public static final InputSlot POINTER_HIT = InputSlot.getDevice("PointerHit");
    public static final InputSlot POINTER_TRANSFORMATION = InputSlot.getDevice("PointerTransformation");
    public static final InputSlot SYSTEM_TIME = InputSlot.getDevice("SystemTime");
    public static final InputSlot LEFT_BUTTON = InputSlot.getDevice("PrimaryAction");
    public static final InputSlot MIDDLE_BUTTON = InputSlot.getDevice("PrimaryMenu");
    public static final InputSlot RIGHT_BUTTON = InputSlot.getDevice("PrimarySelection");
    public static final InputSlot SHIFT_LEFT_BUTTON = InputSlot.getDevice("SecondaryAction");
    public static final InputSlot SHIFT_MIDDLE_BUTTON = InputSlot.getDevice("SecondaryMenu");
    public static final InputSlot SHIFT_RIGHT_BUTTON = InputSlot.getDevice("SecondarySelection");
    private final int hash;
    private final String name;

    private InputSlot(String name) {
        this.name = name;
        this.hash = name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputSlot getDevice(String name) {
        Map<String, InputSlot> map = name2device;
        synchronized (map) {
            InputSlot old = name2device.get(name);
            if (old != null) {
                return old;
            }
            InputSlot dev = new InputSlot(name);
            name2device.put(name, dev);
            return dev;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() throws ObjectStreamException {
        return InputSlot.getDevice(this.getName());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputSlot other = (InputSlot)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

