/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.tool;

import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.Tool;
import de.jreality.scene.tool.ToolContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool
implements Tool {
    static int counter;
    private final int hash;
    protected transient List<InputSlot> activationSlots;
    private transient List<InputSlot> currentSlots = Collections.emptyList();
    private final transient HashMap<InputSlot, String> descriptions = new HashMap();
    private String description;

    public AbstractTool(InputSlot ... activationSlots) {
        this.hash = AbstractTool.hash();
        this.activationSlots = activationSlots == null || activationSlots.length == 0 || activationSlots[0] == null ? Collections.emptyList() : Arrays.asList(activationSlots);
    }

    @Override
    public List<InputSlot> getActivationSlots() {
        return this.activationSlots;
    }

    @Override
    public List<InputSlot> getCurrentSlots() {
        return Collections.unmodifiableList(this.currentSlots);
    }

    public void addCurrentSlot(InputSlot slot) {
        this.addCurrentSlot(slot, null);
    }

    protected void addCurrentSlot(InputSlot slot, String description) {
        if (this.currentSlots.isEmpty()) {
            this.currentSlots = new LinkedList<InputSlot>();
        }
        if (!this.currentSlots.contains(slot)) {
            this.currentSlots.add(slot);
        }
        this.setDescription(slot, description);
    }

    protected void setDescription(InputSlot slot, String description) {
        this.descriptions.put(slot, description != null ? description : "<no description>");
    }

    public void removeCurrentSlot(InputSlot slot) {
        this.currentSlots.remove(slot);
    }

    @Override
    public void activate(ToolContext tc) {
    }

    @Override
    public void perform(ToolContext tc) {
    }

    @Override
    public void deactivate(ToolContext tc) {
    }

    public String fullDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(": ").append(this.getDescription()).append('\n');
        sb.append(": always active=").append(this.activationSlots == null).append('\n');
        sb.append("current slots:").append('\n');
        for (InputSlot is : this.getCurrentSlots()) {
            sb.append("\t[" + is.getName()).append(": ").append(this.getDescription(is)).append("]\n");
        }
        return sb.toString();
    }

    @Override
    public String getDescription(InputSlot slot) {
        return this.descriptions.get(slot);
    }

    @Override
    public String getDescription() {
        return this.description != null ? this.description : "none";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private static int hash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + counter++;
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTool other = (AbstractTool)obj;
        return this.hash == other.hash;
    }
}

