/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.tree;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.util.LoggingSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneGraphNodeEntity {
    private List<SceneTreeNode> treeNodes = new ArrayList<SceneTreeNode>();
    private SceneGraphNode node;

    protected SceneGraphNodeEntity(SceneGraphNode node) {
        this.node = node;
    }

    protected void addTreeNode(SceneTreeNode tn) {
        LoggingSystem.getLogger(this).log(Level.FINE, "adding new TreeNode[{1}] for {0}", new Object[]{this.node.getName(), new Integer(this.treeNodes.size())});
        if (tn == null) {
            throw new IllegalStateException("tree node is null");
        }
        this.treeNodes.add(tn);
        tn.setEntity(this);
    }

    protected void removeTreeNode(SceneTreeNode tn) {
        LoggingSystem.getLogger(this).log(Level.FINE, "removing TreeNode for {0}", this.node.getName());
        if (tn == null) {
            throw new IllegalStateException("tree node is null");
        }
        this.treeNodes.remove(tn);
    }

    public Collection<SceneTreeNode> getTreeNodes() {
        return Collections.unmodifiableCollection(this.treeNodes);
    }

    boolean isEmpty() {
        return this.treeNodes.isEmpty();
    }

    int size() {
        return this.treeNodes.size();
    }

    protected void dispose() {
        this.treeNodes.clear();
        this.node = null;
    }

    public SceneGraphNode getNode() {
        return this.node;
    }
}

