/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.tree;

import de.jreality.scene.Appearance;
import de.jreality.scene.AudioSource;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.AudioListener;
import de.jreality.scene.event.GeometryListener;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;

public class EntityFactory {
    private SceneGraphNodeEntity produced;
    private boolean updateTransformation;
    private boolean updateAppearance;
    private boolean updateAudioSource;
    private boolean updateGeometry;
    private SceneGraphVisitor createTraversal = new SceneGraphVisitor(){

        public void visit(AudioSource a) {
            if (EntityFactory.this.updateAudioSource) {
                EntityFactory.this.produced = EntityFactory.this.produceAudioSourceEntity(a);
                a.addAudioListener((AudioListener)((Object)EntityFactory.this.produced));
            } else {
                super.visit(a);
            }
        }

        public void visit(Appearance a) {
            if (EntityFactory.this.updateAppearance) {
                EntityFactory.this.produced = EntityFactory.this.produceAppearanceEntity(a);
                a.addAppearanceListener((AppearanceListener)((Object)EntityFactory.this.produced));
            } else {
                super.visit(a);
            }
        }

        public void visit(Geometry g) {
            if (EntityFactory.this.updateGeometry) {
                EntityFactory.this.produced = EntityFactory.this.produceGeometryEntity(g);
                g.addGeometryListener((GeometryListener)((Object)EntityFactory.this.produced));
            } else {
                super.visit(g);
            }
        }

        public void visit(Transformation t) {
            if (EntityFactory.this.updateTransformation) {
                EntityFactory.this.produced = EntityFactory.this.produceTransformationEntity(t);
                t.addTransformationListener((TransformationListener)((Object)EntityFactory.this.produced));
            } else {
                super.visit(t);
            }
        }

        public void visit(SceneGraphNode n) {
            EntityFactory.this.produced = EntityFactory.this.produceSceneGraphNodeEntity(n);
        }
    };
    private SceneGraphVisitor disposeTraversal = new SceneGraphVisitor(){

        public void visit(Appearance a) {
            if (EntityFactory.this.updateAppearance) {
                a.removeAppearanceListener((AppearanceListener)((Object)EntityFactory.this.produced));
            }
        }

        public void visit(Geometry g) {
            if (EntityFactory.this.updateGeometry) {
                g.removeGeometryListener((GeometryListener)((Object)EntityFactory.this.produced));
            }
        }

        public void visit(Transformation t) {
            if (EntityFactory.this.updateTransformation) {
                t.removeTransformationListener((TransformationListener)((Object)EntityFactory.this.produced));
            }
        }
    };

    public boolean isUpdateAppearance() {
        return this.updateAppearance;
    }

    public void setUpdateAppearance(boolean updateAppearance) {
        this.updateAppearance = updateAppearance;
    }

    public boolean isUpdateAudioSource() {
        return this.updateAudioSource;
    }

    public void setUpdateAudioSource(boolean updateAudioSource) {
        this.updateAudioSource = updateAudioSource;
    }

    public boolean isUpdateGeometry() {
        return this.updateGeometry;
    }

    public void setUpdateGeometry(boolean updateGeometry) {
        this.updateGeometry = updateGeometry;
    }

    public boolean isUpdateTransformation() {
        return this.updateTransformation;
    }

    public void setUpdateTransformation(boolean updateTransformation) {
        this.updateTransformation = updateTransformation;
    }

    SceneGraphNodeEntity createEntity(SceneGraphNode node) {
        node.accept(this.createTraversal);
        return this.produced;
    }

    public void disposeEntity(SceneGraphNodeEntity entity) {
        this.produced = entity;
        entity.getNode().accept(this.disposeTraversal);
        entity.dispose();
    }

    protected SceneGraphNodeEntity produceSceneGraphNodeEntity(SceneGraphNode n) {
        return new SceneGraphNodeEntity(n);
    }

    protected SceneGraphNodeEntity produceTransformationEntity(Transformation t) {
        throw new IllegalStateException("not implemented");
    }

    protected SceneGraphNodeEntity produceAppearanceEntity(Appearance a) {
        throw new IllegalStateException("not implemented");
    }

    protected SceneGraphNodeEntity produceGeometryEntity(Geometry g) {
        throw new IllegalStateException("not implemented");
    }

    protected SceneGraphNodeEntity produceAudioSourceEntity(AudioSource g) {
        throw new IllegalStateException("not implemented");
    }
}

