/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.smrj;

import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.ByteBufferList;
import de.jreality.scene.data.DataList;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.CameraEvent;
import de.jreality.scene.event.CameraListener;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryListener;
import de.jreality.scene.event.LightEvent;
import de.jreality.scene.event.LightListener;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.proxy.scene.RemoteAppearance;
import de.jreality.scene.proxy.scene.RemoteCamera;
import de.jreality.scene.proxy.scene.RemoteGeometry;
import de.jreality.scene.proxy.scene.RemoteIndexedFaceSet;
import de.jreality.scene.proxy.scene.RemoteIndexedLineSet;
import de.jreality.scene.proxy.scene.RemoteLight;
import de.jreality.scene.proxy.scene.RemotePointLight;
import de.jreality.scene.proxy.scene.RemotePointSet;
import de.jreality.scene.proxy.scene.RemoteSceneGraphComponent;
import de.jreality.scene.proxy.scene.RemoteSceneGraphNode;
import de.jreality.scene.proxy.scene.RemoteSpotLight;
import de.jreality.scene.proxy.scene.RemoteTransformation;
import de.jreality.scene.proxy.smrj.SMRJMirrorFactory;
import de.jreality.scene.proxy.smrj.SMRJMirrorScene;
import java.io.Serializable;

public class SMRJSceneGraphSynchronizer
extends SceneGraphVisitor
implements TransformationListener,
AppearanceListener,
GeometryListener,
SceneGraphComponentListener,
CameraListener,
LightListener {
    SMRJMirrorScene rmc;
    SMRJMirrorFactory factory;
    boolean detatch = false;

    public SMRJSceneGraphSynchronizer(SMRJMirrorScene rmc) {
        this.rmc = rmc;
        this.factory = (SMRJMirrorFactory)rmc.getProxyFactory();
    }

    public void visit(Camera c) {
        if (this.detatch) {
            c.removeCameraListener(this);
        } else {
            c.addCameraListener(this);
        }
    }

    public void visit(Light l) {
        if (this.detatch) {
            l.removeLightListener(this);
        } else {
            l.addLightListener(this);
        }
    }

    public void visit(Transformation t) {
        if (this.detatch) {
            t.removeTransformationListener(this);
        } else {
            t.addTransformationListener(this);
        }
    }

    public void visit(Appearance a) {
        if (this.detatch) {
            a.removeAppearanceListener(this);
        } else {
            a.addAppearanceListener(this);
        }
    }

    public void visit(Geometry g) {
        if (this.detatch) {
            g.removeGeometryListener(this);
        } else {
            g.addGeometryListener(this);
        }
    }

    public void visit(SceneGraphComponent sg) {
        if (this.detatch) {
            sg.removeSceneGraphComponentListener(this);
        } else {
            sg.addSceneGraphComponentListener(this);
        }
    }

    public void transformationMatrixChanged(TransformationEvent ev) {
        this.rmc.writeLock.writeLock();
        ((RemoteTransformation)this.rmc.getProxy(ev.getSourceNode())).setMatrix(ev.getTransformationMatrix());
        this.rmc.writeLock.writeUnlock();
    }

    public void appearanceChanged(AppearanceEvent ev) {
        Appearance src = (Appearance)ev.getSourceNode();
        RemoteAppearance dst = (RemoteAppearance)this.rmc.getProxy(src);
        Object aa = src.getAttribute(ev.getKey());
        this.rmc.writeLock.writeLock();
        if (aa == Appearance.INHERITED) {
            aa = de.jreality.scene.proxy.scene.Appearance.INHERITED;
        }
        if (aa == Appearance.DEFAULT) {
            aa = de.jreality.scene.proxy.scene.Appearance.DEFAULT;
        }
        try {
            dst.setAttribute(ev.getKey(), aa);
        }
        catch (Exception nse) {
            System.out.println("Object in appearance not serializable: " + ev.getKey() + "  " + aa);
        }
        this.rmc.writeLock.writeUnlock();
    }

    public void geometryChanged(GeometryEvent ev) {
        ByteBufferList copy;
        DataList dl;
        Geometry src = ev.getGeometry();
        RemoteGeometry dst = (RemoteGeometry)this.rmc.getProxy(src);
        for (Attribute a : ev.getChangedFaceAttributes()) {
            dl = ((IndexedFaceSet)src).getFaceAttributes(a);
            if (ByteBufferList.canCopy(dl)) {
                copy = ByteBufferList.createByteBufferCopy(dl);
                this.rmc.writeLock.writeLock();
                ((RemoteIndexedFaceSet)dst).setFaceAttributes(a, copy);
                this.rmc.writeLock.writeUnlock();
                ByteBufferList.releaseList(copy);
                continue;
            }
            this.rmc.writeLock.writeLock();
            ((RemoteIndexedFaceSet)dst).setFaceAttributes(a, dl);
            this.rmc.writeLock.writeUnlock();
        }
        for (Attribute a : ev.getChangedEdgeAttributes()) {
            dl = ((IndexedLineSet)src).getEdgeAttributes(a);
            if (ByteBufferList.canCopy(dl)) {
                copy = ByteBufferList.createByteBufferCopy(dl);
                this.rmc.writeLock.writeLock();
                ((RemoteIndexedLineSet)dst).setEdgeAttributes(a, copy);
                this.rmc.writeLock.writeUnlock();
                ByteBufferList.releaseList(copy);
                continue;
            }
            this.rmc.writeLock.writeLock();
            ((RemoteIndexedLineSet)dst).setEdgeAttributes(a, dl);
            this.rmc.writeLock.writeUnlock();
        }
        for (Attribute a : ev.getChangedVertexAttributes()) {
            if (a.getName().equals("rungeKuttaData")) {
                System.out.println("transfering RK data!");
            }
            if (ByteBufferList.canCopy(dl = ((PointSet)src).getVertexAttributes(a))) {
                copy = ByteBufferList.createByteBufferCopy(dl);
                this.rmc.writeLock.writeLock();
                ((RemotePointSet)dst).setVertexAttributes(a, copy);
                this.rmc.writeLock.writeUnlock();
                ByteBufferList.releaseList(copy);
                continue;
            }
            this.rmc.writeLock.writeLock();
            ((RemotePointSet)dst).setVertexAttributes(a, dl);
            this.rmc.writeLock.writeUnlock();
        }
        for (String key : ev.getChangedGeometryAttributes()) {
            if (!(src.getGeometryAttributes(key) instanceof Serializable)) continue;
            this.rmc.writeLock.writeLock();
            dst.setGeometryAttributes(key, src.getGeometryAttributes(key));
            this.rmc.writeLock.writeUnlock();
        }
    }

    public void childAdded(SceneGraphComponentEvent ev) {
        this.rmc.writeLock.writeLock();
        RemoteSceneGraphNode createProxyScene = (RemoteSceneGraphNode)this.rmc.createProxyScene(ev.getNewChildElement());
        ((RemoteSceneGraphComponent)this.rmc.getProxyImpl(ev.getSceneGraphComponent())).add(createProxyScene);
        this.rmc.writeLock.writeUnlock();
    }

    public void childRemoved(SceneGraphComponentEvent ev) {
        this.rmc.writeLock.writeLock();
        ((RemoteSceneGraphComponent)this.rmc.getProxyImpl(ev.getSceneGraphComponent())).remove((RemoteSceneGraphNode)this.rmc.getProxyImpl(ev.getOldChildElement()));
        this.rmc.writeLock.writeUnlock();
    }

    public void childReplaced(SceneGraphComponentEvent ev) {
        this.childRemoved(ev);
        this.childAdded(ev);
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
        this.rmc.writeLock.writeLock();
        ((RemoteSceneGraphComponent)this.rmc.getProxyImpl(ev.getSceneGraphComponent())).setVisible(ev.getSceneGraphComponent().isVisible());
        this.rmc.writeLock.writeUnlock();
    }

    public void cameraChanged(CameraEvent ev) {
        Camera src = ev.getCamera();
        RemoteCamera dst = (RemoteCamera)this.rmc.getProxyImpl(ev.getCamera());
        this.rmc.writeLock.writeLock();
        dst.setEyeSeparation(src.getEyeSeparation());
        dst.setFar(src.getFar());
        dst.setFieldOfView(src.getFieldOfView());
        dst.setFocus(src.getFocus());
        dst.setNear(src.getNear());
        dst.setOnAxis(src.isOnAxis());
        dst.setOrientationMatrix(src.getOrientationMatrix());
        dst.setPerspective(src.isPerspective());
        dst.setStereo(src.isStereo());
        if (src.getViewPort() != null) {
            dst.setViewPort(src.getViewPort().getX(), src.getViewPort().getY(), src.getViewPort().getWidth(), src.getViewPort().getHeight());
        }
        this.rmc.writeLock.writeUnlock();
    }

    public void lightChanged(LightEvent ev) {
        RemotePointLight dst1;
        PointLight src1;
        Light src = ev.getLight();
        RemoteLight dst = (RemoteLight)this.rmc.getProxyImpl(src);
        this.rmc.writeLock.writeLock();
        if (src instanceof SpotLight) {
            src1 = (SpotLight)src;
            dst1 = (RemoteSpotLight)dst;
            dst1.setConeAngle(((SpotLight)src1).getConeAngle());
            dst1.setConeDeltaAngle(((SpotLight)src1).getConeDeltaAngle());
            dst1.setDistribution(((SpotLight)src1).getDistribution());
        }
        if (src instanceof PointLight) {
            src1 = (PointLight)src;
            dst1 = (RemotePointLight)dst;
            dst1.setFalloffA0(src1.getFalloffA0());
            dst1.setFalloffA1(src1.getFalloffA1());
            dst1.setFalloffA2(src1.getFalloffA2());
            dst1.setUseShadowMap(src1.isUseShadowMap());
            dst1.setShadowMapX(src1.getShadowMapX());
            dst1.setShadowMapY(src1.getShadowMapY());
            dst1.setShadowMap(src1.getShadowMap());
        }
        dst.setColor(src.getColor());
        dst.setIntensity(src.getIntensity());
        this.rmc.writeLock.writeUnlock();
    }
}

