/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.smrj;

import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.ByteBufferList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.proxy.ProxyFactory;
import de.jreality.scene.proxy.scene.RemoteAppearance;
import de.jreality.scene.proxy.scene.RemoteCamera;
import de.jreality.scene.proxy.scene.RemoteClippingPlane;
import de.jreality.scene.proxy.scene.RemoteCylinder;
import de.jreality.scene.proxy.scene.RemoteDirectionalLight;
import de.jreality.scene.proxy.scene.RemoteGeometry;
import de.jreality.scene.proxy.scene.RemoteIndexedFaceSet;
import de.jreality.scene.proxy.scene.RemoteIndexedLineSet;
import de.jreality.scene.proxy.scene.RemoteLight;
import de.jreality.scene.proxy.scene.RemotePointLight;
import de.jreality.scene.proxy.scene.RemotePointSet;
import de.jreality.scene.proxy.scene.RemoteSceneGraphComponent;
import de.jreality.scene.proxy.scene.RemoteSceneGraphNode;
import de.jreality.scene.proxy.scene.RemoteSphere;
import de.jreality.scene.proxy.scene.RemoteSpotLight;
import de.jreality.scene.proxy.scene.RemoteTransformation;
import de.smrj.RemoteFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class SMRJMirrorFactory
extends ProxyFactory {
    RemoteFactory rf;
    Object created;

    public SMRJMirrorFactory(RemoteFactory rf) {
        this.rf = rf;
    }

    public Object getProxy() {
        return this.created;
    }

    private Object createRemote(Class clazz) {
        try {
            return this.rf.createRemote(clazz);
        }
        catch (IOException ie) {
            throw new IllegalStateException("IO Error");
        }
    }

    public void visit(Appearance a) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.Appearance.class);
        this.copyAttr(a, (RemoteAppearance)this.created);
    }

    public void visit(Camera c) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.Camera.class);
        this.copyAttr(c, (RemoteCamera)this.created);
    }

    public void visit(Cylinder c) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.Cylinder.class);
        this.copyAttr(c, (RemoteCylinder)this.created);
    }

    public void visit(DirectionalLight l) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.DirectionalLight.class);
        this.copyAttr(l, (RemoteDirectionalLight)this.created);
    }

    public void visit(IndexedFaceSet i) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.IndexedFaceSet.class);
        this.copyAttr(i, (RemoteIndexedFaceSet)this.created);
    }

    public void visit(IndexedLineSet ils) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.IndexedLineSet.class);
        this.copyAttr(ils, (RemoteIndexedLineSet)this.created);
    }

    public void visit(PointSet p) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.PointSet.class);
        this.copyAttr(p, (RemotePointSet)this.created);
    }

    public void visit(SceneGraphComponent c) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.SceneGraphComponent.class);
        this.copyAttr(c, (RemoteSceneGraphComponent)this.created);
    }

    public void visit(Sphere s) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.Sphere.class);
        this.copyAttr(s, (RemoteSphere)this.created);
    }

    public void visit(SpotLight l) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.SpotLight.class);
        this.copyAttr(l, (RemoteSpotLight)this.created);
    }

    public void visit(ClippingPlane c) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.ClippingPlane.class);
        this.copyAttr((SceneGraphNode)c, (RemoteClippingPlane)this.created);
    }

    public void visit(PointLight l) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.PointLight.class);
        this.copyAttr(l, (RemotePointLight)this.created);
    }

    public void visit(Transformation t) {
        this.created = this.createRemote(de.jreality.scene.proxy.scene.Transformation.class);
        this.copyAttr(t, (RemoteTransformation)this.created);
    }

    public void visit(SceneGraphNode m) {
        throw new IllegalStateException(m.getClass() + " not handled by " + this.getClass().getName());
    }

    public void copyAttr(SceneGraphNode src, RemoteSceneGraphNode dst) {
        dst.setName(src.getName());
    }

    public void copyAttr(SceneGraphComponent src, RemoteSceneGraphComponent dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        dst.setVisible(src.isVisible());
    }

    public void copyAttr(Appearance src, RemoteAppearance dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        Set lst = src.getStoredAttributes();
        for (String aName : lst) {
            Object aa = src.getAttribute(aName);
            if (aa == de.jreality.scene.proxy.scene.Appearance.INHERITED) {
                aa = de.jreality.scene.proxy.scene.Appearance.INHERITED;
            }
            if (aa == de.jreality.scene.proxy.scene.Appearance.DEFAULT) {
                aa = de.jreality.scene.proxy.scene.Appearance.DEFAULT;
            }
            dst.setAttribute(aName, aa);
        }
    }

    public void copyAttr(Transformation src, RemoteTransformation dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        dst.setMatrix(src.getMatrix());
    }

    public void copyAttr(Light src, RemoteLight dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        dst.setColor(src.getColor());
        dst.setIntensity(src.getIntensity());
    }

    public void copyAttr(DirectionalLight src, RemoteDirectionalLight dst) {
        this.copyAttr((Light)src, (RemoteLight)dst);
    }

    public void copyAttr(PointLight src, RemotePointLight dst) {
        this.copyAttr((Light)src, (RemoteLight)dst);
        dst.setFalloffA0(src.getFalloffA0());
        dst.setFalloffA1(src.getFalloffA1());
        dst.setFalloffA2(src.getFalloffA2());
        dst.setUseShadowMap(src.isUseShadowMap());
        dst.setShadowMapX(src.getShadowMapX());
        dst.setShadowMapY(src.getShadowMapY());
        dst.setShadowMap(src.getShadowMap());
    }

    public void copyAttr(SpotLight src, RemoteSpotLight dst) {
        this.copyAttr((PointLight)src, (RemotePointLight)dst);
        dst.setConeAngle(src.getConeAngle());
        dst.setConeDeltaAngle(src.getConeDeltaAngle());
        dst.setDistribution(src.getDistribution());
    }

    public void copyAttr(Geometry src, RemoteGeometry dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        HashMap<String, Object> serializableGeometryAttributes = new HashMap<String, Object>();
        for (String key : src.getGeometryAttributes().keySet()) {
            Object attr = src.getGeometryAttributes().get(key);
            if (!(attr instanceof Serializable)) continue;
            serializableGeometryAttributes.put(key, attr);
        }
        dst.setGeometryAttributes(serializableGeometryAttributes);
    }

    public void copyAttr(Sphere src, RemoteSphere dst) {
        this.copyAttr((Geometry)src, (RemoteGeometry)dst);
    }

    public void copyAttr(Cylinder src, RemoteCylinder dst) {
        this.copyAttr((Geometry)src, (RemoteGeometry)dst);
    }

    public void copyAttr(PointSet src, RemotePointSet dst) {
        this.copyAttr((Geometry)src, (RemoteGeometry)dst);
        DataListSet dls = ByteBufferList.prepareDataListSet(src.getVertexAttributes());
        dst.setVertexCountAndAttributes(dls);
        ByteBufferList.releaseDataListSet(dls);
    }

    public void copyAttr(IndexedLineSet src, RemoteIndexedLineSet dst) {
        this.copyAttr((PointSet)src, (RemotePointSet)dst);
        DataListSet dls = ByteBufferList.prepareDataListSet(src.getEdgeAttributes());
        dst.setEdgeCountAndAttributes(dls);
        ByteBufferList.releaseDataListSet(dls);
    }

    public void copyAttr(IndexedFaceSet src, RemoteIndexedFaceSet dst) {
        this.copyAttr((IndexedLineSet)src, (RemoteIndexedLineSet)dst);
        DataListSet dls = ByteBufferList.prepareDataListSet(src.getFaceAttributes());
        dst.setFaceCountAndAttributes(dls);
        ByteBufferList.releaseDataListSet(dls);
    }

    public void copyAttr(Camera src, RemoteCamera dst) {
        this.copyAttr((SceneGraphNode)src, (RemoteSceneGraphNode)dst);
        dst.setEyeSeparation(src.getEyeSeparation());
        dst.setFar(src.getFar());
        dst.setFieldOfView(src.getFieldOfView());
        dst.setFocus(src.getFocus());
        dst.setNear(src.getNear());
        dst.setOnAxis(src.isOnAxis());
        dst.setOrientationMatrix(src.getOrientationMatrix());
        dst.setPerspective(src.isPerspective());
        dst.setStereo(src.isStereo());
        if (src.getViewPort() != null) {
            dst.setViewPort(src.getViewPort().getX(), src.getViewPort().getY(), src.getViewPort().getWidth(), src.getViewPort().getHeight());
        }
    }
}

