/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.HitFilter;
import de.jreality.scene.pick.PickResult;
import de.jreality.util.CameraUtility;

public class PosWHitFilter
implements HitFilter {
    Viewer viewer;
    SceneGraphPath camPath;
    double[] world2ndc;

    public PosWHitFilter(Viewer v) {
        this.setViewer(v);
    }

    public void setViewer(Viewer v) {
        this.viewer = v;
        this.update();
    }

    public void update() {
        this.camPath = this.viewer.getCameraPath();
        if (this.camPath == null) {
            return;
        }
        double[] world2cam = this.camPath.getInverseMatrix(null);
        this.world2ndc = Rn.times(null, CameraUtility.getCameraToNDC(this.viewer), world2cam);
    }

    public boolean accept(double[] from, double[] to, PickResult h) {
        if (this.world2ndc == null) {
            return false;
        }
        double[] ndcCoords = Rn.matrixTimesVector(null, this.world2ndc, h.getWorldCoordinates());
        boolean posW = ndcCoords[3] >= 0.0;
        return posW;
    }
}

