/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Matrix;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.pick.PickResult;
import de.jreality.util.LoggingSystem;
import java.util.Arrays;
import java.util.Comparator;

public class Hit
implements PickResult {
    final SceneGraphPath path;
    final double[] pointWorld;
    final double[] pointObject;
    double[] texCoords = null;
    final int pickType;
    final int index;
    final int triIndex;
    final double dist;
    final double affineCoordinate;
    private static final double EPS = 1.0E-5;

    public Hit(SceneGraphPath path, double[] pointWorld, double dist, double affineCoord, int pickType, int index, int triIndex) {
        this.path = path;
        Matrix m = new Matrix();
        path.getInverseMatrix(m.getArray());
        this.pointWorld = pointWorld;
        this.pointObject = m.multiplyVector(pointWorld);
        this.dist = dist;
        this.affineCoordinate = affineCoord;
        this.pickType = pickType;
        this.index = index;
        this.triIndex = triIndex;
    }

    public SceneGraphPath getPickPath() {
        return this.path;
    }

    public double[] getWorldCoordinates() {
        return this.pointWorld;
    }

    public double[] getObjectCoordinates() {
        return this.pointObject;
    }

    public double getDist() {
        return this.dist;
    }

    public int getIndex() {
        return this.index;
    }

    private String nameForType(int pickType) {
        if (pickType == 1) {
            return "face";
        }
        if (pickType == 2) {
            return "edge";
        }
        if (pickType == 4) {
            return "point";
        }
        return "object";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AABB-Pick: ");
        sb.append(" dist=").append(this.dist);
        sb.append(" type=").append(this.nameForType(this.pickType));
        sb.append(" index=").append(this.index);
        sb.append(" tc=").append(Arrays.toString(this.getTextureCoordinates()));
        sb.append(" world=").append(Arrays.toString(this.pointWorld));
        sb.append(" path=").append(this.path.toString());
        sb.append(" affine coordinate =").append(this.affineCoordinate);
        return sb.toString();
    }

    public int getPickType() {
        return this.pickType;
    }

    public double getAffineCoordinate() {
        return this.affineCoordinate;
    }

    private int hasTextureCoordinates() {
        if (this.texCoords == null) {
            DataList indices;
            IndexedFaceSet ifs;
            DataList txc;
            SceneGraphNode end;
            if (this.triIndex > -1 && (end = this.path.getLastElement()) instanceof IndexedFaceSet && (txc = (ifs = (IndexedFaceSet)end).getVertexAttributes(Attribute.TEXTURE_COORDINATES)) != null && (indices = ifs.getFaceAttributes(Attribute.INDICES)) != null) {
                DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                IntArray faceIndices = indices.item(this.index).toIntArray();
                int l = faceIndices.size();
                int ptIndex0 = faceIndices.getValueAt(0);
                int ptIndex1 = faceIndices.getValueAt((this.triIndex + 1) % l);
                int ptIndex2 = faceIndices.getValueAt((this.triIndex + 2) % l);
                DoubleArray tc0 = txc.item(ptIndex0).toDoubleArray();
                DoubleArray tc1 = txc.item(ptIndex1).toDoubleArray();
                DoubleArray tc2 = txc.item(ptIndex2).toDoubleArray();
                int textureLength = tc0.getLength();
                this.texCoords = new double[textureLength];
                double[] a = new double[3];
                DoubleArray pt = points.item(ptIndex0).toDoubleArray();
                a[0] = pt.getValueAt(0);
                a[1] = pt.getValueAt(1);
                a[2] = pt.getValueAt(2);
                if (pt.size() == 4) {
                    double w = pt.getValueAt(3);
                    a[0] = a[0] / w;
                    a[1] = a[1] / w;
                    a[2] = a[2] / w;
                }
                double[] b = new double[3];
                pt = points.item(ptIndex1).toDoubleArray();
                b[0] = pt.getValueAt(0);
                b[1] = pt.getValueAt(1);
                b[2] = pt.getValueAt(2);
                if (pt.size() == 4) {
                    double w = pt.getValueAt(3);
                    b[0] = b[0] / w;
                    b[1] = b[1] / w;
                    b[2] = b[2] / w;
                }
                double[] c = new double[3];
                pt = points.item(ptIndex2).toDoubleArray();
                c[0] = pt.getValueAt(0);
                c[1] = pt.getValueAt(1);
                c[2] = pt.getValueAt(2);
                if (pt.size() == 4) {
                    double w = pt.getValueAt(3);
                    c[0] = c[0] / w;
                    c[1] = c[1] / w;
                    c[2] = c[2] / w;
                }
                double[] bc = new double[3];
                Hit.convertToBary(bc, a, b, c, this.pointObject);
                for (int j = 0; j < textureLength; ++j) {
                    this.texCoords[j] = bc[0] * tc0.getValueAt(j) + bc[1] * tc1.getValueAt(j) + bc[2] * tc2.getValueAt(j);
                }
                return this.texCoords.length;
            }
            this.texCoords = new double[0];
        }
        return this.texCoords.length;
    }

    public static boolean convertToBary(double[] bary, double[] x0, double[] x1, double[] x2, double[] x) {
        double det;
        int i0 = 0;
        int i1 = 1;
        int i2 = 2;
        while (!(Math.abs(det = x1[i0] * x2[i1] - x1[i1] * x2[i0] - (x0[i0] * x2[i1] - x0[i1] * x2[i0]) + x0[i0] * x1[i1] - x0[i1] * x1[i0]) > 1.0E-5)) {
            if (i1 == 1) {
                i1 = 2;
                i2 = 1;
                continue;
            }
            if (i0 == 0) {
                i0 = 1;
                i2 = 0;
                continue;
            }
            LoggingSystem.getLogger(Hit.class).fine("mBaryInElementConvertFromVec3: triangle degenerated?");
            return false;
        }
        bary[0] = (x1[i0] * x2[i1] - x1[i1] * x2[i0] - (x[i0] * x2[i1] - x[i1] * x2[i0]) + x[i0] * x1[i1] - x[i1] * x1[i0]) / det;
        bary[1] = (x[i0] * x2[i1] - x[i1] * x2[i0] - (x0[i0] * x2[i1] - x0[i1] * x2[i0]) + x0[i0] * x[i1] - x0[i1] * x[i0]) / det;
        bary[2] = 1.0 - bary[0] - bary[1];
        if (Math.abs(x0[i2] * bary[0] + x1[i2] * bary[1] + x2[i2] * bary[2] - x[i2]) > 0.001) {
            LoggingSystem.getLogger(Hit.class).fine("gmBaryInElementConvertFromVec3: test for third row failed." + Math.abs(x0[i2] * bary[0] + x1[i2] * bary[1] + x2[i2] * bary[2] - x[i2]));
            return false;
        }
        Hit.correct(bary);
        return true;
    }

    static final void correct(double[] bary) {
        double sum = 0.0;
        int i = 0;
        for (i = 0; i < 3; ++i) {
            if (Math.abs(bary[i]) < 1.0E-5) {
                bary[i] = 0.0;
            }
            sum += bary[i];
        }
        for (i = 0; bary[i] == 0.0 && i < 3; ++i) {
        }
        int j = (i + 1) % 3;
        bary[j] = bary[j] / sum;
        int k = (i + 2) % 3;
        bary[k] = bary[k] / sum;
        bary[i] = 1.0 - bary[j] - bary[k];
    }

    public double[] getTextureCoordinates() {
        this.hasTextureCoordinates();
        return this.texCoords;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HitComparator
    implements Comparator<Hit> {
        @Override
        public int compare(Hit hit1, Hit hit2) {
            double b;
            double a = hit1.getAffineCoordinate();
            return a > (b = hit2.getAffineCoordinate()) ? 1 : (b > a ? -1 : 0);
        }
    }
}

