/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Cylinder;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.pick.Hit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BruteForcePicking {
    private static final List<double[]> SPHERE_HIT_LIST = new LinkedList<double[]>();
    private static final List<double[]> CYLINDER_HIT_LIST = new LinkedList<double[]>();

    BruteForcePicking() {
    }

    public static void intersectPolygons(IndexedFaceSet ifs, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, ArrayList<Hit> hits) {
        double[] fromLocal = mInv.multiplyVector(from);
        double[] toLocal = mInv.multiplyVector(to);
        double[] p1 = new double[4];
        double[] p2 = new double[4];
        double[] p3 = new double[4];
        double[] pobj = new double[4];
        p3[3] = 1.0;
        p2[3] = 1.0;
        p1[3] = 1.0;
        IntArrayArray faces = BruteForcePicking.getFaces(ifs);
        DoubleArrayArray points = BruteForcePicking.getPoints(ifs);
        if (faces == null || points == null || faces.getLength() == 0 || points.getLength() == 0) {
            return;
        }
        int n = faces.getLength();
        for (int i = 0; i < n; ++i) {
            IntArray face = faces.getValueAt(i);
            int dd = face.getLength() - 2;
            for (int j = 0; j < dd; ++j) {
                p1 = points.getValueAt(face.getValueAt(0)).toDoubleArray(p1);
                if (!BruteForcePicking.intersects(pobj, fromLocal, toLocal, p1, p2 = points.getValueAt(face.getValueAt(1 + j)).toDoubleArray(p2), p3 = points.getValueAt(face.getValueAt(2 + j)).toDoubleArray(p3))) continue;
                double[] pw = m.multiplyVector(pobj);
                double d = Pn.distanceBetween(from, pw, metric);
                double affCoord = P3.affineCoordinate(from, to, pw);
                hits.add(new Hit(path.pushNew(ifs), pw, d, affCoord, 1, i, j));
            }
        }
    }

    public static boolean intersects(double[] pobj, double[] fromLocal, double[] toLocal, double[] p1, double[] p2, double[] p3) {
        double[] plane = P3.planeFromPoints(null, p1, p2, p3);
        pobj = P3.lineIntersectPlane(pobj, fromLocal, toLocal, plane);
        Pn.dehomogenize(p1, p1);
        Pn.dehomogenize(p2, p2);
        Pn.dehomogenize(p3, p3);
        double[] bary = new double[3];
        if (!Hit.convertToBary(bary, p1, p2, p3, pobj)) {
            return false;
        }
        return !(bary[0] < 0.0 || bary[0] > 1.0 || bary[1] < 0.0 || bary[1] > 1.0 || bary[2] < 0.0 || bary[2] > 1.0) && !((bary[0] + bary[1] + bary[2] - 1.0) * (bary[0] + bary[1] + bary[2] - 1.0) > 1.0E-7);
    }

    public static void intersectEdges(IndexedLineSet ils, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, double tubeRadius, ArrayList<Hit> localHits) {
        double[] fromOb = mInv.multiplyVector(from);
        double[] toOb = mInv.multiplyVector(to);
        double[] fromOb3 = new double[3];
        double[] toOb3 = new double[3];
        double[] dirOb3 = new double[3];
        if (from.length > 3) {
            Pn.dehomogenize(fromOb3, fromOb);
            Pn.dehomogenize(toOb3, toOb);
            if (toOb[3] == 0.0) {
                dirOb3 = toOb3;
            } else {
                Rn.subtract(dirOb3, toOb3, fromOb3);
            }
        } else {
            Rn.subtract(dirOb3, toOb3, fromOb3);
        }
        IntArrayArray edges = BruteForcePicking.getEdges(ils);
        DoubleArrayArray points = BruteForcePicking.getPoints(ils);
        if (points == null || edges == null || edges.getLength() == 0 || points.getLength() == 0) {
            return;
        }
        IntArray edge = edges.getValueAt(0);
        DoubleArray point = points.getValueAt(0);
        boolean vec3 = point.getLength() == 3;
        double[] vertex1 = new double[3];
        double[] vertex2 = new double[3];
        double[] vecRaw1 = vec3 ? null : new double[4];
        double[] vecRaw2 = vec3 ? null : new double[4];
        LinkedList<double[]> MY_HITS = new LinkedList<double[]>();
        DoubleArray edgeRadii = BruteForcePicking.getRadii(ils);
        int mm = edges.getLength();
        for (int i = 0; i < mm; ++i) {
            edge = edges.getValueAt(i);
            double realRad = tubeRadius;
            if (edgeRadii != null) {
                realRad *= edgeRadii.getValueAt(i);
            }
            int n = edge.getLength() - 1;
            for (int j = 0; j < n; ++j) {
                if (vec3) {
                    points.getValueAt(edge.getValueAt(j)).toDoubleArray(vertex1);
                    points.getValueAt(edge.getValueAt(j + 1)).toDoubleArray(vertex2);
                } else {
                    points.getValueAt(edge.getValueAt(j)).toDoubleArray(vecRaw1);
                    points.getValueAt(edge.getValueAt(j + 1)).toDoubleArray(vecRaw2);
                    if (vecRaw1[3] == 0.0) {
                        Rn.linearCombination(vecRaw1, 0.99, vecRaw1, 0.01, vecRaw2);
                    } else if (vecRaw2[3] == 0.0) {
                        Rn.linearCombination(vecRaw2, 0.99, vecRaw2, 0.01, vecRaw1);
                    }
                    Pn.dehomogenize(vertex1, vecRaw1);
                    Pn.dehomogenize(vertex2, vecRaw2);
                }
                BruteForcePicking.intersectCylinder(MY_HITS, m, fromOb3, dirOb3, vertex1, vertex2, tubeRadius);
                Iterator it = MY_HITS.iterator();
                while (it.hasNext()) {
                    double[] hitPoint = (double[])it.next();
                    it.remove();
                    double dist = Rn.euclideanNorm(Rn.subtract(null, hitPoint, from));
                    double affCoord = P3.affineCoordinate(from, to, hitPoint);
                    Hit h = new Hit(path.pushNew(ils), hitPoint, dist, affCoord, 2, i, -1);
                    localHits.add(h);
                }
            }
        }
    }

    private static DoubleArrayArray getPoints(PointSet ils) {
        DataList dl = ils.getVertexAttributes(Attribute.COORDINATES);
        if (dl == null) {
            return null;
        }
        return dl.toDoubleArrayArray();
    }

    private static DoubleArray getRadii(PointSet ps) {
        DataList dl = ps.getVertexAttributes(Attribute.RELATIVE_RADII);
        if (dl == null) {
            return null;
        }
        return dl.toDoubleArray();
    }

    private static DoubleArray getRadii(IndexedLineSet ls) {
        DataList dl = ls.getEdgeAttributes(Attribute.RELATIVE_RADII);
        if (dl == null) {
            return null;
        }
        return dl.toDoubleArray();
    }

    private static IntArrayArray getEdges(IndexedLineSet ils) {
        DataList dl = ils.getEdgeAttributes(Attribute.INDICES);
        if (dl == null) {
            return null;
        }
        return dl.toIntArrayArray();
    }

    private static IntArrayArray getFaces(IndexedFaceSet ils) {
        DataList dl = ils.getFaceAttributes(Attribute.INDICES);
        if (dl == null) {
            return null;
        }
        return dl.toIntArrayArray();
    }

    public static void intersectPoints(PointSet ps, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, double pointRadius, ArrayList<Hit> localHits) {
        double[] fromOb = mInv.multiplyVector(from);
        double[] toOb = mInv.multiplyVector(to);
        double[] fromOb3 = new double[3];
        double[] toOb3 = new double[3];
        double[] dirOb3 = new double[3];
        if (from.length > 3) {
            Pn.dehomogenize(fromOb3, fromOb);
            Pn.dehomogenize(toOb3, toOb);
            if (toOb[3] == 0.0) {
                dirOb3 = toOb3;
            } else {
                Rn.subtract(dirOb3, toOb3, fromOb3);
            }
        } else {
            Rn.subtract(dirOb3, toOb3, fromOb3);
        }
        DoubleArrayArray points = BruteForcePicking.getPoints(ps);
        if (points == null || points.getLength() == 0) {
            return;
        }
        DoubleArray point = points.getValueAt(0);
        boolean vec3 = point.getLength() == 3;
        double[] vertexRaw = vec3 ? new double[3] : new double[4];
        double[] vertex = new double[3];
        LinkedList<double[]> MY_HITS = new LinkedList<double[]>();
        DoubleArray pointRadii = BruteForcePicking.getRadii(ps);
        int n = points.getLength();
        for (int j = 0; j < n; ++j) {
            if (!vec3) {
                points.getValueAt(j).toDoubleArray(vertexRaw);
                if (vertexRaw[3] == 0.0) continue;
                Pn.dehomogenize(vertex, vertexRaw);
            } else {
                points.getValueAt(j).toDoubleArray(vertex);
            }
            double realRad = pointRadius;
            if (pointRadii != null) {
                realRad = pointRadius * pointRadii.getValueAt(j);
            }
            BruteForcePicking.intersectSphere(MY_HITS, vertex, fromOb3, dirOb3, realRad);
            Iterator i = MY_HITS.iterator();
            while (i.hasNext()) {
                double[] hitPoint = (double[])i.next();
                hitPoint = m.multiplyVector(hitPoint);
                i.remove();
                double dist = Rn.euclideanNorm(Rn.subtract(null, hitPoint, from));
                double affCoord = P3.affineCoordinate(from, to, hitPoint);
                Hit h = new Hit(path.pushNew(ps), hitPoint, dist, affCoord, 4, j, -1);
                localHits.add(h);
            }
        }
    }

    public static void intersectSphere(Sphere sphere, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, ArrayList<Hit> localHits) {
        double[] fromOb = mInv.multiplyVector(from);
        double[] toOb = mInv.multiplyVector(to);
        double[] fromOb3 = new double[3];
        double[] toOb3 = new double[3];
        double[] dirOb3 = new double[3];
        if (from.length > 3) {
            Pn.dehomogenize(fromOb3, fromOb);
            Pn.dehomogenize(toOb3, toOb);
            if (toOb[3] == 0.0) {
                dirOb3 = toOb3;
            } else {
                Rn.subtract(dirOb3, toOb3, fromOb3);
            }
        } else {
            Rn.subtract(dirOb3, toOb3, fromOb3);
        }
        BruteForcePicking.intersectSphere(SPHERE_HIT_LIST, null, fromOb3, dirOb3, 1.0);
        Iterator<double[]> i = SPHERE_HIT_LIST.iterator();
        while (i.hasNext()) {
            double[] hitPoint = i.next();
            hitPoint = m.multiplyVector(hitPoint);
            i.remove();
            double dist = Rn.euclideanNorm(Rn.subtract(null, hitPoint, from));
            double affCoord = P3.affineCoordinate(from, to, hitPoint);
            Hit h = new Hit(path.pushNew(sphere), hitPoint, dist, affCoord, 0, -1, -1);
            localHits.add(h);
        }
    }

    private static void intersectSphere(List<double[]> hits, double[] vertex, double[] f, double[] dir, double r) {
        double[] from = f;
        Rn.normalize(dir, dir);
        if (vertex != null) {
            from = Rn.subtract(null, from, vertex);
        }
        double b = 2.0 * Rn.innerProduct(dir, from);
        double c = Rn.euclideanNormSquared(from) - r * r;
        double dis = Math.pow(b, 2.0) - 4.0 * c;
        if (dis >= 0.0) {
            dis = Math.sqrt(dis);
            double t = (-b - dis) / 2.0;
            for (int i = 0; i < 2; ++i) {
                if (!((t += (double)i * dis) >= 0.0)) continue;
                double[] hitPointOb3 = new double[3];
                Rn.times(hitPointOb3, t, dir);
                Rn.add(hitPointOb3, hitPointOb3, from);
                if (vertex != null) {
                    Rn.add(hitPointOb3, hitPointOb3, vertex);
                }
                double[] hitPoint = new double[4];
                Pn.homogenize(hitPoint, hitPointOb3);
                hits.add(hitPoint);
            }
        }
    }

    public static void intersectCylinder(Cylinder cylinder, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, ArrayList<Hit> localHits) {
        double[] fromOb = mInv.multiplyVector(from);
        double[] toOb = mInv.multiplyVector(to);
        double[] fromOb3 = new double[3];
        double[] toOb3 = new double[3];
        double[] dirOb3 = new double[3];
        if (from.length > 3) {
            Pn.dehomogenize(fromOb3, fromOb);
            Pn.dehomogenize(toOb3, toOb);
            if (toOb[3] == 0.0) {
                dirOb3 = toOb3;
            } else {
                Rn.subtract(dirOb3, toOb3, fromOb3);
            }
        } else {
            Rn.subtract(dirOb3, toOb3, fromOb3);
        }
        BruteForcePicking.intersectCylinder(CYLINDER_HIT_LIST, m, fromOb3, dirOb3, new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 0.0, -1.0}, 1.0);
        double[] tmp = new double[from.length];
        Iterator<double[]> i = CYLINDER_HIT_LIST.iterator();
        while (i.hasNext()) {
            double[] hitPoint = i.next();
            i.remove();
            double affCoord = P3.affineCoordinate(from, to, hitPoint);
            double dist = Rn.euclideanNorm(Rn.subtract(tmp, hitPoint, from));
            Hit h = new Hit(path.pushNew(cylinder), hitPoint, dist, affCoord, 0, -1, -1);
            localHits.add(h);
        }
    }

    private static void intersectCylinder(List<double[]> hits, Matrix m, double[] f, double[] d, double[] v1, double[] v2, double r) {
        double angle;
        boolean debug = false;
        long time = System.currentTimeMillis();
        double[] from = f;
        double[] dir = d;
        Rn.normalize(dir, dir);
        double[] dir_cyl = Rn.subtract(null, v2, v1);
        Rn.normalize(dir_cyl, dir_cyl);
        double[] dir_cyl_x_dir = Rn.crossProduct(null, dir_cyl, dir);
        double[] from_min_v1 = Rn.subtract(null, from, v1);
        double lambda = Rn.innerProduct(dir_cyl_x_dir, Rn.crossProduct(null, from_min_v1, dir_cyl)) / Rn.euclideanNormSquared(dir_cyl_x_dir);
        double[] nearest = Rn.add(null, from, Rn.times(null, lambda, dir));
        double dist = Math.abs(Rn.innerProduct(dir_cyl_x_dir, from_min_v1)) / Rn.euclideanNorm(dir_cyl_x_dir);
        if (dist <= r && Math.cos(angle = Math.abs(Rn.euclideanAngle(dir, dir_cyl))) != 0.0) {
            double[] hitPoint;
            if (angle > Math.PI) {
                angle = Math.PI * 2 - angle;
            }
            if (angle > 1.5707963267948966) {
                angle = Math.PI - angle;
            }
            double factor = Math.sqrt(Math.pow(r, 2.0) - Math.pow(dist, 2.0)) / Math.cos(1.5707963267948966 - angle);
            double maxDist = Math.sqrt(Math.pow(Rn.euclideanDistance(v1, v2), 2.0) + Math.pow(r, 2.0));
            double[] hitPointOb3 = new double[3];
            Rn.times(hitPointOb3, -factor, dir);
            Rn.add(hitPointOb3, hitPointOb3, nearest);
            if (Rn.euclideanDistance(hitPointOb3, v1) < maxDist && Rn.euclideanDistance(hitPointOb3, v2) < maxDist) {
                if (debug) {
                    System.out.println("Methode2: cylinder matched_1");
                    System.out.println("Methode2: hitPointOb: " + hitPointOb3[0] + ", " + hitPointOb3[1] + ", " + hitPointOb3[2]);
                }
                hitPoint = new double[4];
                Pn.homogenize(hitPoint, hitPointOb3);
                hitPoint = m.multiplyVector(hitPoint);
                hits.add(hitPoint);
            }
            Rn.times(hitPointOb3, factor, dir);
            Rn.add(hitPointOb3, hitPointOb3, nearest);
            if (Rn.euclideanDistance(hitPointOb3, v1) < maxDist && Rn.euclideanDistance(hitPointOb3, v2) < maxDist) {
                if (debug) {
                    System.out.println("Methode2: cylinder matched_2");
                    System.out.println("Methode2: hitPointOb: " + hitPointOb3[0] + ", " + hitPointOb3[1] + ", " + hitPointOb3[2]);
                }
                hitPoint = new double[4];
                Pn.homogenize(hitPoint, hitPointOb3);
                hitPoint = m.multiplyVector(hitPoint);
                hits.add(hitPoint);
            }
        }
        if (debug) {
            System.out.println("Methode2: " + (System.currentTimeMillis() - time) + " ms");
            System.out.println("");
        }
    }
}

