/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.math.Rn;
import de.jreality.scene.pick.AABBTree;

class AABB {
    final double[] center = new double[]{0.0, 0.0, 0.0};
    private static final double[] X = new double[]{1.0, 0.0, 0.0, 0.0};
    private static final double[] Y = new double[]{0.0, 1.0, 0.0, 0.0};
    private static final double[] Z = new double[]{0.0, 0.0, 1.0, 0.0};
    final double[] extent = new double[]{0.0, 0.0, 0.0};
    private final double[] tmpVec1 = new double[3];
    private final double[] tmpVec2 = new double[3];

    AABB() {
    }

    void compute(AABBTree.TreePolygon[] tris, int start, int end) {
        double[] min = Rn.copy(null, tris[start].getVertices()[0]);
        double[] max = Rn.copy(null, min);
        for (int i = start; i <= end; ++i) {
            double[][] points = tris[i].getVertices();
            for (int j = 0; j < points.length; ++j) {
                double[] point = points[j];
                if (point[0] < min[0]) {
                    min[0] = point[0];
                } else if (point[0] > max[0]) {
                    max[0] = point[0];
                }
                if (point[1] < min[1]) {
                    min[1] = point[1];
                } else if (point[1] > max[1]) {
                    max[1] = point[1];
                }
                if (point[2] < min[2]) {
                    min[2] = point[2];
                    continue;
                }
                if (!(point[2] > max[2])) continue;
                max[2] = point[2];
            }
        }
        Rn.times(this.center, 0.5, Rn.add(this.center, min, max));
        Rn.setToValue(this.extent, max[0] - this.center[0], max[1] - this.center[1], max[2] - this.center[2]);
    }

    boolean intersects(double[] from, double[] dir) {
        double[] diff = Rn.subtract(null, from, this.center);
        if (Math.abs(diff[0]) > this.extent[0] && diff[0] * dir[0] >= 0.0) {
            return false;
        }
        if (Math.abs(diff[1]) > this.extent[1] && diff[1] * dir[1] >= 0.0) {
            return false;
        }
        if (Math.abs(diff[2]) > this.extent[2] && diff[2] * dir[2] >= 0.0) {
            return false;
        }
        this.tmpVec1[0] = Math.abs(dir[0]);
        this.tmpVec1[1] = Math.abs(dir[1]);
        this.tmpVec1[2] = Math.abs(dir[2]);
        double[] wCrossD = Rn.crossProduct(null, dir, diff);
        this.tmpVec2[0] = Math.abs(Rn.innerProduct(wCrossD, X));
        double rhs = this.extent[1] * this.tmpVec1[2] + this.extent[2] * this.tmpVec1[1];
        if (this.tmpVec2[0] > rhs) {
            return false;
        }
        this.tmpVec2[1] = Math.abs(Rn.innerProduct(wCrossD, Y));
        rhs = this.extent[0] * this.tmpVec1[2] + this.extent[2] * this.tmpVec1[0];
        if (this.tmpVec2[1] > rhs) {
            return false;
        }
        this.tmpVec2[2] = Math.abs(Rn.innerProduct(wCrossD, Z));
        rhs = this.extent[0] * this.tmpVec1[1] + this.extent[1] * this.tmpVec1[0];
        return !(this.tmpVec2[2] > rhs);
    }
}

