/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;

public abstract class StringArrayArray
extends DataList {
    private final transient int offset;
    private final transient int length;
    private final transient StringArray[] arrays;

    StringArrayArray(StorageModel sm, Object data) {
        this(sm, data, 0, sm.getLength(data));
    }

    StringArrayArray(StorageModel sm, Object data, int first, int num) {
        super(sm, data, first, num);
        this.offset = first;
        this.length = num;
        this.arrays = new StringArray[this.length];
    }

    public abstract String getValueAt(int var1, int var2);

    public final int getLength() {
        return ((DataList)this).length;
    }

    public abstract int getLengthAt(int var1);

    public abstract StringArray getValueAt(int var1);

    public final StringArrayArray toStringArrayArray() {
        return this;
    }

    public String[][] toStringArrayArray(String[][] target) {
        if (target == null) {
            target = new String[this.getLength()][];
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            String[] slot = target[i];
            int slotlen = this.getLengthAt(i);
            if (slot == null) {
                target[i] = new String[slotlen];
                slot = target[i];
            }
            for (int j = 0; j < slotlen; ++j) {
                slot[j] = this.getValueAt(i, j);
            }
        }
        return target;
    }

    public static final class Inlined
    extends StringArrayArray {
        private transient StringArray daView;
        private final transient String[] data;
        private final transient int entryLength;

        public Inlined(String[] initialData, int numPerEntry) {
            this(initialData, numPerEntry, 0, initialData.length / numPerEntry);
        }

        public Inlined(String[] initialData, int numPerEntry, int firstEntry, int numEntries) {
            super(StorageModel.STRING_ARRAY.inlined(numPerEntry), initialData, firstEntry, numEntries);
            this.data = initialData;
            if (numPerEntry < 1) {
                throw new IllegalArgumentException("numPerEntry=" + numPerEntry);
            }
            this.entryLength = numPerEntry;
        }

        public StringArray toStringArray() {
            return this.daView != null ? this.daView : (this.daView = new StringArray(this.data, ((StringArrayArray)this).offset * this.entryLength, ((StringArrayArray)this).length * this.entryLength));
        }

        public int getLengthAt(int n) {
            return this.entryLength;
        }

        public String getValueAt(int n, int i) {
            return this.data[(n + ((StringArrayArray)this).offset) * this.entryLength + i];
        }

        public StringArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private StringArray subArray(int ix) {
            StringArray sarr = ((StringArrayArray)this).arrays[ix];
            return sarr != null ? sarr : (((StringArrayArray)this).arrays[ix] = new StringArray(this.data, (ix + ((StringArrayArray)this).offset) * this.entryLength, this.entryLength));
        }
    }

    public static final class Array
    extends StringArrayArray {
        private final transient String[][] data;

        public Array(String[][] data) {
            super(StorageModel.STRING_ARRAY_ARRAY, data, 0, data.length);
            this.data = data;
        }

        public String getValueAt(int n, int i) {
            return this.data[n][i];
        }

        public int getLengthAt(int n) {
            return this.data[n].length;
        }

        public StringArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private StringArray subArray(int index) {
            StringArray sarr = ((StringArrayArray)this).arrays[index];
            if (sarr != null && sarr.data == this.data[index]) {
                return sarr;
            }
            StringArray stringArray = new StringArray(this.data[index]);
            ((StringArrayArray)this).arrays[index] = stringArray;
            return stringArray;
        }
    }
}

