/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.StorageModel;

public abstract class IntArrayArray
extends DataList {
    private final transient int offset;
    private final transient int length;
    private final transient IntArray[] arrays;

    IntArrayArray(StorageModel sm, Object data) {
        this(sm, data, 0, sm.getLength(data));
    }

    IntArrayArray(StorageModel sm, Object data, int first, int num) {
        super(sm, data, first, num);
        this.offset = first;
        this.length = num;
        this.arrays = new IntArray[this.length];
    }

    public abstract int getValueAt(int var1, int var2);

    public final int getLength() {
        return ((DataList)this).length;
    }

    public abstract int getLengthAt(int var1);

    public abstract IntArray getValueAt(int var1);

    public final IntArrayArray toIntArrayArray() {
        return this;
    }

    public int[][] toIntArrayArray(int[][] target) {
        if (target == null) {
            target = new int[this.getLength()][];
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            int[] slot = target[i];
            int slotlen = this.getLengthAt(i);
            if (slot == null) {
                target[i] = new int[slotlen];
                slot = target[i];
            }
            for (int j = 0; j < slotlen; ++j) {
                slot[j] = this.getValueAt(i, j);
            }
        }
        return target;
    }

    public static final class Inlined
    extends IntArrayArray {
        private transient IntArray daView;
        private final transient int[] data;
        private final transient int entryLength;

        public Inlined(int[] initialData, int numPerEntry) {
            this(initialData, numPerEntry, 0, initialData.length / numPerEntry);
        }

        public Inlined(int[] initialData, int numPerEntry, int firstEntry, int numEntries) {
            super(StorageModel.INT_ARRAY.inlined(numPerEntry), initialData, firstEntry, numEntries);
            this.data = initialData;
            if (numPerEntry < 1) {
                throw new IllegalArgumentException("numPerEntry=" + numPerEntry);
            }
            this.entryLength = numPerEntry;
        }

        public IntArray toIntArray() {
            return this.daView != null ? this.daView : (this.daView = new IntArray(this.data, ((IntArrayArray)this).offset * this.entryLength, ((IntArrayArray)this).length * this.entryLength));
        }

        public int getLengthAt(int n) {
            return this.entryLength;
        }

        public int getValueAt(int n, int i) {
            return this.data[(n + ((IntArrayArray)this).offset) * this.entryLength + i];
        }

        public IntArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private IntArray subArray(int ix) {
            IntArray sarr = ((IntArrayArray)this).arrays[ix];
            return sarr != null ? sarr : (((IntArrayArray)this).arrays[ix] = new IntArray(this.data, (ix + ((IntArrayArray)this).offset) * this.entryLength, this.entryLength));
        }
    }

    public static final class Array
    extends IntArrayArray {
        private final transient int[][] data;

        public Array(int[][] data) {
            super(StorageModel.INT_ARRAY_ARRAY, data, 0, data.length);
            this.data = data;
        }

        public Array(int[][] data, int numPerEntry) {
            super(StorageModel.INT_ARRAY.array(numPerEntry), data);
            this.data = data;
        }

        public int getValueAt(int n, int i) {
            return this.data[n][i];
        }

        public int getLengthAt(int n) {
            return this.data[n].length;
        }

        public IntArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private IntArray subArray(int index) {
            IntArray sarr = ((IntArrayArray)this).arrays[index];
            if (sarr != null && sarr.data == this.data[index]) {
                return sarr;
            }
            IntArray intArray = new IntArray(this.data[index]);
            ((IntArrayArray)this).arrays[index] = intArray;
            return intArray;
        }
    }
}

