/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class IntArray
extends DataList {
    final transient int[] data;
    final transient int offset;
    final transient int length;

    public IntArray(int[] data) {
        this(data, 0, data.length);
    }

    public IntArray(int[] data, int offset, int length) {
        super(StorageModel.INT_ARRAY, data, offset, length);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public IntArray toIntArray() {
        return this;
    }

    public final int[] toIntArray(int[] target) {
        if (target == null) {
            target = new int[this.length];
        }
        int src = this.offset;
        int n = this.length;
        for (int dst = 0; dst < n; ++dst) {
            target[dst] = this.data[src];
            ++src;
        }
        return target;
    }

    public final ByteBuffer toNativeByteBuffer(ByteBuffer bb) {
        if (bb == null) {
            bb = ByteBuffer.allocateDirect(this.length * 4).order(ByteOrder.nativeOrder());
        }
        IntBuffer target = bb.asIntBuffer();
        target.put(this.data, this.offset, this.length);
        return bb;
    }

    public final double[] toDoubleArray(double[] target) {
        if (target == null) {
            target = new double[this.length];
        }
        int src = this.offset;
        int n = this.length;
        for (int dst = 0; dst < n; ++dst) {
            target[dst] = this.data[src];
            ++src;
        }
        return target;
    }

    public final int getValueAt(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n + this.offset];
    }

    public final int getLength() {
        return this.length;
    }
}

