/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.StorageModel;
import java.io.ObjectStreamException;

class DoubleArrayStorage
extends StorageModel {
    DoubleArrayStorage() {
        super("double[]");
    }

    public Object getAsObject(Object data, int index) {
        double[] d = (double[])data;
        double[] r = new double[]{d[index]};
        return r;
    }

    public int getLength(Object data) {
        return ((double[])data).length;
    }

    public void setAsObject(Object data, int index, Object value) {
        double v = value instanceof Number ? ((Number)value).doubleValue() : ((double[])value)[0];
        double[] d = (double[])data;
        d[index] = v;
    }

    public int getNumberOfDimensions() {
        return 1;
    }

    public int[] getDimensions(int[] dim, int d) {
        return dim;
    }

    public boolean isArray() {
        return true;
    }

    public StorageModel getComponentModel() {
        return StorageModel.Primitive.DOUBLE;
    }

    public Object create(int size) {
        return new double[size];
    }

    public DoubleArray toDoubleArray(Object data) {
        return new DoubleArray((double[])data);
    }

    void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
        double[] source = (double[])from;
        if (toFmt == this) {
            double[] target = (double[])to;
            int src = srcOff;
            for (int dst = 0; dst < len; ++dst) {
                target[dst + dstOff] = source[src];
                ++src;
            }
        } else {
            super.copy(from, srcOff, toFmt, to, dstOff, len);
        }
    }

    public void toStringImpl(Object data, int index, StringBuffer target) {
        double[] d = (double[])data;
        target.append(d[index]);
    }

    public DataList createReadOnly(Object data, int off, int len) {
        return new DoubleArray((double[])data, off, len);
    }

    public DataItem item(Object data, int i) {
        final double[] darray = (double[])data;
        return new DataItem(data, i){

            public StorageModel getStorageModel() {
                return StorageModel.Primitive.DOUBLE;
            }

            public Object get(int arg0) {
                return new Double(darray[this.offset]);
            }

            public int size() {
                return 1;
            }
        };
    }

    public StorageModel inlined(int numPerEntry) {
        if (numPerEntry < 1) {
            throw new IllegalArgumentException();
        }
        if (this.inlined != null && this.inlined.length > numPerEntry && this.inlined[numPerEntry] != null) {
            return this.inlined[numPerEntry];
        }
        return new StorageModel.DAI(numPerEntry);
    }

    public StorageModel array(int numPerEntry) {
        if (this.arrayof != null && this.arrayof.length > numPerEntry && this.arrayof[numPerEntry] != null) {
            return this.arrayof[numPerEntry];
        }
        return new StorageModel.DAA(numPerEntry);
    }

    public StorageModel array() {
        StorageModel sm = this.arrayof != null ? this.arrayof[0] : null;
        return sm != null ? sm : new StorageModel.DAA();
    }

    Object readResolve() throws ObjectStreamException {
        return StorageModel.DOUBLE_ARRAY;
    }
}

