/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.WritableDataList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.IdentityHashMap;

public class DataList
extends DataItem
implements Serializable {
    final StorageModel format;
    final int length;
    static final ThreadLocal pendingIO = new ThreadLocal();

    DataList(StorageModel sm, Object list) {
        this(sm, list, 0, sm.getLength(list));
    }

    DataList(StorageModel sm, Object list, int off, int len) {
        super(list, off);
        if (sm == null) {
            throw new NullPointerException();
        }
        this.format = sm;
        this.length = len;
    }

    public StorageModel getStorageModel() {
        return this.format;
    }

    public Object get(int index) {
        return this.item(index);
    }

    public DataItem item(int index) {
        return this.format.item(this.data, index + this.offset);
    }

    public int size() {
        return this.length;
    }

    public IntArray toIntArray() {
        return this.format.toIntArray(this.data);
    }

    public IntArrayArray toIntArrayArray() {
        return this.format.toIntArrayArray(this.data);
    }

    public DoubleArray toDoubleArray() {
        return this.format.toDoubleArray(this.data);
    }

    public DoubleArrayArray toDoubleArrayArray() {
        return this.format.toDoubleArrayArray(this.data);
    }

    public DataList readOnlyList() {
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('[');
        sb.append("len=").append(this.length).append(" storage=").append(this.format);
        sb.append(']');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.format);
        this.format.exportData(out, this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        StorageModel sm = (StorageModel)in.readObject();
        Object data = sm.importData(in);
        WritableDataList wdl = sm.createWritableDataList(data);
        DataList dl = this instanceof WritableDataList ? wdl : wdl.readOnlyList();
        IdentityHashMap<DataList, WritableDataList> map = (IdentityHashMap<DataList, WritableDataList>)pendingIO.get();
        if (map == null) {
            map = new IdentityHashMap<DataList, WritableDataList>();
            pendingIO.set(map);
        }
        map.put(this, (WritableDataList)dl);
    }

    final Object readResolve() throws ObjectStreamException {
        IdentityHashMap map = (IdentityHashMap)pendingIO.get();
        return map.remove(this);
    }

    public double[] getSrcDbl() {
        return null;
    }
}

