/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.Appearance;
import de.jreality.scene.data.AttributeCollection;
import de.jreality.scene.data.AttributeEntity;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.LoggingSystem;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;

public class AttributeEntityUtility {
    private static Method equals;
    private static Method hashCode;
    private static Method toString;
    private static final HashMap<Class, PropertyDescriptor[]> descriptors;
    private static final HashMap<Class, HashMap<String, PropertyDescriptor>> properties;
    private static final HashMap<Class, HashMap<Method, PropertyDescriptor>> readers;
    private static final HashMap<Class, HashMap<Method, PropertyDescriptor>> writers;
    private static final HashMap<Class, Constructor<?>> proxyConstructors;
    private static HashMap<Class, HashMap<Method, PropertyDescriptor>> subEntityReaders;
    private static HashMap<Class, HashMap<Method, PropertyDescriptor>> subEntityCreators;

    public static AttributeEntity createAttributeEntity(Class clazz, String prefix, Appearance a, boolean readDefaults) {
        AttributeEntity proxy = AttributeEntityUtility.getAttributeEntity(clazz, prefix, a, readDefaults);
        if (!AttributeEntityUtility.hasAttributeEntity(clazz, prefix, a)) {
            a.setAttribute(AttributeEntityUtility.getTaggingPrefix(prefix, clazz), clazz);
        }
        return proxy;
    }

    public static AttributeEntity getAttributeEntity(Class clazz, String prefix, Appearance a, boolean readDefaults) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            AttributeEntity proxy = (AttributeEntity)AttributeEntityUtility.createProxy(clazz, prefix, a, readDefaults);
            return proxy;
        }
        catch (IntrospectionException e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
    }

    public static AttributeEntity createAttributeEntity(Class clazz, String prefix, EffectiveAppearance ea) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            if (!AttributeEntityUtility.hasAttributeEntity(clazz, prefix, ea)) {
                throw new IllegalStateException("no such entity");
            }
            AttributeEntity proxy = (AttributeEntity)AttributeEntityUtility.createProxy(AttributeEntityUtility.resolveType(clazz), prefix, ea, true);
            return proxy;
        }
        catch (IntrospectionException e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
    }

    private static Class resolveType(Class clazz) {
        try {
            Field f = clazz.getDeclaredField("DEFAULT_ENTITY");
            return (Class)f.get(null);
        }
        catch (NoSuchFieldException nfe) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return clazz;
    }

    public static boolean hasAttributeEntity(Class clazz, String prefix, EffectiveAppearance eap) {
        if (AttributeEntityUtility.hasAssignedAttributeEntity(clazz, prefix, eap)) {
            return true;
        }
        try {
            Field f = clazz.getField("DEFAULT_ENTITY");
            Class def = (Class)f.get(null);
            if (clazz == def || f.getDeclaringClass() == clazz) {
                return true;
            }
        }
        catch (NoSuchFieldException nfe) {
        }
        catch (IllegalAccessException e) {
            LoggingSystem.getLogger(AttributeEntityUtility.class).warning("error in default type declaration!");
        }
        return false;
    }

    public static boolean hasAttributeEntity(Class clazz, String prefix, Appearance a) {
        return a.getAttribute(AttributeEntityUtility.getTaggingPrefix(prefix, clazz), Class.class) instanceof Class && clazz.isAssignableFrom((Class)a.getAttribute(AttributeEntityUtility.getTaggingPrefix(prefix, clazz), Class.class));
    }

    private static boolean hasAssignedAttributeEntity(Class clazz, String prefix, EffectiveAppearance ea) {
        return clazz.isAssignableFrom((Class)ea.getAttribute(AttributeEntityUtility.getTaggingPrefix(prefix, clazz), Object.class, Class.class));
    }

    private static String getTaggingPrefix(String prefix, Class clazz) {
        if (prefix == null || prefix.equals("")) {
            return "<" + clazz.getName() + ">";
        }
        return prefix;
    }

    private static Object createProxy(Class clazz, String prefix, Object target, boolean readDefaults) throws IntrospectionException {
        if (!descriptors.containsKey(clazz)) {
            LoggingSystem.getLogger(AttributeEntityUtility.class).log(Level.INFO, "creating reader {0} with prefix {1}", new Object[]{clazz, prefix});
            HashMap<String, PropertyDescriptor> prop = new HashMap<String, PropertyDescriptor>();
            HashMap<Method, PropertyDescriptor> reader = new HashMap<Method, PropertyDescriptor>();
            HashMap<Method, PropertyDescriptor> writer = new HashMap<Method, PropertyDescriptor>();
            HashMap<Method, PropertyDescriptor> subEntityReader = new HashMap<Method, PropertyDescriptor>();
            HashMap<Method, PropertyDescriptor> subEntityWriter = new HashMap<Method, PropertyDescriptor>();
            HashSet<PropertyDescriptor> pds = new HashSet<PropertyDescriptor>();
            BeanInfo bi = Introspector.getBeanInfo(clazz, 3);
            pds.addAll(Arrays.asList(bi.getPropertyDescriptors()));
            for (Class<?> type : clazz.getInterfaces()) {
                bi = Introspector.getBeanInfo(type, 3);
                pds.addAll(Arrays.asList(bi.getPropertyDescriptors()));
            }
            for (PropertyDescriptor descriptor : pds) {
                String attrName = descriptor.getName();
                if (prop.put(attrName, descriptor) != null) {
                    throw new IllegalArgumentException("conflicts on property \"" + attrName + '\"');
                }
                if (AttributeEntity.class.isAssignableFrom(descriptor.getPropertyType())) {
                    String subEntityName = Character.toUpperCase(attrName.charAt(0)) + attrName.substring(1);
                    String createMethodName = "create" + subEntityName;
                    Method creator = null;
                    try {
                        creator = clazz.getMethod(createMethodName, String.class);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            creator = clazz.getMethod(createMethodName, new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                    }
                    subEntityReader.put(descriptor.getReadMethod(), descriptor);
                    if (creator != null) {
                        subEntityWriter.put(creator, descriptor);
                    }
                    Class defaultClass = AttributeEntityUtility.resolveType(descriptor.getPropertyType());
                    descriptor.setValue("default", defaultClass);
                    continue;
                }
                reader.put(descriptor.getReadMethod(), descriptor);
                writer.put(descriptor.getWriteMethod(), descriptor);
                try {
                    descriptor.setValue("default", clazz.getField(AttributeEntityUtility.defaultFieldName(attrName)));
                }
                catch (NoSuchFieldException e) {
                    Level level;
                    Class<?> type = descriptor.getPropertyType();
                    int dim = 0;
                    Level level2 = level = type.isPrimitive() ? Level.WARNING : Level.INFO;
                    while (type.isArray()) {
                        type = type.getComponentType();
                        ++dim;
                    }
                    String typeName = type.getName();
                    for (int i = 0; i < dim; ++i) {
                        typeName = typeName + "[]";
                    }
                    LoggingSystem.getLogger(AttributeEntityUtility.class).log(level, "no default value for primitive attribute {0}.\npublic static final {1} {2} = <defaultValue>;", new Object[]{attrName, typeName, AttributeEntityUtility.defaultFieldName(attrName)});
                }
            }
            Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
            descriptors.put(clazz, pds.toArray(new PropertyDescriptor[pds.size()]));
            properties.put(clazz, prop);
            readers.put(clazz, reader);
            writers.put(clazz, writer);
            subEntityReaders.put(clazz, subEntityReader);
            subEntityCreators.put(clazz, subEntityWriter);
            try {
                proxyConstructors.put(clazz, proxyClass.getConstructor(InvocationHandler.class));
            }
            catch (NoSuchMethodException e) {
                throw new Error();
            }
        }
        Handler h = new Handler(clazz, descriptors.get(clazz), prefix, readers.get(clazz), writers.get(clazz), subEntityReaders.get(clazz), subEntityCreators.get(clazz), target, readDefaults);
        try {
            return proxyConstructors.get(clazz).newInstance(h);
        }
        catch (Exception e) {
            e.printStackTrace();
            IllegalStateException ie = new IllegalStateException(e.getMessage());
            ie.initCause(e.getCause());
            throw ie;
        }
    }

    private static String defaultFieldName(String attrName) {
        return attrName.replaceAll("([\\p{Ll},\\p{N}]+)([\\p{Lu}]{1})", "$1_$2").toUpperCase() + "_DEFAULT";
    }

    private static Class wrapperType(Class attrType) {
        switch (attrType.getName().charAt(0)) {
            case 'd': {
                return Double.class;
            }
            case 'i': {
                return Integer.class;
            }
            case 'b': {
                return attrType == Boolean.TYPE ? Boolean.class : Byte.class;
            }
            case 'c': {
                return Character.class;
            }
            case 's': {
                return Short.class;
            }
            case 'l': {
                return Long.class;
            }
            case 'f': {
                return Float.class;
            }
        }
        throw new IllegalArgumentException(attrType.toString());
    }

    private AttributeEntityUtility() {
    }

    static {
        descriptors = new HashMap();
        properties = new HashMap();
        readers = new HashMap();
        writers = new HashMap();
        proxyConstructors = new HashMap();
        subEntityReaders = new HashMap();
        subEntityCreators = new HashMap();
        try {
            try {
                hashCode = Object.class.getMethod("hashCode", new Class[0]);
                equals = Object.class.getMethod("equals", Object.class);
                toString = Object.class.getMethod("toString", new Class[0]);
            }
            catch (SecurityException se) {}
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    implements InvocationHandler {
        private final Appearance app;
        private final EffectiveAppearance effApp;
        private final String ifClassName;
        private final String prefix;
        private final HashMap<Method, PropertyDescriptor> readMethod;
        private final HashMap<Method, PropertyDescriptor> writeMethod;
        private final HashMap<Method, PropertyDescriptor> subReader;
        private final HashMap<Method, PropertyDescriptor> subCreator;
        private final PropertyDescriptor[] properties;
        private final boolean readDefaults;
        private final String seperator;

        Handler(Class ifClass, PropertyDescriptor[] pd, String prefix, HashMap<Method, PropertyDescriptor> reader, HashMap<Method, PropertyDescriptor> writer, HashMap<Method, PropertyDescriptor> subReader, HashMap<Method, PropertyDescriptor> subCreator, Object target, boolean readDefaults) {
            this.ifClassName = ifClass.getName();
            this.properties = pd;
            this.seperator = AttributeCollection.class.isAssignableFrom(ifClass) ? "." : ":";
            this.prefix = prefix == null || prefix.length() == 0 ? "" : prefix + this.seperator;
            this.readMethod = reader;
            this.writeMethod = writer;
            this.subReader = subReader;
            this.subCreator = subCreator;
            this.readDefaults = readDefaults;
            if (target instanceof EffectiveAppearance) {
                this.effApp = (EffectiveAppearance)target;
                this.app = null;
            } else {
                this.app = (Appearance)target;
                this.effApp = null;
            }
        }

        private Object getAttribute(PropertyDescriptor pd, Object proxy) throws IllegalAccessException {
            Object defValue;
            Object result = Appearance.INHERITED;
            String attrName = pd.getName();
            Class<?> attrType = pd.getPropertyType();
            if (AttributeEntity.class.isAssignableFrom(attrType)) {
                attrType = Class.class;
            }
            if (attrType.isPrimitive()) {
                attrType = AttributeEntityUtility.wrapperType(attrType);
            }
            if ((result = this.app != null ? this.app.getAttribute(this.prefix + attrName, attrType) : this.effApp.getAttribute(this.prefix + attrName, Appearance.INHERITED)) != Appearance.INHERITED && result != Appearance.DEFAULT) {
                return result;
            }
            if (!this.readDefaults) {
                return null;
            }
            Object defaultVal = pd.getValue("default");
            if (defaultVal instanceof Class) {
                return defaultVal;
            }
            Field f = (Field)defaultVal;
            if (f != null) {
                defValue = f.get(proxy);
            } else {
                if (attrType.isPrimitive()) {
                    throw new IllegalStateException(MessageFormat.format("no default value for primitive attribute {0}.\npublic static final {1} {2} = <defaultValue>;", attrName, attrType, AttributeEntityUtility.defaultFieldName(attrName)));
                }
                defValue = null;
            }
            result = this.effApp != null ? this.effApp.getAttribute(this.prefix + attrName, defValue, attrType) : defValue;
            return result;
        }

        private Object getSubEntityAttribute(PropertyDescriptor pd, Object proxy) throws IllegalAccessException {
            Object result = Appearance.INHERITED;
            String attrName = pd.getName();
            Class<Class> attrType = Class.class;
            if (this.app != null) {
                result = this.app.getAttribute(this.prefix + attrName, attrType);
            }
            if (result == Appearance.INHERITED && this.effApp != null) {
                result = this.effApp.getAttribute(this.prefix + attrName, result, attrType);
            }
            if (result != Appearance.INHERITED && result != Appearance.DEFAULT) {
                return result;
            }
            Object defaultVal = pd.getValue("default");
            if (defaultVal instanceof Class) {
                try {
                    Field f = ((Class)defaultVal).getDeclaredField("CREATE_DEFAULT");
                    return defaultVal;
                }
                catch (NoSuchFieldException nfe) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            PropertyDescriptor pd = this.readMethod.get(method);
            if (pd != null) {
                Object ret = this.getAttribute(pd, proxy);
                return ret;
            }
            pd = this.writeMethod.get(method);
            if (pd != null) {
                if (this.app == null) {
                    throw new IllegalStateException("writing not allowed");
                }
                String attrName = pd.getName();
                Class<?> attrType = pd.getPropertyType();
                if (attrType.isPrimitive()) {
                    attrType = args[0].getClass();
                }
                Object arg = args[0] == null ? Appearance.INHERITED : args[0];
                this.app.setAttribute(this.prefix + attrName, arg, attrType);
                return null;
            }
            pd = this.subReader.get(method);
            if (pd != null) {
                return this.subEntity(pd, proxy);
            }
            if (this.app != null && (pd = this.subCreator.get(method)) != null) {
                String attrName = pd.getName();
                Class type = args == null || args.length == 0 ? pd.getPropertyType() : ShaderUtility.resolveEntity(pd.getPropertyType(), (String)args[0]);
                this.app.setAttribute(this.prefix + attrName, type, Class.class);
                return this.subEntity(pd, proxy);
            }
            if (this.isHashCode(method)) {
                return new Integer(this.hashCode());
            }
            if (this.isEquals(method)) {
                return args[0] == proxy;
            }
            if (this.isToString(method)) {
                return this.toString(proxy);
            }
            throw new IllegalStateException("unhandled method " + method + "app==null ? " + (this.app == null));
        }

        private Object subEntity(PropertyDescriptor pd, Object proxy) throws IllegalAccessException {
            Class type = (Class)this.getSubEntityAttribute(pd, proxy);
            if (type == null) {
                return null;
            }
            String pref = this.prefix + pd.getName();
            if (this.app != null) {
                return AttributeEntityUtility.getAttributeEntity(type, pref, this.app, this.readDefaults);
            }
            if (AttributeEntityUtility.hasAttributeEntity(type, pref, this.effApp)) {
                try {
                    return AttributeEntityUtility.createProxy(AttributeEntityUtility.resolveType(type), pref, this.effApp, true);
                }
                catch (IntrospectionException e) {
                    throw new Error();
                }
            }
            return null;
        }

        private boolean isHashCode(Method method) {
            if (hashCode != null) {
                return method.equals(hashCode);
            }
            return method.getName() == "hashCode" && method.getDeclaringClass() == Object.class;
        }

        private boolean isEquals(Method method) {
            if (equals != null) {
                return method.equals(equals);
            }
            return method.getName() == "equals" && method.getDeclaringClass() == Object.class;
        }

        private boolean isToString(Method method) {
            if (toString != null) {
                return method.equals(toString);
            }
            return method.getName() == "toString" && method.getDeclaringClass() == Object.class;
        }

        String toString(Object proxy) {
            StringBuffer sb = new StringBuffer(2000);
            sb.append(this.ifClassName).append('[');
            sb.append("prefix = ").append(this.prefix);
            if (this.properties.length == 0) {
                return sb.append(" ]").toString();
            }
            sb.append(", ");
            int linePos = sb.length();
            for (int ix = 0; ix < this.properties.length; ++ix) {
                PropertyDescriptor pd = this.properties[ix];
                int insPos = sb.length();
                sb.append(' ').append(pd.getDisplayName()).append(" = ");
                try {
                    sb.append(this.getAttribute(pd, proxy));
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                sb.append(", ");
                if ((linePos += sb.length() - insPos) <= 60) continue;
                sb.setCharAt(sb.length() - 1, '\n');
                linePos = 0;
            }
            sb.setCharAt(sb.length() - 2, ' ');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }
    }
}

