/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public class Attribute
implements Serializable {
    private static final HashMap<String, Attribute> KNOWN_ATTRIBUTES = new HashMap();
    public static final Attribute COORDINATES = Attribute.attributeForName("coordinates");
    public static final Attribute NORMALS = Attribute.attributeForName("normals");
    public static final Attribute COLORS = Attribute.attributeForName("colors");
    public static final Attribute INDICES = Attribute.attributeForName("indices");
    public static final Attribute TEXTURE_COORDINATES = Attribute.attributeForName("texture coordinates");
    public static final Attribute POINT_SIZE = Attribute.attributeForName("pointSize");
    public static final Attribute RELATIVE_RADII = Attribute.attributeForName("relativeRadii");
    public static final Attribute LABELS = Attribute.attributeForName("labels");
    private final String attrName;

    public static Attribute attributeForName(String name) {
        Attribute aa = KNOWN_ATTRIBUTES.get(name);
        if (aa != null) {
            return aa;
        }
        aa = new Attribute(name);
        KNOWN_ATTRIBUTES.put(name, aa);
        return aa;
    }

    private Attribute(String name) {
        this.attrName = name;
    }

    public String getName() {
        return this.attrName;
    }

    public String toString() {
        return this.attrName;
    }

    Object readResolve() throws ObjectStreamException {
        return Attribute.attributeForName(this.getName());
    }
}

