/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationEventMulticaster;
import de.jreality.scene.event.TransformationListener;

public class Transformation
extends SceneGraphNode {
    private transient TransformationListener transformationListener;
    protected double[] theMatrix;
    private transient boolean matrixChanged;
    private static int UNNAMED_ID;

    public Transformation(String name, double[] m) {
        super(name);
        this.theMatrix = m == null ? Rn.identityMatrix(4) : (double[])m.clone();
    }

    public Transformation(double[] matrix) {
        this("trafo " + UNNAMED_ID++, matrix);
    }

    public Transformation(String name) {
        this(name, null);
    }

    public Transformation() {
        this((double[])null);
    }

    public Transformation(Transformation t) {
        this(t.theMatrix);
    }

    public double[] getMatrix() {
        return this.getMatrix(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getMatrix(double[] aMatrix) {
        this.startReader();
        try {
            if (aMatrix != null && aMatrix.length != 16) {
                throw new IllegalArgumentException("lenght != 16");
            }
            if (aMatrix == null) {
                aMatrix = new double[16];
            }
            System.arraycopy(this.theMatrix, 0, aMatrix, 0, 16);
            double[] dArray = aMatrix;
            return dArray;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatrix(double[] aMatrix) {
        this.checkReadOnly();
        this.startWriter();
        try {
            System.arraycopy(aMatrix, 0, this.theMatrix, 0, aMatrix.length);
            this.fireTransformationChanged();
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplyOnRight(double[] T) {
        this.startWriter();
        try {
            Rn.times(this.theMatrix, this.theMatrix, T);
            this.fireTransformationChanged();
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplyOnLeft(double[] T) {
        this.startWriter();
        try {
            Rn.times(this.theMatrix, T, this.theMatrix);
            this.fireTransformationChanged();
        }
        finally {
            this.finishWriter();
        }
    }

    public void addTransformationListener(TransformationListener listener) {
        this.startReader();
        this.transformationListener = TransformationEventMulticaster.add(this.transformationListener, listener);
        this.finishReader();
    }

    public void removeTransformationListener(TransformationListener listener) {
        this.startReader();
        this.transformationListener = TransformationEventMulticaster.remove(this.transformationListener, listener);
        this.finishReader();
    }

    protected void writingFinished() {
        if (this.matrixChanged && this.transformationListener != null) {
            this.transformationListener.transformationMatrixChanged(new TransformationEvent(this));
        }
        this.matrixChanged = false;
    }

    protected void fireTransformationChanged() {
        this.matrixChanged = true;
    }

    public static void superAccept(Transformation t, SceneGraphVisitor visitor) {
        t.superAccept(visitor);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }
}

