/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceEventMulticaster;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationEventMulticaster;
import de.jreality.scene.event.TransformationListener;
import java.util.ListIterator;

public class SceneGraphPathObserver
implements AppearanceListener,
TransformationListener,
SceneGraphComponentListener {
    SceneGraphPath currentPath;
    private TransformationListener transformationListener;
    private AppearanceListener appearanceListener;
    private double[] matrixData = new double[16];
    private double[] oldMatrix = new double[16];

    public SceneGraphPathObserver() {
        this.currentPath = new SceneGraphPath();
    }

    public SceneGraphPathObserver(SceneGraphPath path) {
        this.currentPath = new SceneGraphPath(path);
        this.addListeners();
    }

    public void setPath(SceneGraphPath newPath) {
        this.removeListeners();
        if (newPath != null) {
            this.currentPath = new SceneGraphPath(newPath);
        } else {
            this.currentPath.clear();
        }
        this.addListeners();
        this.calculateCurrentMatrix();
    }

    private void calculateCurrentMatrix() {
        this.currentPath.getMatrix(this.oldMatrix);
    }

    private boolean hasChanged() {
        return !Rn.equals(this.oldMatrix, this.matrixData);
    }

    public void dispose() {
        this.removeListeners();
        this.currentPath.clear();
    }

    private void addListeners() {
        ListIterator<SceneGraphNode> i = this.currentPath.iterator();
        while (i.hasNext()) {
            Appearance app;
            Object node = i.next();
            if (!(node instanceof SceneGraphComponent)) continue;
            SceneGraphComponent component = (SceneGraphComponent)node;
            component.addSceneGraphComponentListener(this);
            Transformation trafo = component.getTransformation();
            if (trafo != null) {
                trafo.addTransformationListener(this);
            }
            if ((app = component.getAppearance()) == null) continue;
            app.addAppearanceListener(this);
        }
    }

    private void removeListeners() {
        ListIterator<SceneGraphNode> i = this.currentPath.iterator();
        while (i.hasNext()) {
            Appearance app;
            Object node = i.next();
            if (!(node instanceof SceneGraphComponent)) continue;
            SceneGraphComponent component = (SceneGraphComponent)node;
            component.removeSceneGraphComponentListener(this);
            Transformation trafo = component.getTransformation();
            if (trafo != null) {
                trafo.removeTransformationListener(this);
            }
            if ((app = component.getAppearance()) == null) continue;
            app.removeAppearanceListener(this);
        }
    }

    public void addTransformationListener(TransformationListener listener) {
        this.transformationListener = TransformationEventMulticaster.add(this.transformationListener, listener);
    }

    public void removeTransformationListener(TransformationListener listener) {
        this.transformationListener = TransformationEventMulticaster.remove(this.transformationListener, listener);
    }

    public void addAppearanceListener(AppearanceListener listener) {
        this.appearanceListener = AppearanceEventMulticaster.add(this.appearanceListener, listener);
    }

    public void removeAppearanceListener(AppearanceListener listener) {
        this.appearanceListener = AppearanceEventMulticaster.remove(this.appearanceListener, listener);
    }

    protected void fireTransformationChanged() {
        TransformationListener l = this.transformationListener;
        if (l != null) {
            this.currentPath.getMatrix(this.matrixData);
            if (this.hasChanged()) {
                System.arraycopy(this.matrixData, 0, this.oldMatrix, 0, 16);
                l.transformationMatrixChanged(new TransformationEvent(new Transformation(this.matrixData)));
            }
        }
    }

    protected void fireAppearanceChanged() {
        AppearanceListener l = this.appearanceListener;
        if (l != null) {
            l.appearanceChanged(new AppearanceEvent(new Appearance(), null, null));
        }
    }

    public void appearanceChanged(AppearanceEvent ev) {
        this.fireAppearanceChanged();
    }

    public void transformationMatrixChanged(TransformationEvent ev) {
        this.fireTransformationChanged();
    }

    public void childAdded(SceneGraphComponentEvent ev) {
        switch (ev.getChildType()) {
            case 7: {
                ((Transformation)ev.getNewChildElement()).addTransformationListener(this);
                this.fireTransformationChanged();
                break;
            }
            case 1: {
                ((Appearance)ev.getNewChildElement()).addAppearanceListener(this);
                this.fireAppearanceChanged();
            }
        }
    }

    public void childRemoved(SceneGraphComponentEvent ev) {
        switch (ev.getChildType()) {
            case 7: {
                ((Transformation)ev.getOldChildElement()).removeTransformationListener(this);
                this.fireTransformationChanged();
                break;
            }
            case 1: {
                ((Appearance)ev.getNewChildElement()).addAppearanceListener(this);
                this.fireAppearanceChanged();
            }
        }
    }

    public void childReplaced(SceneGraphComponentEvent ev) {
        if (ev.getChildType() == 7 || ev.getChildType() == 1) {
            this.childRemoved(ev);
            this.childAdded(ev);
        }
    }

    public void visibilityChanged(SceneGraphComponentEvent ev) {
    }
}

